/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final Map<RelativePath, Action<OutputStream>> elements = new LinkedHashMap<RelativePath, Action<OutputStream>>();
    private final Factory<File> tmpDirSource;
    private final Chmod chmod;

    public MapFileTree(final File tmpDir, Chmod chmod) {
        this(new Factory<File>(){

            public File create() {
                return tmpDir;
            }
        }, chmod);
    }

    public MapFileTree(Factory<File> tmpDirSource, Chmod chmod) {
        this.tmpDirSource = tmpDirSource;
        this.chmod = chmod;
    }

    private File getTmpDir() {
        return (File)this.tmpDirSource.create();
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    @Override
    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.getTmpDir());
    }

    @Override
    public void visit(FileVisitor visitor) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Visit visit = new Visit(visitor, stopFlag);
        for (Map.Entry<RelativePath, Action<OutputStream>> entry : this.elements.entrySet()) {
            if (stopFlag.get()) break;
            RelativePath path = entry.getKey();
            Action<OutputStream> generator = entry.getValue();
            visit.visit(path, generator);
        }
    }

    public Set<File> getFilesWithoutCreating() {
        return CollectionUtils.collect(this.elements.keySet(), (Transformer)new Transformer<File, RelativePath>(){

            public File transform(RelativePath relativePath) {
                return MapFileTree.this.createFileInstance(relativePath);
            }
        });
    }

    public void add(String path, Closure contentClosure) {
        ClosureBackedAction action = new ClosureBackedAction(contentClosure);
        this.add(path, (Action<OutputStream>)action);
    }

    public void add(String path, Action<OutputStream> contentWriter) {
        this.elements.put(RelativePath.parse(true, path), contentWriter);
    }

    private File createFileInstance(RelativePath path) {
        return path.getFile(this.getTmpDir());
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private final Action<OutputStream> generator;
        private final long lastModified;
        private final AtomicBoolean stopFlag;
        private File file;

        public FileVisitDetailsImpl(RelativePath path, Action<OutputStream> generator, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.path = path;
            this.generator = generator;
            this.stopFlag = stopFlag;
            this.lastModified = System.currentTimeMillis() / 1000L * 1000L;
        }

        @Override
        public String getDisplayName() {
            return this.path.toString();
        }

        @Override
        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        @Override
        public File getFile() {
            if (this.file == null) {
                this.file = MapFileTree.this.createFileInstance(this.path);
                this.copyTo(this.file);
            }
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return !this.path.isFile();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public void copyTo(OutputStream outstr) {
            this.generator.execute((Object)outstr);
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Visit {
        private final Set<RelativePath> visitedDirs = new LinkedHashSet<RelativePath>();
        private final FileVisitor visitor;
        private final AtomicBoolean stopFlag;

        public Visit(FileVisitor visitor, AtomicBoolean stopFlag) {
            this.visitor = visitor;
            this.stopFlag = stopFlag;
        }

        private void visitDirs(RelativePath path, FileVisitor visitor) {
            if (path == null || path.getParent() == null || !this.visitedDirs.add(path)) {
                return;
            }
            this.visitDirs(path.getParent(), visitor);
            visitor.visitDir(new FileVisitDetailsImpl(path, null, this.stopFlag, MapFileTree.this.chmod));
        }

        public void visit(RelativePath path, Action<OutputStream> generator) {
            this.visitDirs(path.getParent(), this.visitor);
            this.visitor.visitFile(new FileVisitDetailsImpl(path, generator, this.stopFlag, MapFileTree.this.chmod));
        }
    }
}

