/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.plugins.DeferredConfigurable;
import org.gradle.internal.UncheckedException;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsStorage {
    private final Map<String, ExtensionHolder> extensions = new LinkedHashMap<String, ExtensionHolder>();

    public void add(String name, Object extension) {
        if (this.extensions.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot add extension with name '%s', as there is an extension already registered with that name.", name));
        }
        this.extensions.put(name, this.wrap(name, extension));
    }

    public boolean hasExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public Map<String, Object> getAsMap() {
        LinkedHashMap<String, Object> rawExtensions = new LinkedHashMap<String, Object>(this.extensions.size());
        for (String name : this.extensions.keySet()) {
            rawExtensions.put(name, this.extensions.get(name).get());
        }
        return rawExtensions;
    }

    public void checkExtensionIsNotReassigned(String name) {
        if (this.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", name));
        }
    }

    public boolean isConfigureExtensionMethod(String methodName, Object ... arguments) {
        return this.extensions.containsKey(methodName) && arguments.length == 1 && arguments[0] instanceof Closure;
    }

    public <T> T configureExtension(String methodName, Object ... arguments) {
        Closure closure = (Closure)arguments[0];
        ClosureBackedAction action = new ClosureBackedAction(closure);
        ExtensionHolder extensionHolder = this.extensions.get(methodName);
        return extensionHolder.configure(action);
    }

    public <T> void configureExtension(Class<T> type, Action<? super T> action) {
        this.getHolderByType(type).configure(action);
    }

    public <T> T getByType(Class<T> type) {
        return this.getHolderByType(type).get();
    }

    public <T> T findByType(Class<T> type) {
        ExtensionHolder<T> holder;
        try {
            holder = this.getHolderByType(type);
        }
        catch (UnknownDomainObjectException e) {
            return null;
        }
        return holder.get();
    }

    private <T> ExtensionHolder<T> getHolderByType(Class<T> type) {
        LinkedList<String> types = new LinkedList<String>();
        for (ExtensionHolder extensionHolder : this.extensions.values()) {
            Class<?> clazz = extensionHolder.getType();
            types.add(clazz.getSimpleName());
            if (!type.isAssignableFrom(clazz)) continue;
            return extensionHolder;
        }
        throw new UnknownDomainObjectException("Extension of type '" + type.getSimpleName() + "' does not exist. Currently registered extension types: " + types);
    }

    public Object getByName(String name) {
        if (!this.hasExtension(name)) {
            throw new UnknownDomainObjectException("Extension with name '" + name + "' does not exist. Currently registered extension names: " + this.extensions.keySet());
        }
        return this.findByName(name);
    }

    public Object findByName(String name) {
        ExtensionHolder extensionHolder = this.extensions.get(name);
        return extensionHolder == null ? null : extensionHolder.get();
    }

    private <T> ExtensionHolder<T> wrap(String name, T extension) {
        if (this.isDeferredConfigurable(extension)) {
            return new DeferredConfigurableExtensionHolder<T>(name, extension);
        }
        return new ExtensionHolder(extension);
    }

    private <T> boolean isDeferredConfigurable(T extension) {
        return extension.getClass().isAnnotationPresent(DeferredConfigurable.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeferredConfigurableExtensionHolder<T>
    extends ExtensionHolder<T> {
        private final String name;
        private ActionBroadcast<T> actions = new ActionBroadcast();
        private boolean configured;
        private Throwable configureFailure;

        public DeferredConfigurableExtensionHolder(String name, T extension) {
            super(extension);
            this.name = name;
        }

        @Override
        public T get() {
            this.configureNow();
            return (T)this.extension;
        }

        @Override
        public T configure(Action<? super T> action) {
            this.configureLater(action);
            return null;
        }

        private void configureLater(Action<? super T> action) {
            if (this.configured) {
                throw new InvalidUserDataException(String.format("Cannot configure the '%s' extension after it has been accessed.", this.name));
            }
            this.actions.add(action);
        }

        private void configureNow() {
            if (!this.configured) {
                this.configured = true;
                try {
                    this.actions.execute(this.extension);
                }
                catch (Throwable t) {
                    this.configureFailure = t;
                }
                this.actions = null;
            }
            if (this.configureFailure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.configureFailure);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionHolder<T> {
        protected final T extension;

        private ExtensionHolder(T extension) {
            this.extension = extension;
        }

        public Class<?> getType() {
            return this.extension.getClass();
        }

        public T get() {
            return this.extension;
        }

        public T configure(Closure configuration) {
            return this.configure((Action<? super T>)new ClosureBackedAction(configuration));
        }

        public T configure(Action<? super T> action) {
            action.execute(this.extension);
            return this.extension;
        }
    }
}

