/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.GradleException;
import org.gradle.launcher.daemon.server.health.DaemonStats;

class DaemonStatus {
    public static final String EXPIRE_AT_PROPERTY = "org.gradle.daemon.performance.expire-at";
    static final int DEFAULT_EXPIRE_AT = 0;

    DaemonStatus() {
    }

    boolean isDaemonTired(DaemonStats stats) {
        String expireAt = System.getProperty(EXPIRE_AT_PROPERTY);
        int threshold = DaemonStatus.parseValue(expireAt, 0);
        return threshold != 0 && stats.getMemoryUsed() > 85 && stats.getCurrentPerformance() <= threshold;
    }

    private static int parseValue(String expireAt, int defaultValue) {
        if (expireAt == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(expireAt);
        }
        catch (Exception e) {
            throw new GradleException(String.format("System property '%s' has incorrect value: '%s'. The value needs to be integer.", EXPIRE_AT_PROPERTY, expireAt));
        }
    }
}

