/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.coffeescript.CoffeeScriptSourceSet;
import org.gradle.language.coffeescript.internal.DefaultCoffeeScriptSourceSet;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.tasks.PlayCoffeeScriptCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayCoffeeScriptPlugin
extends RuleSource {
    private static final String DEFAULT_COFFEESCRIPT_VERSION = "1.8.0";
    private static final String DEFAULT_RHINO_VERSION = "1.7R4";

    static String getDefaultCoffeeScriptDependencyNotation() {
        return String.format("org.coffeescript:coffee-script-js:%s@js", DEFAULT_COFFEESCRIPT_VERSION);
    }

    static String getDefaultRhinoDependencyNotation() {
        return String.format("org.mozilla:rhino:%s", DEFAULT_RHINO_VERSION);
    }

    @LanguageType
    void registerCoffeeScript(LanguageTypeBuilder<CoffeeScriptSourceSet> builder) {
        builder.setLanguageName("coffeeScript");
        builder.defaultImplementation(DefaultCoffeeScriptSourceSet.class);
    }

    @Mutate
    void createCoffeeScriptSourceSets(ModelMap<PlayApplicationSpec> components) {
        components.afterEach((Action)new Action<PlayApplicationSpec>(){

            public void execute(PlayApplicationSpec playComponent) {
                playComponent.getSources().create("coffeeScript", CoffeeScriptSourceSet.class, (Action)new Action<CoffeeScriptSourceSet>(){

                    public void execute(CoffeeScriptSourceSet coffeeScriptSourceSet) {
                        coffeeScriptSourceSet.getSource().srcDir((Object)"app/assets");
                        coffeeScriptSourceSet.getSource().include(new String[]{"**/*.coffee"});
                    }
                });
            }
        });
    }

    @Mutate
    void createGeneratedJavaScriptSourceSets(ModelMap<PlayApplicationBinarySpec> binaries, ServiceRegistry serviceRegistry) {
        final FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
        final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        binaries.all((Action)new Action<PlayApplicationBinarySpec>(){

            public void execute(PlayApplicationBinarySpec playApplicationBinarySpec) {
                for (CoffeeScriptSourceSet coffeeScriptSourceSet : playApplicationBinarySpec.getInputs().withType(CoffeeScriptSourceSet.class)) {
                    JavaScriptSourceSet javaScriptSourceSet = (JavaScriptSourceSet)BaseLanguageSourceSet.create(DefaultJavaScriptSourceSet.class, (String)String.format("%sJavaScript", coffeeScriptSourceSet.getName()), (String)playApplicationBinarySpec.getName(), (FileResolver)fileResolver, (Instantiator)instantiator);
                    playApplicationBinarySpec.getGeneratedJavaScript().put(coffeeScriptSourceSet, javaScriptSourceSet);
                }
            }
        });
    }

    @BinaryTasks
    void createCoffeeScriptTasks(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary, final @Path(value="buildDir") File buildDir) {
        tasks.beforeEach(PlayCoffeeScriptCompile.class, (Action)new Action<PlayCoffeeScriptCompile>(){

            public void execute(PlayCoffeeScriptCompile coffeeScriptCompile) {
                coffeeScriptCompile.setRhinoClasspathNotation(PlayCoffeeScriptPlugin.getDefaultRhinoDependencyNotation());
                coffeeScriptCompile.setCoffeeScriptJsNotation(PlayCoffeeScriptPlugin.getDefaultCoffeeScriptDependencyNotation());
            }
        });
        for (final CoffeeScriptSourceSet coffeeScriptSourceSet : binary.getInputs().withType(CoffeeScriptSourceSet.class)) {
            if (!((LanguageSourceSetInternal)coffeeScriptSourceSet).getMayHaveSources()) continue;
            final String compileTaskName = "compile" + StringUtils.capitalize((String)binary.getName()) + StringUtils.capitalize((String)coffeeScriptSourceSet.getName());
            tasks.create(compileTaskName, PlayCoffeeScriptCompile.class, (Action)new Action<PlayCoffeeScriptCompile>(){

                public void execute(PlayCoffeeScriptCompile coffeeScriptCompile) {
                    coffeeScriptCompile.setDescription("Compiles coffeescript for the '" + coffeeScriptSourceSet.getName() + "' source set.");
                    File outputDirectory = PlayCoffeeScriptPlugin.this.outputDirectory(buildDir, binary, compileTaskName);
                    coffeeScriptCompile.setDestinationDir(outputDirectory);
                    coffeeScriptCompile.setSource(coffeeScriptSourceSet.getSource());
                    JavaScriptSourceSet javaScriptSourceSet = binary.getGeneratedJavaScript().get(coffeeScriptSourceSet);
                    javaScriptSourceSet.getSource().srcDir((Object)outputDirectory);
                    javaScriptSourceSet.builtBy(new Object[]{coffeeScriptCompile});
                }
            });
        }
    }

    private File outputDirectory(File buildDir, PlayApplicationBinarySpec binary, String taskName) {
        return new File(buildDir, String.format("%s/src/%s", binary.getName(), taskName));
    }
}

