/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.ConditionGen;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.attributes.nodes.ForceReturnAttr;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.parser.FieldValueAttr;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.TryCatchRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.regions.loops.ForEachLoop;
import jadx.core.dex.regions.loops.ForLoop;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionGen
extends InsnGen {
    private static final Logger LOG = LoggerFactory.getLogger(RegionGen.class);

    public RegionGen(MethodGen mgen) {
        super(mgen, false);
    }

    public void makeRegion(CodeWriter code, IContainer cont) throws CodegenException {
        if (cont instanceof IBlock) {
            this.makeSimpleBlock((IBlock)cont, code);
        } else if (cont instanceof IRegion) {
            if (cont instanceof Region) {
                this.makeSimpleRegion(code, (Region)cont);
            } else {
                this.declareVars(code, cont);
                if (cont instanceof IfRegion) {
                    this.makeIf((IfRegion)cont, code, true);
                } else if (cont instanceof SwitchRegion) {
                    this.makeSwitch((SwitchRegion)cont, code);
                } else if (cont instanceof LoopRegion) {
                    this.makeLoop((LoopRegion)cont, code);
                } else if (cont instanceof TryCatchRegion) {
                    this.makeTryCatch((TryCatchRegion)cont, code);
                } else if (cont instanceof SynchronizedRegion) {
                    this.makeSynchronizedRegion((SynchronizedRegion)cont, code);
                }
            }
        } else {
            throw new CodegenException("Not processed container: " + cont);
        }
    }

    private void declareVars(CodeWriter code, IContainer cont) {
        DeclareVariablesAttr declVars = cont.get(AType.DECLARE_VARIABLES);
        if (declVars != null) {
            for (RegisterArg v : declVars.getVars()) {
                code.startLine();
                this.declareVar(code, v);
                code.add(';');
            }
        }
    }

    private void makeSimpleRegion(CodeWriter code, Region region) throws CodegenException {
        this.declareVars(code, region);
        for (IContainer c : region.getSubBlocks()) {
            this.makeRegion(code, c);
        }
    }

    public void makeRegionIndent(CodeWriter code, IContainer region) throws CodegenException {
        code.incIndent();
        this.makeRegion(code, region);
        code.decIndent();
    }

    private void makeSimpleBlock(IBlock block, CodeWriter code) throws CodegenException {
        for (InsnNode insn : block.getInstructions()) {
            if (insn.contains(AFlag.SKIP)) continue;
            this.makeInsn(insn, code);
        }
        ForceReturnAttr retAttr = block.get(AType.FORCE_RETURN);
        if (retAttr != null) {
            this.makeInsn(retAttr.getReturnInsn(), code);
        }
    }

    private void makeIf(IfRegion region, CodeWriter code, boolean newLine) throws CodegenException {
        if (newLine) {
            code.startLineWithNum(region.getSourceLine());
        } else {
            code.attachSourceLine(region.getSourceLine());
        }
        code.add("if (");
        new ConditionGen(this).add(code, region.getCondition());
        code.add(") {");
        this.makeRegionIndent(code, region.getThenRegion());
        code.startLine('}');
        IContainer els = region.getElseRegion();
        if (els != null && RegionUtils.notEmpty(els)) {
            code.add(" else ");
            if (this.connectElseIf(code, els)) {
                return;
            }
            code.add('{');
            this.makeRegionIndent(code, els);
            code.startLine('}');
        }
    }

    private boolean connectElseIf(CodeWriter code, IContainer els) throws CodegenException {
        if (!els.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        if (!(els instanceof Region)) {
            return false;
        }
        List<IContainer> subBlocks = ((Region)els).getSubBlocks();
        if (subBlocks.size() == 1 && subBlocks.get(0) instanceof IfRegion) {
            this.makeIf((IfRegion)subBlocks.get(0), code, false);
            return true;
        }
        return false;
    }

    private CodeWriter makeLoop(LoopRegion region, CodeWriter code) throws CodegenException {
        IfCondition condition;
        LoopLabelAttr labelAttr;
        List<InsnNode> headerInsns;
        BlockNode header = region.getHeader();
        if (header != null && (headerInsns = header.getInstructions()).size() > 1) {
            ErrorsCounter.methodError(this.mth, "Found not inlined instructions from loop header");
            int last = headerInsns.size() - 1;
            for (int i = 0; i < last; ++i) {
                InsnNode insn = headerInsns.get(i);
                this.makeInsn(insn, code);
            }
        }
        if ((labelAttr = region.getInfo().getStart().get(AType.LOOP_LABEL)) != null) {
            code.startLine(this.mgen.getNameGen().getLoopLabel(labelAttr)).add(':');
        }
        if ((condition = region.getCondition()) == null) {
            code.startLine("while (true) {");
            this.makeRegionIndent(code, region.getBody());
            code.startLine('}');
            return code;
        }
        ConditionGen conditionGen = new ConditionGen(this);
        LoopType type = region.getType();
        if (type != null) {
            if (type instanceof ForLoop) {
                ForLoop forLoop = (ForLoop)type;
                code.startLine("for (");
                this.makeInsn(forLoop.getInitInsn(), code, InsnGen.Flags.INLINE);
                code.add("; ");
                conditionGen.add(code, condition);
                code.add("; ");
                this.makeInsn(forLoop.getIncrInsn(), code, InsnGen.Flags.INLINE);
                code.add(") {");
                this.makeRegionIndent(code, region.getBody());
                code.startLine('}');
                return code;
            }
            if (type instanceof ForEachLoop) {
                ForEachLoop forEachLoop = (ForEachLoop)type;
                code.startLine("for (");
                this.declareVar(code, forEachLoop.getVarArg());
                code.add(" : ");
                this.addArg(code, forEachLoop.getIterableArg(), false);
                code.add(") {");
                this.makeRegionIndent(code, region.getBody());
                code.startLine('}');
                return code;
            }
            throw new JadxRuntimeException("Unknown loop type: " + type.getClass());
        }
        if (region.isConditionAtEnd()) {
            code.startLine("do {");
            this.makeRegionIndent(code, region.getBody());
            code.startLine("} while (");
            conditionGen.add(code, condition);
            code.add(");");
        } else {
            code.startLine("while (");
            conditionGen.add(code, condition);
            code.add(") {");
            this.makeRegionIndent(code, region.getBody());
            code.startLine('}');
        }
        return code;
    }

    private void makeSynchronizedRegion(SynchronizedRegion cont, CodeWriter code) throws CodegenException {
        code.startLine("synchronized (");
        this.addArg(code, cont.getEnterInsn().getArg(0));
        code.add(") {");
        this.makeRegionIndent(code, cont.getRegion());
        code.startLine('}');
    }

    private CodeWriter makeSwitch(SwitchRegion sw, CodeWriter code) throws CodegenException {
        SwitchNode insn = (SwitchNode)sw.getHeader().getInstructions().get(0);
        InsnArg arg = insn.getArg(0);
        code.startLine("switch (");
        this.addArg(code, arg, false);
        code.add(") {");
        code.incIndent();
        int size = sw.getKeys().size();
        for (int i = 0; i < size; ++i) {
            List<Object> keys = sw.getKeys().get(i);
            IContainer c = sw.getCases().get(i);
            for (Object k : keys) {
                code.startLine("case ");
                if (k instanceof FieldNode) {
                    FieldNode fn = (FieldNode)k;
                    if (fn.getParentClass().isEnum()) {
                        code.add(fn.getAlias());
                    } else {
                        this.staticField(code, fn.getFieldInfo());
                        FieldValueAttr valueAttr = fn.get(AType.FIELD_VALUE);
                        if (valueAttr != null && valueAttr.getValue() != null) {
                            code.add(" /*").add(valueAttr.getValue().toString()).add("*/");
                        }
                    }
                } else if (k instanceof Integer) {
                    code.add(TypeGen.literalToString(((Integer)k).intValue(), arg.getType()));
                } else {
                    throw new JadxRuntimeException("Unexpected key in switch: " + (k != null ? k.getClass() : null));
                }
                code.add(':');
            }
            this.makeRegionIndent(code, c);
        }
        if (sw.getDefaultCase() != null) {
            code.startLine("default:");
            this.makeRegionIndent(code, sw.getDefaultCase());
        }
        code.decIndent();
        code.startLine('}');
        return code;
    }

    private void makeTryCatch(TryCatchRegion region, CodeWriter code) throws CodegenException {
        IContainer finallyRegion;
        code.startLine("try {");
        this.makeRegionIndent(code, region.getTryRegion());
        ExceptionHandler allHandler = null;
        for (Map.Entry<ExceptionHandler, IContainer> entry : region.getCatchRegions().entrySet()) {
            ExceptionHandler handler = entry.getKey();
            if (handler.isCatchAll()) {
                if (allHandler != null) {
                    LOG.warn("Several 'all' handlers in try/catch block in {}", (Object)this.mth);
                }
                allHandler = handler;
                continue;
            }
            this.makeCatchBlock(code, handler);
        }
        if (allHandler != null) {
            this.makeCatchBlock(code, allHandler);
        }
        if ((finallyRegion = region.getFinallyRegion()) != null) {
            code.startLine("} finally {");
            this.makeRegionIndent(code, finallyRegion);
        }
        code.startLine('}');
    }

    private void makeCatchBlock(CodeWriter code, ExceptionHandler handler) throws CodegenException {
        IContainer region = handler.getHandlerRegion();
        if (region == null) {
            return;
        }
        code.startLine("} catch (");
        InsnArg arg = handler.getArg();
        if (arg instanceof RegisterArg) {
            this.declareVar(code, (RegisterArg)arg);
        } else if (arg instanceof NamedArg) {
            if (handler.isCatchAll()) {
                code.add("Throwable");
            } else {
                this.useClass(code, handler.getCatchType());
            }
            code.add(' ');
            code.add(this.mgen.getNameGen().assignNamedArg((NamedArg)arg));
        }
        code.add(") {");
        this.makeRegionIndent(code, region);
    }
}

