/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.util.Logger;

public class JaguarReader
extends MOReader {
    private int moCount = 0;
    private float lumoEnergy = Float.MAX_VALUE;
    private static final float ROOT3 = 1.7320508f;
    private boolean haveLine;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Input geometry:") || this.line.startsWith(" Symmetrized geometry:") || this.line.startsWith("  final geometry:")) {
            this.readAtoms();
            return true;
        }
        if (this.line.startsWith("  Atomic charges from electrostatic potential:")) {
            this.readCharges();
            return true;
        }
        if (this.line.startsWith("  number of basis functions....")) {
            this.moCount = this.parseIntAt(this.line, 32);
            return true;
        }
        if (this.line.startsWith("  basis set:")) {
            this.moData.put("energyUnits", "");
            this.calculationType = this.line.substring(13).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("XXXXXShell information") >= 0) {
            this.readUnnormalizedBasis();
            return true;
        }
        if (this.line.indexOf("Normalized coefficients") >= 0) {
            this.readBasisNormalized();
            return true;
        }
        if (this.line.startsWith(" LUMO energy:")) {
            this.lumoEnergy = this.parseFloatStr(this.line.substring(13));
            return true;
        }
        if (this.line.indexOf("final wvfn") >= 0) {
            this.readJaguarMolecularOrbitals();
            return true;
        }
        if (this.line.startsWith("  harmonic frequencies in")) {
            this.readFrequencies();
            this.continuing = false;
            return false;
        }
        return this.checkNboLine();
    }

    private void readAtoms() throws Exception {
        this.discardPreviousAtoms();
        this.readLines(2);
        while (this.rd() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String[] stringArray = this.getTokens();
            String string = stringArray[0];
            if (string.length() < 2) {
                return;
            }
            char c = string.charAt(1);
            String string2 = c >= 'a' && c <= 'z' ? string.substring(0, 2) : string.substring(0, 1);
            this.addAtomXYZSymName(stringArray, 1, string2, string);
        }
    }

    private void readCharges() throws Exception {
        int n = 0;
        while (this.rd() != null && this.line.indexOf("sum") < 0) {
            if (this.line.indexOf("Charge") < 0) continue;
            String[] stringArray = this.getTokens();
            for (int i = 1; i < stringArray.length; ++i) {
                this.asc.atoms[n++].partialCharge = this.parseFloatStr(stringArray[i]);
            }
        }
    }

    private void readUnnormalizedBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        String string = "";
        int n3 = -1;
        int[][] nArray = new int[this.moCount][4];
        Lst<type>[] lstArray = AU.createArrayOfArrayList(this.moCount);
        this.gaussianCount = 0;
        this.discardLinesUntilContains("--------");
        while (this.rd() != null && (stringArray = this.getTokens()).length == 9) {
            int n4 = this.parseIntStr(stringArray[2]);
            if (n4 <= 0) continue;
            if (!stringArray[0].equals(string)) {
                ++n3;
            }
            string = stringArray[0];
            int n5 = this.parseIntStr(stringArray[5]);
            n2 = this.parseIntStr(stringArray[4]);
            if (n2 <= 2) {
                --n2;
            }
            if (lstArray[n5] == null) {
                nArray[n5][0] = n3;
                nArray[n5][1] = n2;
                nArray[n5][2] = 0;
                nArray[n5][3] = 0;
                lstArray[n5] = new Lst();
            }
            float f = 1.0f;
            lstArray[n5].addLast(new float[]{this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]) * f});
            this.gaussianCount += n4;
            n = n4 - 1;
            while (--n >= 0) {
                stringArray = PT.getTokens(this.rd());
                lstArray[n5].addLast(new float[]{this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]) * f});
            }
        }
        float[][] fArray = AU.newFloat2(this.gaussianCount);
        Lst<int[]> lst = new Lst<int[]>();
        this.gaussianCount = 0;
        for (n2 = 0; n2 < this.moCount; ++n2) {
            if (lstArray[n2] == null) continue;
            int n6 = lstArray[n2].size();
            nArray[n2][2] = this.gaussianCount;
            nArray[n2][3] = n6;
            for (n = 0; n < n6; ++n) {
                fArray[this.gaussianCount++] = (float[])lstArray[n2].get(n);
            }
            lst.addLast(nArray[n2]);
        }
        this.moData.put("shells", lst);
        this.moData.put("gaussians", fArray);
        if (this.debugging) {
            Logger.debug(lst.size() + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readBasisNormalized() throws Exception {
        int n;
        Object object;
        Object object2 = "";
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        Lst<int[]> lst = new Lst<int[]>();
        Lst<float[]> lst2 = new Lst<float[]>();
        this.gaussianCount = 0;
        int[] nArray = null;
        this.discardLinesUntilContains("--------");
        while (this.rd() != null && this.line.length() > 3) {
            float[] fArray;
            object = this.getTokens();
            if (((float[][])object).length == 4) {
                fArray = object[0];
                continue;
            }
            if (!object[0].equals(object2)) {
                ++n2;
            }
            object2 = object[0];
            fArray = object[2];
            n = BasisFunctionReader.getQuantumShellTagID((String)fArray);
            n3 = this.parseIntStr((String)object[3]) - 1;
            if (n3 != n4) {
                nArray = new int[]{n2, n, this.gaussianCount, 0};
                lst.addLast(nArray);
                n4 = n3;
            }
            ++this.gaussianCount;
            nArray[3] = nArray[3] + true;
            float f = this.parseFloatStr((String)object[4]);
            float f2 = this.parseFloatStr((String)object[5]);
            if (fArray.equals("XX")) {
                f2 *= 1.7320508f;
            }
            lst2.addLast(new float[]{f, f2});
        }
        object = AU.newFloat2(this.gaussianCount);
        n = lst2.size();
        while (--n >= 0) {
            object[n] = (float[])lst2.get(n);
        }
        this.moData.put("shells", lst);
        this.moData.put("gaussians", object);
        if (this.debugging) {
            Logger.debug(lst.size() + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
        this.moData.put("isNormalized", Boolean.TRUE);
    }

    private void readJaguarMolecularOrbitals() throws Exception {
        String[][] stringArray = new String[this.moCount][];
        this.rd();
        this.rd();
        this.rd();
        int n = 0;
        while (this.line != null) {
            this.rd();
            this.rd();
            this.rd();
            if (this.line == null || this.line.indexOf("eigenvalues-") < 0) break;
            String[] stringArray2 = this.getTokens();
            int n2 = stringArray2.length - 1;
            this.fillDataBlock(stringArray, 0);
            float f = 2.0f;
            for (int i = 0; i < n2; ++i) {
                float[] fArray = new float[this.moCount];
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                float f2 = this.parseFloatStr(stringArray2[i + 1]);
                hashtable.put("energy", Float.valueOf(f2));
                if ((double)Math.abs(f2 - this.lumoEnergy) < 1.0E-4) {
                    this.moData.put("HOMO", n);
                    this.lumoEnergy = Float.MAX_VALUE;
                    f = 0.0f;
                }
                hashtable.put("occupancy", Float.valueOf(f));
                ++n;
                int n3 = 0;
                for (int j = 0; j < this.moCount; ++j) {
                    fArray[n3++] = this.parseFloatStr(stringArray[j][i + 3]);
                }
                hashtable.put("coefficients", fArray);
                this.setMO(hashtable);
            }
        }
        this.moData.put("mos", this.orbitals);
        this.finalizeMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        int n = this.asc.getLastAtomSetAtomCount();
        this.discardLinesUntilStartsWith("  frequencies ");
        while (this.line != null && this.line.startsWith("  frequencies ")) {
            int n2 = this.asc.ac;
            String[] stringArray = this.getTokens();
            int n3 = stringArray.length - 1;
            boolean[] blArray = new boolean[n3];
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            while (this.line != null && this.line.charAt(2) != ' ') {
                if (this.line.indexOf("symmetries") >= 0) {
                    stringArray2 = this.getTokens();
                } else if (this.line.indexOf("intensities") >= 0) {
                    stringArray3 = this.getTokens();
                }
                this.rd();
            }
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.asc.cloneFirstAtomSet(0);
                this.asc.setAtomSetFrequency(null, stringArray2 == null ? null : stringArray2[i + 1], stringArray[i + 1], null);
                if (stringArray3 == null) continue;
                this.asc.setAtomSetModelProperty("IRIntensity", stringArray3[i + 1] + " km/mol");
            }
            this.haveLine = true;
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 0);
            this.rd();
            this.rd();
        }
    }

    @Override
    public String rd() throws Exception {
        if (!this.haveLine) {
            return super.rd();
        }
        this.haveLine = false;
        return this.line;
    }
}

