/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;
import org.jmol.util.Shader;

public class SphereRenderer {
    private final Graphics3D g3d;
    private final Shader shader;
    private static final int maxOddSizeSphere = 49;
    static final int maxSphereDiameter = 1000;
    static final int maxSphereDiameter2 = 2000;
    private double[] zroot = new double[2];
    private M3 mat;
    private double[] coef;
    private M4 mDeriv;
    private int selectedOctant;
    private int planeShade;
    private int[] zbuf;
    private int width;
    private int height;
    private int depth;
    private int slab;
    private int offsetPbufBeginLine;
    private static final int SHADE_SLAB_CLIPPED = 47;
    private final P3 ptTemp = new P3();
    private final int[] planeShades = new int[3];
    private final float[][] dxyz = new float[3][3];

    SphereRenderer(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.shader = graphics3D.shader;
    }

    void render(int[] nArray, int n, int n2, int n3, int n4, M3 m3, double[] dArray, M4 m4, int n5, P3[] p3Array) {
        float f;
        if (n4 == 1) {
            return;
        }
        if (n > 49) {
            n &= 0xFFFFFFFE;
        }
        if (this.g3d.isClippedXY(n, n2, n3)) {
            return;
        }
        this.slab = this.g3d.slab;
        this.depth = this.g3d.depth;
        int n6 = n + 1 >> 1;
        int n7 = n4 - n6;
        if (n4 + n6 < this.slab || n7 > this.depth) {
            return;
        }
        int n8 = n2 - n6;
        int n9 = n2 + n6;
        int n10 = n3 - n6;
        int n11 = n3 + n6;
        this.shader.nIn = 0;
        this.shader.nOut = 0;
        this.zbuf = this.g3d.zbuf;
        this.height = this.g3d.height;
        this.width = this.g3d.width;
        this.offsetPbufBeginLine = this.width * n3 + n2;
        Shader shader = this.shader;
        this.mat = m3;
        if (m3 != null) {
            this.coef = dArray;
            this.mDeriv = m4;
            this.selectedOctant = n5;
            if (shader.ellipsoidShades == null) {
                shader.createEllipsoidShades();
            }
            if (p3Array != null) {
                this.planeShade = -1;
                for (int i = 0; i < 3; ++i) {
                    float f2 = p3Array[i].x - (float)n2;
                    this.dxyz[i][0] = f2;
                    float f3 = f2;
                    float f4 = p3Array[i].y - (float)n3;
                    this.dxyz[i][1] = f4;
                    float f5 = f4;
                    float f6 = p3Array[i].z - (float)n4;
                    this.dxyz[i][2] = f6;
                    f = f6;
                    this.planeShades[i] = shader.getShadeIndex(f3, f5, -f);
                    if (f3 != 0.0f || f5 != 0.0f) continue;
                    this.planeShade = this.planeShades[i];
                    break;
                }
            }
        }
        if (m3 != null || n > 128) {
            this.renderQuadrant(-1, -1, n2, n3, n4, n, nArray);
            this.renderQuadrant(-1, 1, n2, n3, n4, n, nArray);
            this.renderQuadrant(1, -1, n2, n3, n4, n, nArray);
            this.renderQuadrant(1, 1, n2, n3, n4, n, nArray);
            if (m3 != null) {
                this.mat = null;
                this.coef = null;
                this.mDeriv = null;
            }
        } else {
            int[] nArray2 = shader.sphereShapeCache[n - 1];
            if (nArray2 == null) {
                float f7;
                float f8;
                int n12 = 0;
                boolean bl = (n & 1) != 0;
                f = (float)n / 2.0f;
                float f9 = f * f;
                n6 = (n + 1) / 2;
                float f10 = bl ? 0.0f : 0.5f;
                int n13 = 0;
                while (n13 < n6) {
                    float f11 = f10 * f10;
                    f8 = bl ? 0.0f : 0.5f;
                    int n14 = 0;
                    while (n14 < n6) {
                        float f12 = f8 * f8;
                        f7 = f9 - f11 - f12;
                        if (f7 >= 0.0f) {
                            ++n12;
                        }
                        ++n14;
                        f8 += 1.0f;
                    }
                    ++n13;
                    f10 += 1.0f;
                }
                nArray2 = new int[n12];
                n13 = 0;
                f10 = bl ? 0.0f : 0.5f;
                int n15 = 0;
                while (n15 < n6) {
                    f8 = f10 * f10;
                    float f13 = bl ? 0.0f : 0.5f;
                    int n16 = 0;
                    while (n16 < n6) {
                        f7 = f13 * f13;
                        float f14 = f9 - f8 - f7;
                        if (f14 >= 0.0f) {
                            float f15 = (float)Math.sqrt(f14);
                            int n17 = (int)f15;
                            byte by = shader.getShadeN(f13, f10, f15, f);
                            byte by2 = shader.getShadeN(-f13, f10, f15, f);
                            byte by3 = shader.getShadeN(f13, -f10, f15, f);
                            byte by4 = shader.getShadeN(-f13, -f10, f15, f);
                            int n18 = n17 | by << 7 | by2 << 13 | by3 << 19 | by4 << 25;
                            nArray2[n13++] = n18;
                        }
                        ++n16;
                        f13 += 1.0f;
                    }
                    int n19 = n13 - 1;
                    nArray2[n19] = nArray2[n19] | Integer.MIN_VALUE;
                    ++n15;
                    f10 += 1.0f;
                }
                shader.sphereShapeCache[n - 1] = nArray2;
            }
            if (n8 < 0 || n9 >= this.width || n10 < 0 || n11 >= this.height || n7 < this.slab || n4 > this.depth) {
                this.renderSphereClipped(nArray2, n2, n3, n4, n, nArray);
            } else {
                this.renderSphereUnclipped(nArray2, n4, n, nArray);
            }
        }
        this.zbuf = null;
    }

    private void renderSphereUnclipped(int[] nArray, int n, int n2, int[] nArray2) {
        int n3 = 0;
        int n4 = 1 - (n2 & 1);
        int n5 = this.offsetPbufBeginLine;
        int n6 = n5 - n4 * this.width;
        int n7 = (n2 + 1) / 2;
        int[] nArray3 = this.zbuf;
        int n8 = this.width;
        Pixelator pixelator = this.g3d.pixel;
        do {
            int n9;
            int n10 = n5;
            int n11 = n5 - n4;
            int n12 = n6;
            int n13 = n6 - n4;
            do {
                int n14;
                if ((n14 = n - ((n9 = nArray[n3++]) & 0x7F)) < nArray3[n10]) {
                    pixelator.addPixel(n10, n14, nArray2[n9 >> 7 & 0x3F]);
                }
                if (n14 < nArray3[n11]) {
                    pixelator.addPixel(n11, n14, nArray2[n9 >> 13 & 0x3F]);
                }
                if (n14 < nArray3[n12]) {
                    pixelator.addPixel(n12, n14, nArray2[n9 >> 19 & 0x3F]);
                }
                if (n14 < nArray3[n13]) {
                    pixelator.addPixel(n13, n14, nArray2[n9 >> 25 & 0x3F]);
                }
                ++n10;
                --n11;
                ++n12;
                --n13;
            } while (n9 >= 0);
            n5 += n8;
            n6 -= n8;
        } while (--n7 > 0);
    }

    private void renderSphereClipped(int[] nArray, int n, int n2, int n3, int n4, int[] nArray2) {
        int n5 = this.width;
        int n6 = this.height;
        int n7 = 0;
        int n8 = 1 - (n4 & 1);
        int n9 = this.offsetPbufBeginLine;
        int n10 = n9 - n8 * n5;
        int n11 = (n4 + 1) / 2;
        int n12 = n2;
        int n13 = n2 - n8;
        int n14 = (n << 16) + (n2 << 1) ^ 0x33333333;
        int[] nArray3 = nArray2;
        int[] nArray4 = this.zbuf;
        Pixelator pixelator = this.g3d.pixel;
        int n15 = this.slab;
        int n16 = this.depth;
        do {
            int n17;
            boolean bl = n12 >= 0 && n12 < n6;
            boolean bl2 = n13 >= 0 && n13 < n6;
            int n18 = n9;
            int n19 = n9 - n8;
            int n20 = n10;
            int n21 = n10 - n8;
            int n22 = n;
            int n23 = n - n8;
            do {
                boolean bl3;
                int n24;
                boolean bl4 = n23 >= 0 && n23 < n5;
                boolean bl5 = n22 >= 0 && n22 < n5;
                n17 = nArray[n7++];
                int n25 = n17 & 0x7F;
                if (n3 < n15) {
                    n24 = n3 + n25;
                    bl3 = n24 >= n15;
                } else {
                    n24 = n3 - n25;
                    boolean bl6 = bl3 = n24 < n15;
                }
                if (bl3) {
                    n24 = n15;
                }
                if (n24 >= n15 && n24 <= n16) {
                    int n26;
                    if (bl) {
                        if (bl5 && n24 < nArray4[n18]) {
                            n26 = bl3 ? 44 + (n14 >> 7 & 7) : n17 >> 7 & 0x3F;
                            pixelator.addPixel(n18, n24, nArray3[n26]);
                        }
                        if (bl4 && n24 < nArray4[n19]) {
                            n26 = bl3 ? 44 + (n14 >> 13 & 7) : n17 >> 13 & 0x3F;
                            pixelator.addPixel(n19, n24, nArray3[n26]);
                        }
                    }
                    if (bl2) {
                        if (bl5 && n24 < nArray4[n20]) {
                            n26 = bl3 ? 44 + (n14 >> 19 & 7) : n17 >> 19 & 0x3F;
                            pixelator.addPixel(n20, n24, nArray3[n26]);
                        }
                        if (bl4 && n24 < nArray4[n21]) {
                            n26 = bl3 ? 44 + (n14 >> 25 & 7) : n17 >> 25 & 0x3F;
                            pixelator.addPixel(n21, n24, nArray3[n26]);
                        }
                    }
                }
                ++n18;
                --n19;
                ++n20;
                --n21;
                ++n22;
                --n23;
                if (!bl3) continue;
                n14 = (n14 << 16) + (n14 << 1) + n14 & Integer.MAX_VALUE;
            } while (n17 >= 0);
            n9 += n5;
            n10 -= n5;
            ++n12;
            --n13;
        } while (--n11 > 0);
    }

    private void renderQuadrant(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        boolean bl;
        int n7;
        int n8;
        int n9 = (n3 < 0 ? -1 : (n3 < this.width ? 0 : 1)) + ((n8 = n3 + (n7 = n6 / 2) * n) < 0 ? -2 : (n8 < this.width ? 0 : 2));
        if (n9 == -3 || n9 == 3) {
            return;
        }
        int n10 = (n4 < 0 ? -1 : (n4 < this.height ? 0 : 1)) + ((n8 = n4 + n7 * n2) < 0 ? -2 : (n8 < this.height ? 0 : 2));
        if (n10 == -3 || n10 == 3) {
            return;
        }
        boolean bl2 = bl = this.mat == null && n9 == 0 && n10 == 0 && n5 - n7 >= this.slab && n5 <= this.depth;
        if (bl) {
            this.renderQuadrantUnclipped(n7, n, n2, n5, nArray);
        } else {
            this.renderQuadrantClipped(n7, n, n2, n3, n4, n5, nArray);
        }
    }

    private void renderQuadrantUnclipped(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = n * n;
        int n6 = n * 2 + 1;
        int n7 = n3 < 0 ? -this.width : this.width;
        int n8 = this.offsetPbufBeginLine;
        int[] nArray2 = this.zbuf;
        Pixelator pixelator = this.g3d.pixel;
        byte[] byArray = this.shader.sphereShadeIndexes;
        int n9 = 0;
        int n10 = 0;
        while (n10 <= n5) {
            int n11 = n8;
            int n12 = n5 - n10;
            int n13 = n4 - n;
            int n14 = (n9 * n3 + n << 8) / n6;
            int n15 = 0;
            int n16 = 0;
            while (n16 <= n12) {
                int n17;
                if (nArray2[n11] > n13 && nArray2[n11] > (n13 = n4 - (n17 = (int)Math.sqrt(n12 - n16)))) {
                    int n18 = (n15 * n2 + n << 8) / n6;
                    pixelator.addPixel(n11, n13, nArray[byArray[(n14 << 8) + n18]]);
                }
                n16 += n15++ + n15;
                n11 += n2;
            }
            n10 += n9++ + n9;
            n8 += n7;
        }
    }

    private void renderQuadrantClipped(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        boolean bl = this.mat != null;
        boolean bl2 = this.selectedOctant >= 0;
        int n7 = n * n;
        int n8 = n * 2 + 1;
        int n9 = n3 < 0 ? -this.width : this.width;
        int n10 = this.offsetPbufBeginLine;
        int n11 = (n4 << 16) + (n5 << 1) ^ 0x33333333;
        int n12 = 0;
        int n13 = 0;
        Pixelator pixelator = this.g3d.pixel;
        int n14 = 0;
        int n15 = this.height;
        int n16 = this.width;
        int n17 = n4;
        int[] nArray2 = this.zbuf;
        float[][] fArray = this.dxyz;
        int n18 = n5;
        int n19 = n6;
        int n20 = this.slab;
        int n21 = this.depth;
        P3 p3 = this.ptTemp;
        double[] dArray = this.coef;
        double[] dArray2 = this.zroot;
        int n22 = this.selectedOctant;
        Shader shader = this.shader;
        int[] nArray3 = this.planeShades;
        byte[] byArray = shader.sphereShadeIndexes;
        int n23 = this.planeShade;
        M3 m3 = this.mat;
        int n24 = 0;
        int n25 = 0;
        int n26 = n5;
        while (n25 <= n7) {
            block30: {
                block31: {
                    block29: {
                        if (n26 >= 0) break block29;
                        if (n3 < 0) {
                            return;
                        }
                        break block30;
                    }
                    if (n26 < n15) break block31;
                    if (n3 > 0) {
                        return;
                    }
                    break block30;
                }
                int n27 = n7 - (bl ? 0 : n25);
                if (!bl) {
                    n12 = (n24 * n3 + n << 8) / n8;
                }
                n11 = (n11 << 16) + (n11 << 1) + n11 & Integer.MAX_VALUE;
                int n28 = n17;
                int n29 = 0;
                int n30 = 0;
                int n31 = -1;
                int n32 = 1;
                int n33 = n10;
                while (n30 <= n27) {
                    block33: {
                        int n34;
                        block37: {
                            boolean bl3;
                            block35: {
                                double d;
                                double d2;
                                block36: {
                                    block34: {
                                        block32: {
                                            if (n28 >= 0) break block32;
                                            if (n2 < 0) {
                                                break;
                                            }
                                            break block33;
                                        }
                                        if (n28 < n16) break block34;
                                        if (n2 > 0) {
                                            break;
                                        }
                                        break block33;
                                    }
                                    if (!bl) break block35;
                                    d2 = (dArray[4] * (double)n28 + dArray[5] * (double)n26 + dArray[8]) / dArray[2] / 2.0;
                                    double d3 = (dArray[0] * (double)n28 * (double)n28 + dArray[1] * (double)n26 * (double)n26 + dArray[3] * (double)n28 * (double)n26 + dArray[6] * (double)n28 + dArray[7] * (double)n26 - 1.0) / dArray[2];
                                    d = d2 * d2 - d3;
                                    if (!(d < 0.0)) break block36;
                                    if (n31 >= 0) {
                                        break;
                                    }
                                    break block33;
                                }
                                d = Math.sqrt(d);
                                dArray2[0] = -d2 - d;
                                dArray2[1] = -d2 + d;
                                n31 = n19 < n20 ? 1 : 0;
                                n34 = (int)dArray2[n31];
                                if (n34 == 0) {
                                    n34 = n19;
                                }
                                n32 = 2;
                                n14 = n34;
                                if (bl2) {
                                    int n35;
                                    p3.set(n28 - n17, n26 - n18, n34 - n19);
                                    m3.rotate(p3);
                                    int n36 = 0;
                                    if (p3.x < 0.0f) {
                                        n36 |= 1;
                                    }
                                    if (p3.y < 0.0f) {
                                        n36 |= 2;
                                    }
                                    if (p3.z < 0.0f) {
                                        n36 |= 4;
                                    }
                                    if (n36 == n22) {
                                        if (n23 >= 0) {
                                            n13 = n23;
                                        } else {
                                            n35 = 3;
                                            float f = Float.MAX_VALUE;
                                            for (int i = 0; i < 3; ++i) {
                                                float f2;
                                                float f3 = fArray[i][2];
                                                if (f3 == 0.0f || !((f2 = (float)n19 + (-fArray[i][0] * (float)(n28 - n4) - fArray[i][1] * (float)(n26 - n18)) / f3) < f)) continue;
                                                f = f2;
                                                n35 = i;
                                            }
                                            if (n35 == 3) {
                                                n35 = 0;
                                                f = n19;
                                            }
                                            dArray2[0] = f;
                                            n13 = nArray3[n35];
                                        }
                                        n34 = (int)dArray2[0];
                                        n32 = 3;
                                    }
                                    int n37 = n19 < n20 ? (n34 >= n20 ? 1 : 0) : (n35 = n34 < n20 ? 1 : 0);
                                    if (n35 != 0) {
                                        n14 = n34 = n20;
                                        n32 = 0;
                                    }
                                }
                                if (n34 >= n20 && n34 <= n21 && nArray2[n33] > n14) break block37;
                                break block33;
                            }
                            int n38 = (int)Math.sqrt(n27 - n30);
                            n34 = n19 + (n19 < n20 ? n38 : -n38);
                            boolean bl4 = n19 < n20 ? n34 >= n20 : (bl3 = n34 < n20);
                            if (bl3) {
                                n34 = n20;
                                n32 = 0;
                            }
                            if (n34 < n20 || n34 > n21 || nArray2[n33] <= n34) break block33;
                        }
                        switch (n32) {
                            case 0: {
                                n13 = 44 + (n11 >> 8 & 7);
                                n11 = (n11 << 16) + (n11 << 1) + n11 & Integer.MAX_VALUE;
                                n32 = 1;
                                break;
                            }
                            case 2: {
                                n13 = shader.getEllipsoidShade(n28, n26, (float)dArray2[n31], n, this.mDeriv);
                                break;
                            }
                            case 3: {
                                pixelator.clearPixel(n33, n14);
                                break;
                            }
                            default: {
                                int n39 = (n29 * n2 + n << 8) / n8;
                                n13 = byArray[(n12 << 8) + n39];
                            }
                        }
                        pixelator.addPixel(n33, n34, nArray[n13]);
                    }
                    n30 += n29++ + n29;
                    n33 += n2;
                    n28 += n2;
                }
                n11 = (n11 + n28 + n26 | 1) & Integer.MAX_VALUE;
            }
            n25 += n24++ + n24;
            n10 += n9;
            n26 += n3;
        }
    }
}

