/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TempArray;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    protected IsosurfaceMesh thisMesh;
    private String actualID;
    protected boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private float[] moLinearCombination;
    private int colorType;
    private short defaultColix;
    private short meshColix;
    private P3 center;
    private float scale3d;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    private String scriptAppendix = "";
    protected SurfaceGenerator sg;
    protected JvxlData jvxlData;
    private float withinDistance2;
    private boolean isWithinNot;
    private Lst<P3> withinPoints;
    private float[] cutoffRange;
    boolean allowMesh = true;
    private String script;
    private boolean iHaveModelIndex;
    private int nLCAO = 0;
    private P4 lcaoDir = new P4();
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();
    public int[] keyXy;

    @Override
    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])AU.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.isomeshes[n] = mesh == null ? new IsosurfaceMesh(this.vwr, string, this.colix, n) : (IsosurfaceMesh)mesh;
        this.thisMesh = this.isomeshes[n];
        this.currentMesh = this.isomeshes[n];
        this.currentMesh.index = n;
        if (this.sg != null) {
            this.jvxlData = this.thisMesh.jvxlData;
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    protected void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.vwr, this, null, this.jvxlData);
        this.sg.params.showTiming = this.vwr.getBoolean(603979934);
        this.sg.version = "Jmol " + Viewer.getJmolVersion();
    }

    protected void clearSg() {
        this.sg = null;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        this.setPropI(string, object, bS);
    }

    protected void setPropI(String string, Object object, BS bS) {
        if ("cache" == string) {
            if (this.currentMesh == null) {
                return;
            }
            String string2 = this.currentMesh.thisID;
            int n = this.currentMesh.modelIndex;
            this.vwr.cachePut("cache://isosurface_" + string2, this.getPropI("jvxlDataXml"));
            this.deleteMeshI(this.currentMesh.index);
            this.setPropI("init", null, null);
            this.setPropI("thisID", string2, null);
            this.setPropI("modelIndex", n, null);
            this.setPropI("fileName", "cache://isosurface_" + string2, null);
            this.setPropI("readFile", null, null);
            this.setPropI("finalize", "isosurface ID " + PT.esc(string2) + (n >= 0 ? " modelIndex " + n : "") + " /*file*/" + PT.esc("cache://isosurface_" + string2), null);
            this.setPropI("clear", null, null);
            return;
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bS);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("remapInherited" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.isomeshes[n] == null || !"#inherit;".equals(this.isomeshes[n].colorCommand)) continue;
                this.isomeshes[n].remapColors(this.vwr, null, Float.NaN);
            }
            return;
        }
        if ("remapColor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.remapColors(this.vwr, (ColorEncoder)object, this.translucentLevel);
            }
            return;
        }
        if ("thisID" == string) {
            if (this.actualID != null) {
                object = this.actualID;
            }
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("params" == string) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.checkAllocColixes();
                Object[] objectArray = object;
                short[] sArray = (short[])objectArray[0];
                int[] nArray = null;
                if (sArray != null) {
                    int n;
                    int n2;
                    for (n2 = 0; n2 < sArray.length; ++n2) {
                        n = sArray[n2];
                        float f = 0.0f;
                        if (f > 0.01f) {
                            n = C.getColixTranslucent3((short)n, true, f);
                        }
                        sArray[n2] = n;
                    }
                    nArray = new int[bS.length()];
                    n2 = 0;
                    n = bS.nextSetBit(0);
                    while (n >= 0) {
                        nArray[n] = n2++;
                        n = bS.nextSetBit(n + 1);
                    }
                }
                this.thisMesh.setVertexColixesForAtoms(this.vwr, sArray, nArray, bS);
                this.thisMesh.setVertexColorMap();
            }
            return;
        }
        if ("atomcolor" == string) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.colorVertices(C.getColixO(object), bS, true);
            }
            return;
        }
        if ("pointSize" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.volumeRenderPointSize = ((Float)object).floatValue();
            }
            return;
        }
        if ("vertexcolor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.colorVertices(C.getColixO(object), bS, false);
            }
            return;
        }
        if ("colorPhase" == string) {
            Object[] objectArray = object;
            short s = C.getColix((Integer)objectArray[0]);
            short s2 = C.getColix((Integer)objectArray[1]);
            String string3 = this.thisMesh != null ? this.thisMesh.thisID : (PT.isWild(this.previousMeshID) ? this.previousMeshID : null);
            Lst<Mesh> lst = this.getMeshList(string3, false);
            int n = lst.size();
            while (--n >= 0) {
                this.setColorPhase((IsosurfaceMesh)lst.get(n), s, s2);
            }
            return;
        }
        if ("color" == string) {
            String string4 = C.getHexCode(C.getColixO(object));
            if (this.thisMesh != null) {
                this.setIsoMeshColor(this.thisMesh, string4);
            } else {
                Lst<Mesh> lst = this.getMeshList(PT.isWild(this.previousMeshID) ? this.previousMeshID : null, false);
                int n = lst.size();
                while (--n >= 0) {
                    this.setIsoMeshColor((IsosurfaceMesh)lst.get(n), string4);
                }
            }
            this.setPropertySuper(string, object, bS);
            return;
        }
        if ("nocontour" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.deleteContours();
            }
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setMeshI();
            return;
        }
        if ("newObject" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.clearType(this.thisMesh.meshType, false);
            }
            return;
        }
        if ("moveIsosurface" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.updateCoordinates((M4)object, null);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("refreshTrajectories" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n].connections == null || this.meshes[n].modelIndex != (Integer)((Object[])object)[0]) continue;
                ((IsosurfaceMesh)this.meshes[n]).updateCoordinates((M4)((Object[])object)[2], (BS)((Object[])object)[1]);
            }
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.isFixed = this.modelIndex < 0;
                this.sg.params.modelIndex = Math.abs(this.modelIndex);
            }
            return;
        }
        if ("lcaoCartoon" == string || "lonePair" == string || "radical" == string) {
            V3[] v3Array = (V3[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setProp("lcaoCartoonCenter", v3Array[2], null)) {
                this.drawLcaoCartoon(v3Array[0], v3Array[1], v3Array[3], "lonePair" == string ? 2 : ("radical" == string ? 1 : 0));
            }
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("meshcolor" == string) {
            int n = (Integer)object;
            this.meshColix = C.getColix(n);
            if (this.thisMesh != null) {
                this.thisMesh.meshColix = this.meshColix;
            }
            return;
        }
        if ("offset" == string) {
            P3 p3 = P3.newP((P3)object);
            if (p3.equals(JC.center)) {
                p3 = null;
            }
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(null, p3, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("rotate" == string) {
            P4 p4 = (P4)object;
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(Quat.newP4(p4), null, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("bsDisplay" == string) {
            this.bsDisplay = (BS)object;
            return;
        }
        if ("displayWithin" == string) {
            Object[] objectArray = object;
            this.displayWithinDistance2 = ((Float)objectArray[0]).floatValue();
            this.isDisplayWithinNot = this.displayWithinDistance2 < 0.0f;
            this.displayWithinDistance2 *= this.displayWithinDistance2;
            this.displayWithinPoints = (Lst)objectArray[3];
            if (this.displayWithinPoints.size() == 0) {
                this.displayWithinPoints = this.vwr.ms.getAtomPointVector((BS)objectArray[2]);
            }
            return;
        }
        if ("finalize" == string) {
            if (this.thisMesh != null) {
                String string5 = (String)object;
                if (string5 != null && !string5.startsWith("; isosurface map")) {
                    this.thisMesh.setDiscreteColixes(this.sg.params.contoursDiscrete, this.sg.params.contourColixes);
                    this.setJvxlInfo();
                }
                this.setScriptInfo(string5);
            }
            this.clearSg();
            return;
        }
        if ("connections" == string) {
            if (this.currentMesh != null) {
                this.connections = (int[])object;
                if (this.connections[0] >= 0 && this.connections[0] < this.vwr.ms.ac) {
                    this.currentMesh.connections = this.connections;
                } else {
                    this.currentMesh.connections = null;
                    this.connections = null;
                }
            }
            return;
        }
        if ("cutoffRange" == string) {
            this.cutoffRange = (float[])object;
            return;
        }
        if ("fixLattice" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.fixLattice();
            }
            return;
        }
        if ("slab" == string) {
            if (object instanceof Integer) {
                if (this.thisMesh != null) {
                    this.thisMesh.jvxlData.slabValue = (Integer)object;
                }
                return;
            }
            if (this.thisMesh != null) {
                Object[] objectArray = object;
                int n = (Integer)objectArray[0];
                switch (n) {
                    case 1073742018: {
                        Object[] objectArray2 = (Object[])objectArray[1];
                        Mesh mesh = this.getMesh((String)objectArray2[1]);
                        if (mesh == null) {
                            return;
                        }
                        objectArray2[1] = mesh;
                    }
                }
                this.slabPolygons(objectArray);
                return;
            }
        }
        if ("cap" == string && this.thisMesh != null && this.thisMesh.pc != 0) {
            this.thisMesh.getMeshSlicer().slabPolygons((Object[])object, true);
            this.thisMesh.initialize(this.thisMesh.lighting, null, null);
            return;
        }
        if ("map" == string) {
            if (this.sg != null) {
                this.sg.params.isMapped = true;
            }
            this.setProperty("squareData", Boolean.FALSE, null);
            if (this.thisMesh == null || this.thisMesh.vc == 0) {
                return;
            }
        }
        if ("deleteVdw" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.isomeshes[n].bsVdw == null || bS != null && !bS.intersects(this.isomeshes[n].bsVdw)) continue;
                this.deleteMeshI(n);
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("mapColor" == string || "readFile" == string) {
            if (object == null) {
                object = this.vwr.fm.getBufferedReaderOrErrorMessageFromName(this.sg.params.fileName, null, true, true);
                if (object instanceof String) {
                    Logger.error("Isosurface: could not open file " + this.sg.params.fileName + " -- " + object);
                    return;
                }
                if (!(object instanceof BufferedReader)) {
                    try {
                        object = Rdr.getBufferedReader((BufferedInputStream)object, "ISO-8859-1");
                    }
                    catch (IOException iOException) {}
                }
            }
        } else if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
            if (this.thisMesh != null) {
                this.thisMesh.atomIndex = this.atomIndex;
            }
        } else if ("center" == string) {
            this.center.setT((P3)object);
        } else if ("colorRGB" == string) {
            int n = (Integer)object;
            if (n == 1296041474) {
                this.colorType = n;
            } else {
                this.colorType = 0;
                this.defaultColix = C.getColix(n);
            }
        } else if ("contour" == string) {
            this.explicitContours = true;
        } else if ("functionXY" == string) {
            if (this.sg.params.state == 2) {
                this.setScriptInfo(null);
            }
        } else if ("init" == string) {
            this.newSg();
        } else if ("getSurfaceSets" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.jvxlData.thisSet = (Integer)object;
                this.thisMesh.calculatedVolume = null;
                this.thisMesh.calculatedArea = null;
            }
        } else if ("localName" == string) {
            object = this.vwr.getOutputChannel((String)object, null);
            string = "outputChannel";
        } else if ("molecularOrbital" == string) {
            if (object instanceof Integer) {
                this.moNumber = (Integer)object;
                this.moLinearCombination = null;
            } else {
                this.moLinearCombination = (float[])object;
                this.moNumber = 0;
            }
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        } else if ("phase" == string) {
            this.isPhaseColored = true;
        } else if ("plane" != string && "pocket" != string) {
            if ("scale3d" == string) {
                this.scale3d = ((Float)object).floatValue();
                if (this.thisMesh != null) {
                    this.thisMesh.scale3d = this.thisMesh.jvxlData.scale3d = this.scale3d;
                    this.thisMesh.altVertices = null;
                }
            } else if ("title" == string) {
                if (object instanceof String && "-".equals(object)) {
                    object = null;
                }
                this.setPropertySuper(string, object, bS);
                object = this.title;
            } else if ("withinPoints" == string) {
                Object[] objectArray = object;
                this.withinDistance2 = ((Float)objectArray[0]).floatValue();
                this.isWithinNot = this.withinDistance2 < 0.0f;
                this.withinDistance2 *= this.withinDistance2;
                this.withinPoints = (Lst)objectArray[3];
                if (this.withinPoints.size() == 0) {
                    this.withinPoints = this.vwr.ms.getAtomPointVector((BS)objectArray[2]);
                }
            } else if (("nci" == string || "orbital" == string) && this.sg != null) {
                int n = this.sg.params.testFlags = this.vwr.getTestFlag(2) ? 2 : 0;
            }
        }
        if (this.sg != null && this.sg.setProp(string, object, bS)) {
            if (this.sg.isValid) {
                return;
            }
            string = "delete";
        }
        if ("init" == string) {
            this.explicitID = false;
            this.scriptAppendix = "";
            String string6 = object instanceof String ? (String)object : null;
            int n = string6 == null ? -1 : string6.indexOf("# ID=");
            this.actualID = n >= 0 ? PT.getQuotedStringAt(string6, n) : null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (string6 != null && !(this.iHaveBitSets = this.getScriptBitSets(string6, null))) {
                this.sg.setProp("select", bS, null);
            }
            this.initializeIsosurface();
            this.sg.params.modelIndex = this.isFixed ? -1 : this.modelIndex;
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if ("colorDensity" == string) {
            if (object != null && this.currentMesh != null) {
                this.currentMesh.volumeRenderPointSize = ((Float)object).floatValue();
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n3 = ((int[])((Object[])object)[2])[1];
            int n4 = ((int[])((Object[])object)[2])[2];
            int n5 = this.meshCount;
            while (--n5 >= 0) {
                Mesh mesh = this.meshes[n5];
                if (mesh == null) continue;
                if (mesh.connections != null) {
                    int n6 = mesh.connections[0];
                    if (n6 >= n3 + n4) {
                        mesh.connections[0] = n6 - n4;
                    } else if (n6 >= n3) {
                        mesh.connections = null;
                    }
                }
                mesh.connections = null;
                if (mesh.modelIndex == n) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])AU.deleteElements(this.meshes, n5, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex < n3) continue;
                mesh.atomIndex -= n4;
            }
            return;
        }
        this.setPropertySuper(string, object, bS);
    }

    private void setIsoMeshColor(IsosurfaceMesh isosurfaceMesh, String string) {
        isosurfaceMesh.jvxlData.baseColor = string;
        isosurfaceMesh.isColorSolid = true;
        isosurfaceMesh.pcs = null;
        isosurfaceMesh.colorsExplicit = false;
        isosurfaceMesh.colorEncoder = null;
        isosurfaceMesh.vertexColorMap = null;
    }

    private void setColorPhase(IsosurfaceMesh isosurfaceMesh, short s, short s2) {
        isosurfaceMesh.colorPhased = true;
        isosurfaceMesh.colix = isosurfaceMesh.jvxlData.minColorIndex = s;
        isosurfaceMesh.jvxlData.maxColorIndex = s2;
        isosurfaceMesh.jvxlData.isBicolorMap = true;
        isosurfaceMesh.jvxlData.colorDensity = false;
        isosurfaceMesh.isColorSolid = false;
        isosurfaceMesh.remapColors(this.vwr, null, this.translucentLevel);
    }

    private void ensureMeshSource() {
        boolean bl;
        boolean bl2 = bl = this.thisMesh.vertexSource != null;
        if (bl) {
            int n = this.thisMesh.vc;
            while (--n >= 0) {
                if (this.thisMesh.vertexSource[n] >= 0) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            int[] nArray = this.thisMesh.vertexSource;
            short[] sArray = this.thisMesh.vcs;
            short s = this.thisMesh.isColorSolid ? this.thisMesh.colix : (short)0;
            this.setProperty("init", null, null);
            this.setProperty("map", Boolean.FALSE, null);
            this.setProperty("property", new float[this.vwr.ms.ac], null);
            if (s != 0) {
                this.thisMesh.colorCommand = "color isosurface " + C.getHexCode(s);
                this.setProperty("color", C.getArgb(s), null);
            }
            if (nArray != null) {
                int n = this.thisMesh.vc;
                while (--n >= 0) {
                    if (nArray[n] >= 0) continue;
                    nArray[n] = this.thisMesh.vertexSource[n];
                }
                this.thisMesh.vertexSource = nArray;
                this.thisMesh.vcs = sArray;
            }
        }
    }

    protected void slabPolygons(Object[] objectArray) {
        this.thisMesh.calculatedVolume = null;
        this.thisMesh.calculatedArea = null;
        this.thisMesh.getMeshSlicer().slabPolygons(objectArray, false);
        this.thisMesh.reinitializeLightingAndColor(this.vwr);
    }

    private void setPropertySuper(String string, Object object, BS bS) {
        if (string == "thisID" && this.currentMesh != null && this.currentMesh.thisID != null && this.currentMesh.thisID.equals(object)) {
            this.checkExplicit((String)object);
            return;
        }
        this.currentMesh = this.thisMesh;
        this.setPropMC(string, object, bS);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        int n;
        if (string == "colorEncoder") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.colorEncoder) != null;
        }
        if (string == "intersectPlane") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            if (isosurfaceMesh == null) {
                return false;
            }
            objectArray[3] = isosurfaceMesh.modelIndex;
            isosurfaceMesh.getMeshSlicer().getIntersection(0.0f, (P4)objectArray[1], null, (Lst)objectArray[2], null, null, null, false, false, 134217750, false);
            return true;
        }
        if (string == "getBoundingBox") {
            String string2 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string2);
            if (isosurfaceMesh == null || isosurfaceMesh.vs == null) {
                return false;
            }
            objectArray[2] = isosurfaceMesh.jvxlData.boundingBox;
            if (isosurfaceMesh.mat4 != null) {
                P3[] p3Array = new P3[]{P3.newP(isosurfaceMesh.jvxlData.boundingBox[0]), P3.newP(isosurfaceMesh.jvxlData.boundingBox[1])};
                V3 v3 = new V3();
                isosurfaceMesh.mat4.getTranslation(v3);
                p3Array[0].add(v3);
                p3Array[1].add(v3);
                objectArray[2] = p3Array;
            }
            return true;
        }
        if (string == "unitCell") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.getUnitCell()) != null;
        }
        if (string == "getCenter" && (n = ((Integer)objectArray[1]).intValue()) == Integer.MIN_VALUE) {
            String string3 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string3);
            if (isosurfaceMesh == null || isosurfaceMesh.vs == null) {
                return false;
            }
            P3 p3 = P3.newP(isosurfaceMesh.jvxlData.boundingBox[0]);
            p3.add(isosurfaceMesh.jvxlData.boundingBox[1]);
            p3.scale(0.5f);
            if (isosurfaceMesh.mat4 != null) {
                V3 v3 = new V3();
                isosurfaceMesh.mat4.getTranslation(v3);
                p3.add(v3);
            }
            objectArray[2] = p3;
            return true;
        }
        return this.getPropDataMC(string, objectArray);
    }

    @Override
    public Object getProperty(String string, int n) {
        return this.getPropI(string);
    }

    protected Object getPropI(String string) {
        Object object = this.getPropMC(string);
        if (object != null) {
            return object;
        }
        if (string == "message") {
            String string2 = "";
            if (this.shapeID == 24) {
                string2 = string2 + " with cutoff=" + this.jvxlData.cutoff;
            }
            if (this.jvxlData.dataMin != Float.MAX_VALUE) {
                string2 = string2 + " min=" + this.jvxlData.dataMin + " max=" + this.jvxlData.dataMax;
            }
            string2 = string2 + "; " + JC.shapeClassBases[this.shapeID].toLowerCase() + " count: " + this.getPropMC("count");
            return string2 + this.getPropI("dataRangeStr") + this.jvxlData.msg;
        }
        if (string == "dataRange") {
            return this.getDataRange();
        }
        if (string == "dataRangeStr") {
            float[] fArray = this.getDataRange();
            return fArray != null && fArray[0] != Float.MAX_VALUE && fArray[0] != fArray[1] ? "\nisosurface full data range " + fArray[0] + " to " + fArray[1] + " with color scheme spanning " + fArray[2] + " to " + fArray[3] : "";
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (string == "nSets") {
            return this.thisMesh == null ? 0 : this.thisMesh.nSets;
        }
        if (string == "area") {
            return this.thisMesh == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(true);
        }
        if (string == "volume") {
            return this.thisMesh == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(false);
        }
        if (this.thisMesh == null) {
            return null;
        }
        if (string == "cutoff") {
            return Float.valueOf(this.jvxlData.cutoff);
        }
        if (string == "minMaxInfo") {
            return new float[]{this.jvxlData.dataMin, this.jvxlData.dataMax};
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "contours") {
            return this.thisMesh.getContours();
        }
        if (string == "jvxlDataXml" || string == "jvxlMeshXml") {
            MeshData meshData = null;
            this.jvxlData.slabInfo = null;
            if (string == "jvxlMeshXml" || this.jvxlData.vertexDataOnly || this.thisMesh.bsSlabDisplay != null && this.thisMesh.bsSlabGhost == null) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1, null);
                meshData.polygonColorData = Isosurface.getPolygonColorData(meshData.pc, meshData.pcs, meshData.colorsExplicit ? meshData.pis : (int[][])null, meshData.bsSlabDisplay);
            } else if (this.thisMesh.bsSlabGhost != null) {
                this.jvxlData.slabInfo = this.thisMesh.slabOptions.toString();
            }
            SB sB = new SB();
            this.getMeshCommand(sB, this.thisMesh.index);
            this.thisMesh.setJvxlColorMap(true);
            return JvxlCoder.jvxlGetFile(this.jvxlData, meshData, this.title, "", true, 1, sB.toString(), null);
        }
        if (string == "jvxlFileInfo") {
            this.thisMesh.setJvxlColorMap(false);
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        if (string == "command") {
            SB sB = new SB();
            Lst<Mesh> lst = this.getMeshList(this.previousMeshID, false);
            int n = lst.size();
            while (--n >= 0) {
                this.getMeshCommand(sB, n);
            }
            return sB.toString();
        }
        return null;
    }

    private float[] getDataRange() {
        float[] fArray;
        if (this.thisMesh == null || this.jvxlData.jvxlPlane != null && this.thisMesh.colorEncoder == null) {
            fArray = null;
        } else {
            float[] fArray2 = new float[4];
            fArray2[0] = this.jvxlData.mappedDataMin;
            fArray2[1] = this.jvxlData.mappedDataMax;
            fArray2[2] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue : this.jvxlData.valueMappedToRed;
            fArray = fArray2;
            fArray2[3] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToBlue;
        }
        return fArray;
    }

    private Object calculateVolumeOrArea(boolean bl) {
        if (bl) {
            if (this.thisMesh.calculatedArea != null) {
                return this.thisMesh.calculatedArea;
            }
        } else if (this.thisMesh.calculatedVolume != null) {
            return this.thisMesh.calculatedVolume;
        }
        MeshData meshData = new MeshData();
        this.fillMeshData(meshData, 1, null);
        meshData.nSets = this.thisMesh.nSets;
        meshData.vertexSets = this.thisMesh.vertexSets;
        if (!bl && this.thisMesh.jvxlData.colorDensity) {
            float f = this.thisMesh.jvxlData.voxelVolume;
            this.thisMesh.calculatedVolume = Float.valueOf(f *= (float)(this.thisMesh.bsSlabDisplay == null ? this.thisMesh.vc : this.thisMesh.bsSlabDisplay.cardinality()));
            return this.thisMesh.calculatedVolume;
        }
        Object object = MeshData.calculateVolumeOrArea(meshData, this.thisMesh.jvxlData.thisSet, bl, false);
        if (this.thisMesh.nSets <= 0) {
            this.thisMesh.nSets = -meshData.nSets;
        }
        if (bl) {
            this.thisMesh.calculatedArea = object;
        } else {
            this.thisMesh.calculatedVolume = object;
        }
        return object;
    }

    public static String getPolygonColorData(int n, short[] sArray, int[][] nArray, BS bS) {
        boolean bl;
        boolean bl2 = bl = nArray != null;
        if (sArray == null && nArray == null) {
            return null;
        }
        SB sB = new SB();
        int n2 = 0;
        short s = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = 0;
        while (true) {
            if (n5 >= n) {
                bl3 = true;
                if (!true) break;
            }
            if (bl3 || bS == null || bS.get(n5)) {
                if (bl3 || (bl ? (n4 = nArray[n5][4]) != n3 : sArray[n5] != s)) {
                    if (n2 != 0) {
                        sB.append(" ").appendI(n2).append(" ").appendI(bl ? n3 : (s == 0 ? 0 : C.getArgb(s)));
                    }
                    if (bl3) break;
                    if (bl) {
                        n3 = n4;
                    } else {
                        s = sArray[n5];
                    }
                    n2 = 1;
                } else {
                    ++n2;
                }
            }
            ++n5;
        }
        sB.append("\n");
        return sB.toString();
    }

    @Override
    public String getShapeState() {
        this.clean();
        SB sB = new SB();
        sB.append("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(sB, i);
        }
        return sB.toString();
    }

    private void getMeshCommand(SB sB, int n) {
        IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.meshes[n];
        if (isosurfaceMesh == null || isosurfaceMesh.scriptCommand == null) {
            return;
        }
        String string = isosurfaceMesh.scriptCommand;
        int n2 = this.vwr.ms.mc;
        if (n2 > 1) {
            Isosurface.appendCmd(sB, "frame " + this.vwr.getModelNumberDotted(isosurfaceMesh.modelIndex));
        }
        string = PT.rep(string, ";; isosurface map", " map");
        string = PT.rep(string, "; isosurface map", " map");
        string = string.replace('\t', ' ');
        int n3 = (string = PT.rep(string, ";#", "; #")).indexOf("; #");
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if (isosurfaceMesh.connections != null) {
            string = string + " connect " + Escape.eAI(isosurfaceMesh.connections);
        }
        string = PT.trim(string, ";");
        if (isosurfaceMesh.linkedMesh != null) {
            string = string + " LINK";
        }
        if (this.myType == "lcaoCartoon" && isosurfaceMesh.atomIndex >= 0) {
            string = string + " ATOMINDEX " + isosurfaceMesh.atomIndex;
        }
        Isosurface.appendCmd(sB, string);
        String string2 = this.myType + " ID " + PT.esc(isosurfaceMesh.thisID);
        if (isosurfaceMesh.jvxlData.thisSet >= 0) {
            Isosurface.appendCmd(sB, string2 + " set " + (isosurfaceMesh.jvxlData.thisSet + 1));
        }
        if (isosurfaceMesh.mat4 != null) {
            Isosurface.appendCmd(sB, string2 + " move " + Escape.matrixToScript(isosurfaceMesh.mat4));
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            Isosurface.appendCmd(sB, string2 + " scale3d " + isosurfaceMesh.scale3d);
        }
        if (isosurfaceMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
            Isosurface.appendCmd(sB, string2 + " slab " + isosurfaceMesh.jvxlData.slabValue);
        }
        if (isosurfaceMesh.slabOptions != null) {
            Isosurface.appendCmd(sB, isosurfaceMesh.slabOptions.toString());
        }
        if (string.charAt(0) != '#') {
            boolean bl;
            if (this.allowMesh) {
                Isosurface.appendCmd(sB, isosurfaceMesh.getState(this.myType));
            }
            if (!isosurfaceMesh.isColorSolid && isosurfaceMesh.colorType == 0 && C.isColixTranslucent(isosurfaceMesh.colix)) {
                Isosurface.appendCmd(sB, "color " + this.myType + " " + Isosurface.getTranslucentLabel(isosurfaceMesh.colix));
            }
            if (isosurfaceMesh.colorCommand != null && isosurfaceMesh.colorType == 0 && !isosurfaceMesh.colorCommand.equals("#inherit;")) {
                Isosurface.appendCmd(sB, isosurfaceMesh.colorCommand);
            }
            boolean bl2 = bl = isosurfaceMesh.isColorSolid && isosurfaceMesh.pcs != null;
            if (isosurfaceMesh.isColorSolid && isosurfaceMesh.colorType == 0 && !isosurfaceMesh.colorsExplicit && !bl) {
                Isosurface.appendCmd(sB, Isosurface.getColorCommandUnk(this.myType, isosurfaceMesh.colix, this.translucentAllowed));
            } else if (isosurfaceMesh.jvxlData.isBicolorMap && isosurfaceMesh.colorPhased) {
                Isosurface.appendCmd(sB, "color isosurface phase " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.minColorIndex) + " " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.maxColorIndex));
            }
            if (isosurfaceMesh.vertexColorMap != null) {
                for (Map.Entry entry : isosurfaceMesh.vertexColorMap.entrySet()) {
                    BS bS = (BS)entry.getValue();
                    if (bS.isEmpty()) continue;
                    Isosurface.appendCmd(sB, "color " + this.myType + " " + Escape.eBS(bS) + " " + (String)entry.getKey());
                }
            }
        }
    }

    private boolean getScriptBitSets(String string, BS[] bSArray) {
        BS bS;
        int n;
        int n2;
        this.script = string;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (string != null && (n2 = string.indexOf("MODEL({")) >= 0 && (n = string.indexOf("})", n2)) > 0) {
            bS = BS.unescape(string.substring(n2 + 3, n + 1));
            this.modelIndex = bS == null ? -1 : bS.nextSetBit(0);
            boolean bl = this.iHaveModelIndex = this.modelIndex >= 0;
        }
        if (string == null) {
            return false;
        }
        this.getCapSlabInfo(string);
        n2 = string.indexOf("# ({");
        if (n2 < 0) {
            return false;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bS = BS.unescape(string.substring(n2 + 2, n + 2));
        if (bSArray == null) {
            this.sg.setProp("select", bS, null);
        } else {
            bSArray[0] = bS;
        }
        n2 = string.indexOf("({", n);
        if (n2 < 0) {
            return true;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bS = BS.unescape(string.substring(n2 + 1, n + 1));
        if (bSArray == null) {
            this.sg.setProp("ignore", bS, null);
        } else {
            bSArray[1] = bS;
        }
        n2 = string.indexOf("/({", n);
        if (n2 == n + 2) {
            n = string.indexOf("})", n2);
            if (n < 0) {
                return false;
            }
            bS = BS.unescape(string.substring(n2 + 3, n + 1));
            if (bSArray == null) {
                this.vwr.ms.setTrajectoryBs(bS);
            } else {
                bSArray[2] = bS;
            }
        }
        return true;
    }

    protected void getCapSlabInfo(String string) {
        int n = string.indexOf("# SLAB=");
        if (n >= 0) {
            this.sg.setProp("slab", this.getCapSlabObject(PT.getQuotedStringAt(string, n), false), null);
        }
        if ((n = string.indexOf("# CAP=")) >= 0) {
            this.sg.setProp("slab", this.getCapSlabObject(PT.getQuotedStringAt(string, n), true), null);
        }
    }

    private Object[] getCapSlabObject(String string, boolean bl) {
        try {
            if (string.indexOf("array") == 0) {
                String[] stringArray = PT.split(string.substring(6, string.length() - 1), ",");
                return TempArray.getSlabObjectType(1678381065, new P3[]{(P3)Escape.uP(stringArray[0]), (P3)Escape.uP(stringArray[1]), (P3)Escape.uP(stringArray[2]), (P3)Escape.uP(stringArray[3])}, bl, null);
            }
            Object object = Escape.uP(string);
            if (object instanceof P4) {
                return TempArray.getSlabObjectType(134217750, object, bl, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void initializeIsosurface() {
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.vwr.am.cmi;
        }
        this.atomIndex = -1;
        this.bsDisplay = null;
        this.center = P3.new3(Float.NaN, 0.0f, 0.0f);
        this.colix = (short)5;
        this.connections = null;
        this.cutoffRange = null;
        this.meshColix = 0;
        this.defaultColix = 0;
        this.colorType = 0;
        this.displayWithinPoints = null;
        this.explicitContours = false;
        this.isFixed = this.modelIndex < 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.linkedMesh = null;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.scale3d = 0.0f;
        this.title = null;
        this.translucentLevel = 0.0f;
        this.withinPoints = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void setMeshI() {
        this.thisMesh.visible = true;
        this.thisMesh.atomIndex = this.atomIndex;
        this.thisMesh.modelIndex = this.thisMesh.atomIndex >= 0 ? (int)this.vwr.ms.at[this.atomIndex].mi : (this.isFixed ? -1 : (this.modelIndex >= 0 ? this.modelIndex : this.vwr.am.cmi));
        this.thisMesh.scriptCommand = this.script;
        this.thisMesh.ptCenter.setT(this.center);
        this.thisMesh.scale3d = this.thisMesh.jvxlData.jvxlPlane == null ? 0.0f : this.scale3d;
    }

    protected void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.jvxlData.wasCubic) {
            return this.colix;
        }
        int n = this.sg.params.cutoff >= 0.0f ? -11525984 : -6283184;
        return C.getColix(n);
    }

    private void drawLcaoCartoon(V3 v3, V3 v32, V3 v33, int n) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = v33.x + v33.y + v33.z;
        this.defaultColix = C.getColix(this.sg.params.colorPos);
        short s = C.getColix(this.sg.params.colorNeg);
        V3 v34 = new V3();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n2 = bl ? -1 : 1;
        v34.cross(v3, v32);
        if (f != 0.0f) {
            object2 = new A4();
            if (v33.x != 0.0f) {
                ((A4)object2).setVA(v32, f);
            } else if (v33.y != 0.0f) {
                ((A4)object2).setVA(v34, f);
            } else {
                ((A4)object2).setVA(v3, f);
            }
            object = new M3().setAA((A4)object2);
            ((M34)object).rotate(v32);
            ((M34)object).rotate(v34);
            ((M34)object).rotate(v3);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = this.thisMesh == null ? (n > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + string : (object2 = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh((String)object2, null);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v32, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v32, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v34, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v34, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v3, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v3, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pza") || string.indexOf("sp") == 0 || string.indexOf("d") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(v3, n2, n);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(v3, -n2, n);
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(v32, n2, n);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(v32, -n2, n);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(v34, n2, n);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(v34, -n2, n);
            return;
        }
        if (string.equals("spacefill") || string.equals("cpk")) {
            this.createLcaoLobe(null, 2.0f * this.vwr.ms.at[this.atomIndex].getRadius(), n);
            return;
        }
        this.createLcaoLobe(null, 1.0f, n);
    }

    private void createLcaoLobe(V3 v3, float f, int n) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        if (v3 == null) {
            this.setProperty("sphere", Float.valueOf(f / 2.0f), null);
        } else {
            this.lcaoDir.x = v3.x * f;
            this.lcaoDir.y = v3.y * f;
            this.lcaoDir.z = v3.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty(n == 2 ? "lp" : (n == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.thisMesh.colix = this.defaultColix;
        this.setScriptInfo(null);
    }

    @Override
    public void invalidateTriangles() {
        this.thisMesh.invalidatePolygons();
    }

    @Override
    public void setOutputChannel(GenericBinaryDocument genericBinaryDocument, OC oC) {
        genericBinaryDocument.setOutputChannel(oC);
    }

    @Override
    public void fillMeshData(MeshData meshData, int n, IsosurfaceMesh isosurfaceMesh) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
            }
            if (!this.thisMesh.isMerged) {
                this.thisMesh.clearType(this.myType, this.sg.params.iAddGridPoints);
            }
            this.thisMesh.connections = this.connections;
            this.thisMesh.colix = this.getDefaultColix();
            this.thisMesh.colorType = this.colorType;
            this.thisMesh.meshColix = this.meshColix;
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        if (isosurfaceMesh == null) {
            isosurfaceMesh = this.thisMesh;
        }
        if (isosurfaceMesh == null) {
            return;
        }
        switch (n) {
            case 1: {
                meshData.mergeVertexCount0 = isosurfaceMesh.mergeVertexCount0;
                meshData.vs = isosurfaceMesh.vs;
                meshData.vertexSource = isosurfaceMesh.vertexSource;
                meshData.vvs = isosurfaceMesh.vvs;
                meshData.vc = isosurfaceMesh.vc;
                meshData.vertexIncrement = isosurfaceMesh.vertexIncrement;
                meshData.pc = isosurfaceMesh.pc;
                meshData.pis = isosurfaceMesh.pis;
                meshData.pcs = isosurfaceMesh.pcs;
                meshData.bsSlabDisplay = isosurfaceMesh.bsSlabDisplay;
                meshData.bsSlabGhost = isosurfaceMesh.bsSlabGhost;
                meshData.slabColix = isosurfaceMesh.slabColix;
                meshData.slabMeshType = isosurfaceMesh.slabMeshType;
                meshData.polygonCount0 = isosurfaceMesh.polygonCount0;
                meshData.vertexCount0 = isosurfaceMesh.vertexCount0;
                meshData.slabOptions = isosurfaceMesh.slabOptions;
                meshData.colorsExplicit = isosurfaceMesh.colorsExplicit;
                return;
            }
            case 2: {
                if (isosurfaceMesh.vcs == null || isosurfaceMesh.vc > isosurfaceMesh.vcs.length) {
                    isosurfaceMesh.vcs = new short[isosurfaceMesh.vc];
                }
                meshData.vcs = isosurfaceMesh.vcs;
                return;
            }
            case 3: {
                isosurfaceMesh.surfaceSet = meshData.surfaceSet;
                isosurfaceMesh.vertexSets = meshData.vertexSets;
                isosurfaceMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                isosurfaceMesh.vs = meshData.vs;
                isosurfaceMesh.vvs = meshData.vvs;
                isosurfaceMesh.vc = meshData.vc;
                isosurfaceMesh.vertexIncrement = meshData.vertexIncrement;
                isosurfaceMesh.vertexSource = meshData.vertexSource;
                isosurfaceMesh.pc = meshData.pc;
                isosurfaceMesh.pis = meshData.pis;
                isosurfaceMesh.pcs = meshData.pcs;
                isosurfaceMesh.bsSlabDisplay = meshData.bsSlabDisplay;
                isosurfaceMesh.bsSlabGhost = meshData.bsSlabGhost;
                isosurfaceMesh.slabColix = meshData.slabColix;
                isosurfaceMesh.slabMeshType = meshData.slabMeshType;
                isosurfaceMesh.polygonCount0 = meshData.polygonCount0;
                isosurfaceMesh.vertexCount0 = meshData.vertexCount0;
                isosurfaceMesh.mergeVertexCount0 = meshData.mergeVertexCount0;
                isosurfaceMesh.slabOptions = meshData.slabOptions;
                isosurfaceMesh.colorsExplicit = meshData.colorsExplicit;
                return;
            }
        }
    }

    @Override
    public boolean notifySurfaceGenerationCompleted() {
        this.setMeshI();
        this.setBsVdw();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.vertexSource = this.sg.params.vertexSource;
        this.thisMesh.spanningVectors = this.sg.getSpanningVectors();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.params.thePlane);
            if (this.jvxlData.fixedLattice != null) {
                this.thisMesh.lattice = this.jvxlData.fixedLattice;
                this.thisMesh.fixLattice();
            }
            return this.thisMesh.setColorsFromJvxlData(this.sg.params.colorRgb);
        }
        if (!this.sg.params.allowVolumeRender) {
            this.thisMesh.jvxlData.allowVolumeRender = false;
        }
        this.thisMesh.setColorsFromJvxlData(this.sg.params.colorRgb);
        if (this.thisMesh.jvxlData.slabInfo != null) {
            this.vwr.runScript("isosurface " + this.thisMesh.jvxlData.slabInfo);
        }
        if (this.sg.params.psi_monteCarloCount > 0) {
            this.thisMesh.diameter = -1;
        }
        return false;
    }

    @Override
    public void notifySurfaceMappingCompleted() {
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.params.thePlane);
        }
        this.setBsVdw();
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorDensity = this.jvxlData.colorDensity;
        this.thisMesh.volumeRenderPointSize = this.jvxlData.pointSize;
        this.thisMesh.colorEncoder = this.sg.params.colorEncoder;
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        if (this.explicitContours && this.thisMesh.jvxlData.jvxlPlane != null) {
            this.thisMesh.havePlanarContours = true;
        }
        this.setPropertySuper("token", this.explicitContours ? 1073742046 : 1073741938, null);
        this.setPropertySuper("token", this.explicitContours ? 0x4000004A : 1073742039, null);
        if (!this.thisMesh.isMerged) {
            this.thisMesh.setJvxlDataRendering();
        }
        if (this.sg.params.slabInfo != null) {
            this.thisMesh.slabPolygonsList(this.sg.params.slabInfo, false);
            this.thisMesh.reinitializeLightingAndColor(this.vwr);
        }
        this.thisMesh.setColorCommand();
    }

    private void setBsVdw() {
        if (this.sg.bsVdw == null) {
            return;
        }
        if (this.thisMesh.bsVdw == null) {
            this.thisMesh.bsVdw = new BS();
        }
        this.thisMesh.bsVdw.or(this.sg.bsVdw);
    }

    @Override
    public P3[] calculateGeodesicSurface(BS bS, float f) {
        return this.vwr.calculateSurface(bS, f);
    }

    @Override
    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, P3i p3i, int n4, int n5, float f2, float f3, T3 t3, V3 v3, boolean bl2, float[] fArray) {
        return 0;
    }

    @Override
    public int addVertexCopy(T3 t3, float f, int n, boolean bl) {
        if (this.cutoffRange != null && (f < this.cutoffRange[0] || f > this.cutoffRange[1])) {
            return -1;
        }
        return this.withinPoints != null && !Mesh.checkWithin(t3, this.withinPoints, this.withinDistance2, this.isWithinNot) ? -1 : this.thisMesh.addVertexCopy(t3, f, n, this.associateNormals, bl);
    }

    @Override
    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        return n < 0 || n2 < 0 || n3 < 0 || bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vvs) ? -1 : this.thisMesh.addTriangleCheck(n, n2, n3, n4, n5, n6);
    }

    protected void setScriptInfo(String string) {
        int n;
        String string2 = string == null ? this.sg.params.script : string;
        int n2 = n = string2 == null ? -1 : string2.indexOf("; isosurface map");
        if (n == 0) {
            if (this.thisMesh.scriptCommand == null) {
                return;
            }
            n = this.thisMesh.scriptCommand.indexOf("; isosurface map");
            if (n >= 0) {
                this.thisMesh.scriptCommand = this.thisMesh.scriptCommand.substring(0, n);
            }
            this.thisMesh.scriptCommand = this.thisMesh.scriptCommand + string2;
            return;
        }
        this.thisMesh.title = this.sg.params.title;
        this.thisMesh.dataType = this.sg.params.dataType;
        this.thisMesh.scale3d = this.sg.params.scale3d;
        if (string2 != null && string2.charAt(0) == ' ') {
            string2 = this.myType + " ID " + PT.esc(this.thisMesh.thisID) + string2;
            n = string2.indexOf("; isosurface map");
        }
        this.thisMesh.scriptCommand = n > 0 && this.scriptAppendix.length() > 0 ? string2.substring(0, n) + this.scriptAppendix + string2.substring(n) : string2 + this.scriptAppendix;
        if (!this.explicitID && string2 != null && (n = string2.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = PT.getQuotedStringAt(string2, n);
        }
    }

    @Override
    public void addRequiredFile(String string) {
        string = " # /*file*/\"" + string + "\"";
        if (this.scriptAppendix.indexOf(string) < 0) {
            this.scriptAppendix = this.scriptAppendix + string;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.jvxlData != this.jvxlData || this.sg.jvxlData != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.jvxlData;
        }
    }

    @Override
    public Lst<Map<String, Object>> getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null || isosurfaceMesh.vs == null || isosurfaceMesh.vc == 0 && isosurfaceMesh.pc == 0) continue;
            this.addMeshInfo(isosurfaceMesh, hashtable);
            lst.addLast((Map<String, Object>)hashtable);
        }
        return lst;
    }

    protected void addMeshInfo(IsosurfaceMesh isosurfaceMesh, Map<String, Object> map) {
        map.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
        map.put("visible", isosurfaceMesh.visible);
        map.put("vertexCount", isosurfaceMesh.vc);
        if (isosurfaceMesh.calculatedVolume != null) {
            map.put("volume", isosurfaceMesh.calculatedVolume);
        }
        if (isosurfaceMesh.calculatedArea != null) {
            map.put("area", isosurfaceMesh.calculatedArea);
        }
        if (!Float.isNaN(isosurfaceMesh.ptCenter.x)) {
            map.put("center", isosurfaceMesh.ptCenter);
        }
        if (isosurfaceMesh.mat4 != null) {
            map.put("mat4", isosurfaceMesh.mat4);
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            map.put("scale3d", Float.valueOf(isosurfaceMesh.scale3d));
        }
        map.put("xyzMin", isosurfaceMesh.jvxlData.boundingBox[0]);
        map.put("xyzMax", isosurfaceMesh.jvxlData.boundingBox[1]);
        String string = JvxlCoder.jvxlGetInfo(isosurfaceMesh.jvxlData);
        if (string != null) {
            map.put("jvxlInfo", string.replace('\n', ' '));
        }
        map.put("modelIndex", isosurfaceMesh.modelIndex);
        map.put("color", CU.colorPtFromInt(C.getArgb(isosurfaceMesh.colix), null));
        if (isosurfaceMesh.colorEncoder != null) {
            map.put("colorKey", isosurfaceMesh.colorEncoder.getColorKey());
        }
        if (isosurfaceMesh.title != null) {
            map.put("title", isosurfaceMesh.title);
        }
        if (isosurfaceMesh.jvxlData.contourValues != null || isosurfaceMesh.jvxlData.contourValuesUsed != null) {
            map.put("contours", isosurfaceMesh.getContourList(this.vwr));
        }
    }

    @Override
    public float[] getPlane(int n) {
        return null;
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    @Override
    public boolean checkObjectHovered(int n, int n2, BS bS) {
        if (this.keyXy != null && n >= this.keyXy[0] && n2 >= this.keyXy[1] && n < this.keyXy[2] && n2 < this.keyXy[3]) {
            this.hoverKey(n, n2);
            return true;
        }
        if (!this.vwr.getDrawHover()) {
            return false;
        }
        String string = this.findValue(n, n2, false, bS);
        if (string == null) {
            return false;
        }
        if (this.vwr.gdata.antialiasEnabled) {
            n <<= 1;
            n2 <<= 1;
        }
        this.vwr.hoverOnPt(n, n2, string, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    private void hoverKey(int n, int n2) {
        try {
            String string;
            float f = 1.0f - 1.0f * (float)(n2 - this.keyXy[1]) / (float)(this.keyXy[3] - this.keyXy[1]);
            if (this.thisMesh.showContourLines) {
                Lst<Object>[] lstArray = this.thisMesh.getContours();
                if (lstArray == null) {
                    if (this.thisMesh.jvxlData.contourValues == null) {
                        return;
                    }
                    int n3 = (int)Math.floor(f * (float)this.thisMesh.jvxlData.contourValues.length);
                    if (n3 < 0 || n3 > this.thisMesh.jvxlData.contourValues.length) {
                        return;
                    }
                    string = "" + this.thisMesh.jvxlData.contourValues[n3];
                } else {
                    int n4 = (int)Math.floor(f * (float)lstArray.length);
                    if (n4 < 0 || n4 > lstArray.length) {
                        return;
                    }
                    string = "" + ((Float)lstArray[n4].get(2)).floatValue();
                }
            } else {
                float f2 = this.thisMesh.colorEncoder.quantize(f, true);
                f = this.thisMesh.colorEncoder.quantize(f, false);
                string = "" + f2 + " - " + f;
            }
            if (this.vwr.gdata.isAntialiased()) {
                n <<= 1;
                n2 <<= 1;
            }
            this.vwr.hoverOnPt(n, n2, string, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Object object;
        Object object2;
        int n4;
        if (!bl) {
            return null;
        }
        if (!this.vwr.isBound(n3, 18)) {
            return null;
        }
        int n5 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n5 <<= 1;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        boolean bl2 = true;
        for (n4 = 0; n4 < this.meshCount; ++n4) {
            object2 = this.isomeshes[n4];
            if (!this.isPickable((IsosurfaceMesh)object2, bS)) continue;
            T3[] t3Array = object = bl2 ? ((IsosurfaceMesh)object2).vs : ((IsosurfaceMesh)object2).getCenters();
            if (object == null) continue;
            int n11 = ((T3[])object).length;
            while (--n11 >= 0) {
                int n12;
                T3 t3 = object[n11];
                if (t3 == null || (n12 = this.coordinateInRange(n, n2, t3, n5, this.ptXY)) < 0) continue;
                if (this.ptXY.z < n10) {
                    if (bl2) {
                        n6 = n4;
                    }
                    n10 = this.ptXY.z;
                    n8 = n11;
                }
                if (this.ptXY.z <= n9) continue;
                if (!bl2) {
                    n6 = n4;
                }
                n9 = this.ptXY.z;
                n7 = n11;
            }
        }
        if (n6 < 0) {
            return null;
        }
        this.pickedMesh = this.isomeshes[n6];
        this.setPropertySuper("thisID", this.pickedMesh.thisID, null);
        this.pickedVertex = bl2 ? n8 : n7;
        n4 = this.pickedVertex;
        object2 = new P3();
        ((T3)object2).setT(bl2 ? this.pickedMesh.vs[this.pickedVertex] : ((IsosurfaceMesh)this.pickedMesh).centers[n4]);
        this.pickedModel = (short)this.pickedMesh.modelIndex;
        object = this.getPickedPoint((T3)object2, this.pickedModel);
        this.setStatusPicked(-4, (T3)object2, (Map<String, Object>)object);
        return object;
    }

    private boolean isPickable(IsosurfaceMesh isosurfaceMesh, BS bS) {
        return isosurfaceMesh.visibilityFlags != 0 && (isosurfaceMesh.modelIndex < 0 || bS.get(isosurfaceMesh.modelIndex)) && !C.isColixTranslucent(isosurfaceMesh.colix);
    }

    private String findValue(int n, int n2, boolean bl, BS bS) {
        int n3 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        int n4 = -1;
        Lst<Object> lst = null;
        IsosurfaceMesh isosurfaceMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n5;
            int n6;
            int n7;
            isosurfaceMesh = this.isomeshes[i];
            if (!this.isPickable(isosurfaceMesh, bS)) continue;
            Lst<Object>[] lstArray = isosurfaceMesh.jvxlData.vContours;
            int n8 = isosurfaceMesh.firstRealVertex < 0 ? 0 : isosurfaceMesh.firstRealVertex;
            int n9 = 0;
            if (lstArray != null && lstArray.length > 0) {
                for (n7 = 0; n7 < lstArray.length; ++n7) {
                    Lst<Object> lst2 = lstArray[n7];
                    n6 = lst2.size() - 1;
                    for (n5 = 6; n5 < n6; ++n5) {
                        T3 t3 = (T3)lst2.get(n5);
                        int n10 = this.coordinateInRange(n, n2, t3, n3, this.ptXY);
                        if (n10 < 0) continue;
                        n3 = n10;
                        lst = lst2;
                        n9 = n7;
                        this.pickedMesh = isosurfaceMesh;
                        this.pickedPt = t3;
                    }
                }
                if (lst == null) continue;
                return lst.get(2).toString() + (Logger.debugging ? " " + n9 : "");
            }
            if (isosurfaceMesh.jvxlData.jvxlPlane != null && isosurfaceMesh.vvs != null) {
                P3[] p3Array = isosurfaceMesh.mat4 == null && isosurfaceMesh.scale3d == 0.0f ? isosurfaceMesh.vs : isosurfaceMesh.getOffsetVertices(isosurfaceMesh.jvxlData.jvxlPlane);
                int n11 = isosurfaceMesh.vc;
                while (--n11 >= n8) {
                    P3 p3 = p3Array[n11];
                    n5 = this.coordinateInRange(n, n2, p3, n3, this.ptXY);
                    if (n5 < 0) continue;
                    n3 = n5;
                    n4 = n11;
                    this.pickedMesh = isosurfaceMesh;
                    this.pickedPt = p3;
                }
                if (n4 == -1) continue;
                break;
            }
            if (isosurfaceMesh.vvs == null) continue;
            if (isosurfaceMesh.bsSlabDisplay != null) {
                n7 = isosurfaceMesh.bsSlabDisplay.nextSetBit(0);
                while (n7 >= 0) {
                    int[] nArray = isosurfaceMesh.pis[n7];
                    for (n6 = 0; n6 < 3; ++n6) {
                        T3 t3 = isosurfaceMesh.vs[nArray[n6]];
                        int n12 = this.coordinateInRange(n, n2, t3, n3, this.ptXY);
                        if (n12 < 0) continue;
                        n3 = n12;
                        n4 = nArray[n6];
                        this.pickedMesh = isosurfaceMesh;
                        this.pickedPt = t3;
                    }
                    n7 = isosurfaceMesh.bsSlabDisplay.nextSetBit(n7 + 1);
                }
            } else {
                n7 = isosurfaceMesh.vc;
                while (--n7 >= n8) {
                    T3 t3 = isosurfaceMesh.vs[n7];
                    n6 = this.coordinateInRange(n, n2, t3, n3, this.ptXY);
                    if (n6 < 0) continue;
                    n3 = n6;
                    n4 = n7;
                    this.pickedMesh = isosurfaceMesh;
                    this.pickedPt = t3;
                }
            }
            if (n4 != -1) break;
        }
        return n4 == -1 ? null : (Logger.debugging ? "$" + isosurfaceMesh.thisID + "[" + (n4 + 1) + "] " + isosurfaceMesh.vs[n4] + ": " : isosurfaceMesh.thisID + ": ") + isosurfaceMesh.vvs[n4];
    }

    public String getCmd(int n) {
        SB sB = new SB().append("\n");
        this.getMeshCommand(sB, n);
        return sB.toString();
    }
}

