/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.c.CBK;
import org.jmol.console.GenericTextArea;
import org.jmol.i18n.GT;
import org.jmol.script.T;
import org.jmol.viewer.Viewer;

public abstract class GenericConsole
implements JmolAppConsoleInterface,
JmolCallbackListener {
    protected GenericTextArea input;
    protected GenericTextArea output;
    public Viewer vwr;
    protected static Map<String, String> labels;
    protected Map<String, Object> menuMap = new Hashtable<String, Object>();
    protected JmolAbstractButton editButton;
    protected JmolAbstractButton runButton;
    protected JmolAbstractButton historyButton;
    protected JmolAbstractButton stateButton;
    protected JmolAbstractButton clearOutButton;
    protected JmolAbstractButton clearInButton;
    protected JmolAbstractButton loadButton;
    protected String defaultMessage;
    protected JmolAbstractButton label1;
    public int nTab = 0;
    private String incompleteCmd;

    protected void setViewer(Viewer viewer) {
        this.vwr = viewer;
        if (labels == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("title", GT._("Jmol Script Console") + " " + Viewer.getJmolVersion());
            this.setupLabels(hashtable);
            labels = hashtable;
        }
    }

    protected abstract boolean isMenuItem(Object var1);

    protected abstract void layoutWindow(String var1);

    protected abstract void setTitle();

    @Override
    public abstract void setVisible(boolean var1);

    @Override
    public abstract JmolScriptEditorInterface getScriptEditor();

    @Override
    public abstract void dispose();

    protected abstract JmolAbstractButton setButton(String var1);

    protected JmolAbstractButton addButton(JmolAbstractButton jmolAbstractButton, String string) {
        jmolAbstractButton.addConsoleListener(this);
        this.menuMap.put(string, jmolAbstractButton);
        return jmolAbstractButton;
    }

    protected JmolAbstractButton getLabel1() {
        return null;
    }

    protected void setupLabels(Map<String, String> map) {
        map.put("saveas", GT._("&Save As..."));
        map.put("file", GT._("&File"));
        map.put("close", GT._("&Close"));
        this.setupLabels0(map);
    }

    protected void setupLabels0(Map<String, String> map) {
        map.put("help", GT._("&Help"));
        map.put("search", GT._("&Search..."));
        map.put("commands", GT._("&Commands"));
        map.put("functions", GT._("Math &Functions"));
        map.put("parameters", GT._("Set &Parameters"));
        map.put("more", GT._("&More"));
        map.put("Editor", GT._("Editor"));
        map.put("State", GT._("State"));
        map.put("Run", GT._("Run"));
        map.put("Clear Output", GT._("Clear Output"));
        map.put("Clear Input", GT._("Clear Input"));
        map.put("History", GT._("History"));
        map.put("Load", GT._("Load"));
        map.put("label1", GT._("press CTRL-ENTER for new line or paste model data and press Load"));
        map.put("default", GT._("Messages will appear here. Enter commands in the box below. Click the console Help menu item for on-line help, which will appear in a new browser window."));
    }

    protected void setLabels() {
        boolean bl = GT.setDoTranslate(true);
        this.editButton = this.setButton("Editor");
        this.stateButton = this.setButton("State");
        this.runButton = this.setButton("Run");
        this.clearOutButton = this.setButton("Clear Output");
        this.clearInButton = this.setButton("Clear Input");
        this.historyButton = this.setButton("History");
        this.loadButton = this.setButton("Load");
        this.defaultMessage = GenericConsole.getLabel("default");
        this.setTitle();
        GT.setDoTranslate(bl);
    }

    public static String getLabel(String string) {
        return labels.get(string);
    }

    protected void displayConsole() {
        this.layoutWindow(null);
        this.outputMsg(this.defaultMessage);
    }

    protected void updateLabels() {
    }

    protected abstract String nextFileName(String var1, int var2);

    public String completeCommand(String string) {
        String string2;
        if (string.length() == 0) {
            return null;
        }
        this.incompleteCmd = string2 = this.nTab <= 0 || this.incompleteCmd == null ? string : this.incompleteCmd;
        String[] stringArray = GenericConsole.splitCommandLine(string);
        if (stringArray == null) {
            return null;
        }
        boolean bl = stringArray[2] == null;
        boolean bl2 = stringArray[3] != null;
        String string3 = stringArray[bl ? 1 : 2];
        String string4 = stringArray[1];
        if (string3.length() == 0) {
            return null;
        }
        T t = T.getTokenFromName(string4.trim().toLowerCase());
        int n = t == null ? 0 : t.tok;
        boolean bl3 = T.tokAttr(n, 12288);
        stringArray = GenericConsole.splitCommandLine(string2);
        String string5 = null;
        if (!(bl || string3.charAt(0) != '\"' && string3.charAt(0) != '\'')) {
            char c = string3.charAt(0);
            string3 = PT.trim(string3, "\"'");
            String string6 = PT.trim(stringArray[2], "\"'");
            string5 = this.nextFileName(string6, this.nTab);
            if (string5 != null) {
                string5 = stringArray[0] + stringArray[1] + c + string5 + c;
            }
        } else {
            Hashtable hashtable = null;
            if (!bl) {
                string3 = string4;
                if (bl2 || stringArray[2].startsWith("$") || bl3) {
                    hashtable = new Hashtable();
                    this.vwr.getObjectMap(hashtable, (char)(bl2 || bl3 ? 123 : (stringArray[2].startsWith("$") ? 36 : 48)));
                }
            }
            string5 = T.completeCommand(hashtable, string4.equalsIgnoreCase("set "), bl, bl ? stringArray[1] : stringArray[2], this.nTab);
            string5 = stringArray[0] + (string5 == null ? string3 : (bl ? string5 : stringArray[1] + string5));
        }
        return string5 == null || string5.equals(string2) ? null : string5;
    }

    protected void doAction(Object object) {
        if (object == this.runButton) {
            this.execute(null);
        } else if (object == this.editButton) {
            this.vwr.getProperty("DATA_API", "scriptEditor", null);
        } else if (object == this.historyButton) {
            this.clearContent(this.vwr.getSetHistory(Integer.MAX_VALUE));
        } else if (object == this.stateButton) {
            this.clearContent(this.vwr.getStateInfo());
        } else if (object == this.clearInButton) {
            this.input.setText("");
            return;
        }
        if (object == this.clearOutButton) {
            this.output.setText("");
            return;
        }
        if (object == this.loadButton) {
            this.vwr.loadInlineAppend(this.input.getText(), false);
            return;
        }
        if (this.isMenuItem(object)) {
            this.execute(((JmolAbstractButton)object).getName());
            return;
        }
    }

    protected void execute(String string) {
        String string2;
        String string3;
        String string4 = string3 = string == null ? this.input.getText() : string;
        if (string == null) {
            this.input.setText(null);
        }
        if ((string2 = this.vwr.script(string3 + "\u0001## EDITOR_IGNORE ##")) != null && !string2.equals("pending")) {
            this.outputMsg(string2);
        }
    }

    protected void destroyConsole() {
        if (this.vwr.isApplet) {
            this.vwr.getProperty("DATA_API", "getAppConsole", Boolean.FALSE);
        }
    }

    public static void setAbstractButtonLabels(Map<String, Object> map, Map<String, String> map2) {
        for (String string : map.keySet()) {
            JmolAbstractButton jmolAbstractButton = (JmolAbstractButton)map.get(string);
            String string2 = map2.get(string);
            if (string.indexOf("Tip") == string.length() - 3) {
                jmolAbstractButton.setToolTipText(map2.get(string));
                continue;
            }
            char c = GenericConsole.getMnemonic(string2);
            if (c != ' ') {
                jmolAbstractButton.setMnemonic(c);
            }
            string2 = GenericConsole.getLabelWithoutMnemonic(string2);
            jmolAbstractButton.setText(string2);
        }
    }

    public static String getLabelWithoutMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + (n < string.length() - 1 ? string.substring(n + 1) : "");
    }

    static char getMnemonic(String string) {
        if (string == null) {
            return ' ';
        }
        int n = string.indexOf(38);
        if (n == -1 || n == string.length() - 1) {
            return ' ';
        }
        return string.charAt(n + 1);
    }

    public static void map(Object object, String string, String string2, Map<String, Object> map) {
        char c = GenericConsole.getMnemonic(string2);
        if (c != ' ') {
            ((JmolAbstractButton)object).setMnemonic(c);
        }
        if (map != null) {
            map.put(string, object);
        }
    }

    @Override
    public boolean notifyEnabled(CBK cBK) {
        switch (cBK) {
            case ECHO: 
            case MEASURE: 
            case MESSAGE: 
            case PICK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(CBK cBK, Object[] objectArray) {
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (cBK) {
            case ECHO: {
                this.sendConsoleEcho(string);
                break;
            }
            case MEASURE: {
                String string2 = (String)objectArray[3];
                if (string2.indexOf("Picked") >= 0 || string2.indexOf("Sequence") >= 0) {
                    this.sendConsoleMessage(string);
                    break;
                }
                if (string2.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(string.substring(string.lastIndexOf(",") + 2, string.length() - 1));
                break;
            }
            case MESSAGE: {
                this.sendConsoleMessage(objectArray == null ? null : string);
                break;
            }
            case PICK: {
                this.sendConsoleMessage(string);
            }
        }
    }

    @Override
    public String getText() {
        return this.output.getText();
    }

    @Override
    public void sendConsoleEcho(String string) {
        if (string == null) {
            this.updateLabels();
            this.outputMsg(null);
            string = this.defaultMessage;
        } else if (string.equals("\u0000")) {
            string = null;
        }
        this.outputMsg(string);
    }

    private void outputMsg(String string) {
        int n = string == null ? -1 : string.length();
        switch (n) {
            case -1: {
                this.output.setText("");
                return;
            }
            default: {
                if (string.charAt(n - 1) == '\n') break;
            }
            case 0: {
                string = string + "\n";
            }
        }
        this.output.append(string);
    }

    protected void clearContent(String string) {
        this.output.setText(string);
    }

    @Override
    public void sendConsoleMessage(String string) {
        if (string != null && this.output.getText().startsWith(this.defaultMessage)) {
            this.outputMsg(null);
        }
        this.outputMsg(string);
    }

    @Override
    public void setCallbackFunction(String string, String string2) {
    }

    @Override
    public void zap() {
    }

    protected void recallCommand(boolean bl) {
        String string = this.vwr.getSetHistory(bl ? -1 : 1);
        if (string != null) {
            this.input.setText(PT.escUnicode(string));
        }
    }

    protected int processKey(int n, int n2, boolean bl) {
        int n3 = 0;
        switch (n2) {
            case 401: {
                switch (n) {
                    case 9: {
                        String string = this.input.getText();
                        if (string.endsWith("\n") || string.endsWith("\t")) {
                            return 0;
                        }
                        n3 = 1;
                        if (this.input.getCaretPosition() != string.length()) break;
                        String string2 = this.completeCommand(string);
                        if (string2 != null) {
                            this.input.setText(PT.escUnicode(string2).replace('\t', ' '));
                        }
                        ++this.nTab;
                        return n3;
                    }
                    case 27: {
                        n3 = 1;
                        this.input.setText("");
                    }
                }
                this.nTab = 0;
                if (n == 10 && !bl) {
                    this.execute(null);
                    return n3;
                }
                if (n != 38 && n != 40) break;
                this.recallCommand(n == 38);
                return n3;
            }
            case 402: {
                if (n != 10 || bl) break;
                return n3;
            }
        }
        return n3 | 2;
    }

    private static String[] splitCommandLine(String string) {
        String[] stringArray = new String[4];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.length() == 0) {
            return null;
        }
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (bl3 || bl) break;
                    boolean bl4 = bl2 = !bl2;
                    if (!bl2) break;
                    n = n3 = i;
                    break;
                }
                case '\'': {
                    if (bl3 || bl2) break;
                    boolean bl5 = bl = !bl;
                    if (!bl) break;
                    n = n3 = i;
                    break;
                }
                case '\\': {
                    bl3 = !bl3;
                    continue block8;
                }
                case ' ': {
                    if (bl3 || bl || bl2) break;
                    n3 = i + 1;
                    n = -1;
                    break;
                }
                case ';': {
                    if (bl || bl2) break;
                    n2 = n3 = i + 1;
                    n = -1;
                    n4 = 0;
                    break;
                }
                case '{': 
                case '}': {
                    if (bl || bl2) break;
                    n4 += c == '{' ? 1 : -1;
                    n3 = i + 1;
                    n = -1;
                    break;
                }
                default: {
                    if (bl || bl2) break;
                    n = -1;
                }
            }
            bl3 = false;
        }
        stringArray[0] = string.substring(0, n2);
        stringArray[1] = n3 == n2 ? string.substring(n2) : string.substring(n2, n3 > n ? n3 : n);
        stringArray[2] = n3 == n2 ? null : string.substring(n3);
        stringArray[3] = n4 > 0 ? "{" : null;
        return stringArray;
    }
}

