/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.AU;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.ModulationSet;

public class Modulation {
    private static final double TWOPI = Math.PI * 2;
    private double[] qCoefs;
    private double a1;
    private double a2;
    private double center;
    private double left;
    private double right;
    private int order;
    private char axis;
    private final char type;
    private double[] params;
    private String utens;
    private double delta2;
    public static final char TYPE_DISP_FOURIER = 'f';
    public static final char TYPE_SPIN_FOURIER = 'm';
    public static final char TYPE_SPIN_SAWTOOTH = 't';
    public static final char TYPE_DISP_SAWTOOTH = 's';
    public static final char TYPE_OCC_FOURIER = 'o';
    public static final char TYPE_OCC_CRENEL = 'c';
    public static final char TYPE_U_FOURIER = 'u';
    public static final char TYPE_DISP_LEGENDRE = 'l';
    public static final char TYPE_U_LEGENDRE = 'L';
    static double[][] legendre = new double[][]{{1.0}, {0.0, 1.0}};

    public Modulation(char c, char c2, double[] dArray, String string, double[] dArray2) {
        Logger.info("MOD create " + Escape.e(dArray2) + " axis=" + c + " type=" + c2 + " params=" + Escape.e(dArray) + " utens=" + string);
        this.axis = c;
        this.type = c2;
        this.utens = string;
        this.params = dArray;
        this.qCoefs = dArray2;
        switch (c2) {
            case 'f': 
            case 'm': 
            case 'o': 
            case 'u': {
                this.a1 = dArray[0];
                this.a2 = dArray[1];
                break;
            }
            case 'L': 
            case 'l': {
                this.a1 = dArray[2];
                this.order = (int)dArray[3];
                this.calcLegendre(this.order);
            }
            case 'c': 
            case 's': 
            case 't': {
                this.center = dArray[0];
                this.delta2 = dArray[1] / 2.0;
                if (this.delta2 > 0.5) {
                    this.delta2 = 0.5;
                }
                this.left = this.center - this.delta2;
                this.right = this.center + this.delta2;
                if (this.left < 0.0) {
                    this.left += 1.0;
                }
                if (this.right > 1.0) {
                    this.right -= 1.0;
                }
                if (this.left >= this.right && this.left - this.right < (double)0.01f) {
                    this.left = this.right + (double)0.01f;
                }
                if (this.a1 != 0.0) break;
                this.a1 = dArray[2] / this.delta2;
            }
        }
    }

    void apply(ModulationSet modulationSet, double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        int n = this.qCoefs.length;
        while (--n >= 0) {
            d2 += this.qCoefs[n] * dArray[n][0];
        }
        switch (this.type) {
            case 'm': {
                bl = true;
            }
            case 'f': 
            case 'o': 
            case 'u': {
                double d3 = Math.PI * 2 * d2;
                if (this.a1 != 0.0) {
                    d += this.a1 * Math.sin(d3);
                }
                if (this.a2 != 0.0) {
                    d += this.a2 * Math.cos(d3);
                }
                if (!Logger.debuggingHigh) break;
                Logger.info("MOD " + modulationSet.id + " " + Escape.e(this.qCoefs) + " axis=" + this.axis + " v=" + d + " csin,ccos=" + this.a1 + "," + this.a2 + " / theta=" + d3);
                break;
            }
            case 'L': 
            case 'l': {
                double d4;
                modulationSet.occAbsolute = true;
                d2 -= Math.floor(d2);
                if (!this.range(d2)) {
                    modulationSet.vOcc = 0.0f;
                    return;
                }
                modulationSet.vOcc = 1.0f;
                d4 = (d4 + 1.0) % 2.0 + (double)((d4 = (d2 - this.center) / this.delta2) < -1.0 ? 1 : -1);
                double d5 = 1.0;
                double[] dArray2 = legendre[this.order];
                int n2 = 0;
                int n3 = dArray2.length;
                while (true) {
                    d += dArray2[n2] * d5;
                    if (++n2 == n3) break;
                    d5 *= d4;
                }
                d *= this.a1;
                break;
            }
            case 'c': {
                modulationSet.occAbsolute = true;
                modulationSet.vOcc = this.range(d2 - Math.floor(d2)) ? 1 : 0;
                return;
            }
            case 't': {
                bl = true;
            }
            case 's': {
                modulationSet.occAbsolute = true;
                d2 -= Math.floor(d2);
                if (!this.range(d2)) {
                    modulationSet.vOcc = 0.0f;
                    return;
                }
                modulationSet.vOcc = 1.0f;
                if (this.left > this.right) {
                    if (d2 < this.left && this.left < this.center) {
                        d2 += 1.0;
                    } else if (d2 > this.right && this.right > this.center) {
                        d2 -= 1.0;
                    }
                }
                d = this.a1 * (d2 - this.center);
            }
        }
        if (bl) {
            float[] fArray = modulationSet.axesLengths;
            switch (this.axis) {
                case 'x': {
                    modulationSet.mxyz.x = (float)((double)modulationSet.mxyz.x + d / (double)fArray[0]);
                    break;
                }
                case 'y': {
                    modulationSet.mxyz.y = (float)((double)modulationSet.mxyz.y + d / (double)fArray[1]);
                    break;
                }
                case 'z': {
                    modulationSet.mxyz.z = (float)((double)modulationSet.mxyz.z + d / (double)fArray[2]);
                }
            }
        } else {
            switch (this.axis) {
                case 'x': {
                    modulationSet.x = (float)((double)modulationSet.x + d);
                    break;
                }
                case 'y': {
                    modulationSet.y = (float)((double)modulationSet.y + d);
                    break;
                }
                case 'z': {
                    modulationSet.z = (float)((double)modulationSet.z + d);
                    break;
                }
                case 'U': {
                    modulationSet.addUTens(this.utens, (float)d);
                    break;
                }
                default: {
                    if (Float.isNaN(modulationSet.vOcc)) {
                        modulationSet.vOcc = 0.0f;
                    }
                    modulationSet.vOcc += (float)d;
                }
            }
        }
    }

    private boolean range(double d) {
        return this.left < this.right ? this.left <= d && d <= this.right : this.left <= d || d <= this.right;
    }

    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("type", "" + this.type + this.axis);
        hashtable.put("params", this.params);
        hashtable.put("qCoefs", this.qCoefs);
        if (this.utens != null) {
            hashtable.put("Utens", this.utens);
        }
        return hashtable;
    }

    synchronized void calcLegendre(int n) {
        int n2 = legendre.length;
        if (n2 > n) {
            return;
        }
        double[][] dArray = AU.newDouble2((n += 3) + 1);
        for (int i = 0; i < n2; ++i) {
            dArray[i] = legendre[i];
        }
        while (n2 <= n) {
            dArray[n2] = new double[n2 + 1];
            double[] dArray2 = dArray[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i + 1] = (double)(2 * n2 - 1) * dArray[n2 - 1][i] / (double)n2;
                if (i >= n2 - 1) continue;
                int n3 = i;
                dArray2[n3] = dArray2[n3] + (double)(1 - n2) * dArray[n2 - 2][i] / (double)n2;
            }
            ++n2;
        }
        legendre = dArray;
    }
}

