/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class CastepDensityReader
extends PeriodicVolumeFileReader {
    private int nFilePoints;
    private int nSkip;

    CastepDensityReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isProgressive = false;
        this.isAngstroms = true;
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        this.nSkip = n;
    }

    @Override
    protected void readParameters() throws Exception {
        int n;
        this.jvxlFileHeaderBuffer = new SB();
        while (this.rd() != null && this.line.indexOf(".") < 0) {
        }
        for (n = 0; n < 3; ++n) {
            V3 v3 = this.volumetricVectors[n];
            v3.set(this.parseFloatStr(this.line), this.parseFloat(), this.parseFloat());
            this.rd();
        }
        this.nSurfaces = this.parseIntStr(this.rd());
        this.rd();
        this.nPointsX = this.parseIntStr(this.line);
        this.voxelCounts[0] = this.nPointsX + 1;
        this.nPointsY = this.parseInt();
        this.voxelCounts[1] = this.nPointsY + 1;
        this.nPointsZ = this.parseInt();
        this.voxelCounts[2] = this.nPointsZ + 1;
        this.nFilePoints = this.nPointsX++ * this.nPointsY++ * this.nPointsZ++;
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        for (n = 0; n < 3; ++n) {
            this.volumetricVectors[n].scale(1.0f / (float)(this.voxelCounts[n] - 1));
            if (!this.isAnisotropic) continue;
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
        while (this.rd().trim().length() > 0) {
        }
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int n;
        int n2;
        this.rd();
        String[] stringArray = this.getTokens();
        if (this.nSkip > 0 && stringArray.length < 3 + this.nSurfaces) {
            for (n2 = 0; n2 < this.nSkip; ++n2) {
                for (n = 0; n < this.nFilePoints; ++n) {
                    this.rd();
                }
            }
            this.nSkip = 0;
        }
        if ((n2 = this.downsampleFactor) > 1) {
            for (n = 0; n < this.nFilePoints; ++n) {
                int n3 = this.parseIntStr(this.line) - 1;
                int n4 = this.parseInt() - 1;
                int n5 = this.parseInt() - 1;
                if (n3 % n2 == 0 && n4 % n2 == 0 && n5 % n2 == 0) {
                    if (this.nSkip > 0) {
                        this.skipPoints(this.nSkip);
                    }
                    this.voxelData[n3 / n2][n4 / n2][n5 / n2] = this.recordData(this.parseFloat());
                }
                this.rd();
            }
        } else {
            for (n = 0; n < this.nFilePoints; ++n) {
                int n6 = this.parseIntStr(this.line) - 1;
                int n7 = this.parseInt() - 1;
                int n8 = this.parseInt() - 1;
                if (this.nSkip > 0) {
                    this.skipPoints(this.nSkip);
                }
                this.voxelData[n6][n7][n8] = this.recordData(this.parseFloat());
                this.rd();
            }
        }
    }

    private void skipPoints(int n) {
        int n2 = this.next[0];
        for (int i = 0; i < n; ++i) {
            while (n2 < this.line.length() && PT.isWhitespace(this.line.charAt(n2++))) {
            }
            while (n2 < this.line.length() && !PT.isWhitespace(this.line.charAt(n2++))) {
            }
        }
        this.next[0] = n2;
    }
}

