/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.List;
import org.openstreetmap.josm.corrector.CorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.tools.I18n;

public class TagCorrectionTableModel
extends CorrectionTableModel<TagCorrection> {
    public TagCorrectionTableModel(List<TagCorrection> list) {
        super(list);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getCorrectionColumnName(int n) {
        switch (n) {
            case 0: {
                return I18n.tr("Old key", new Object[0]);
            }
            case 1: {
                return I18n.tr("Old value", new Object[0]);
            }
            case 2: {
                return I18n.tr("New key", new Object[0]);
            }
            case 3: {
                return I18n.tr("New value", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public Object getCorrectionValueAt(int n, int n2) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(n);
        switch (n2) {
            case 0: {
                return tagCorrection.oldKey;
            }
            case 1: {
                return tagCorrection.oldValue;
            }
            case 2: {
                return tagCorrection.newKey;
            }
            case 3: {
                return tagCorrection.newValue;
            }
        }
        return null;
    }

    @Override
    protected boolean isBoldCell(int n, int n2) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(n);
        return n2 == 2 && tagCorrection.isKeyChanged() || n2 == 3 && tagCorrection.isValueChanged();
    }
}

