/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.InputSource;

public class CachedAttributionBingAerialTileSource
extends BingAerialTileSource {
    private Runnable attributionDownloadedTask;

    public CachedAttributionBingAerialTileSource(ImageryInfo imageryInfo) {
        super(imageryInfo);
    }

    public CachedAttributionBingAerialTileSource(TileSourceInfo tileSourceInfo, Runnable runnable) {
        super(tileSourceInfo);
        this.attributionDownloadedTask = runnable;
    }

    @Override
    protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
        return new Callable<List<BingAerialTileSource.Attribution>>(){

            @Override
            public List<BingAerialTileSource.Attribution> call() throws Exception {
                BingAttributionData bingAttributionData = new BingAttributionData();
                int n = 1;
                while (true) {
                    try {
                        String string = bingAttributionData.updateIfRequiredString();
                        List list = CachedAttributionBingAerialTileSource.this.parseAttributionText(new InputSource(new StringReader(string)));
                        if (CachedAttributionBingAerialTileSource.this.attributionDownloadedTask != null) {
                            GuiHelper.runInEDT(CachedAttributionBingAerialTileSource.this.attributionDownloadedTask);
                            CachedAttributionBingAerialTileSource.this.attributionDownloadedTask = null;
                        }
                        return list;
                    }
                    catch (IOException iOException) {
                        Main.warn("Could not connect to Bing API. Will retry in " + n + " seconds.");
                        Thread.sleep((long)n * 1000L);
                        n *= 2;
                        continue;
                    }
                    break;
                }
            }
        };
    }

    class BingAttributionData
    extends CacheCustomContent<IOException> {
        BingAttributionData() {
            super("bing.attribution.xml", 3600);
        }

        @Override
        protected byte[] updateData() throws IOException {
            URL uRL = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
            try (Scanner scanner = new Scanner(UTFInputStreamReader.create(Utils.openURL(uRL)));){
                String string = scanner.useDelimiter("\\A").next();
                Main.info("Successfully loaded Bing attribution data.");
                byte[] byArray = string.getBytes("UTF-8");
                return byArray;
            }
        }
    }
}

