/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
Preferences.PreferenceChangedListener,
OsmDataLayer.LayerStateChangeListener {
    public boolean viewportFollowing;
    private static final CopyOnWriteArrayList<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<EditLayerChangeListener> editLayerChangeListeners = new CopyOnWriteArrayList();
    private final transient List<Layer> layers = new ArrayList<Layer>();
    public transient PlayHeadMarker playHeadMarker;
    private transient Layer activeLayer;
    private transient OsmDataLayer editLayer;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private final transient Set<MapViewPaintable> temporaryLayers = new LinkedHashSet<MapViewPaintable>();
    private transient BufferedImage nonChangedLayersBuffer;
    private transient BufferedImage offscreenBuffer;
    private final transient List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private transient Layer changedLayer;
    private int lastViewID;
    private boolean paintPreferencesChanged = true;
    private Rectangle lastClipBounds = new Rectangle();
    private transient MapMover mapMover;
    private Dimension oldSize;
    private Point oldLoc;
    private boolean virtualNodesEnabled;
    private transient SelectionChangedListener repaintSelectionChangedListener = new SelectionChangedListener(){

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            MapView.this.repaint();
        }
    };
    private final CopyOnWriteArrayList<RepaintListener> repaintListeners = new CopyOnWriteArrayList();

    public static void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        layerChangeListeners.remove(layerChangeListener);
    }

    public static void removeEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        editLayerChangeListeners.remove(editLayerChangeListener);
    }

    public static void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (layerChangeListener != null) {
            layerChangeListeners.addIfAbsent(layerChangeListener);
        }
    }

    public static void addLayerChangeListener(LayerChangeListener layerChangeListener, boolean bl) {
        MapView.addLayerChangeListener(layerChangeListener);
        if (bl && Main.isDisplayingMapView()) {
            layerChangeListener.activeLayerChange(null, Main.map.mapView.getActiveLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener, boolean bl) {
        MapView.addEditLayerChangeListener(editLayerChangeListener);
        if (bl && Main.isDisplayingMapView() && Main.map.mapView.getEditLayer() != null) {
            editLayerChangeListener.editLayerChanged(null, Main.map.mapView.getEditLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        if (editLayerChangeListener != null) {
            editLayerChangeListeners.addIfAbsent(editLayerChangeListener);
        }
    }

    protected void fireActiveLayerChanged(Layer layer, Layer layer2) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.activeLayerChange(layer, layer2);
        }
    }

    protected void fireLayerAdded(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerAdded(layer);
        }
    }

    protected void fireLayerRemoved(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerRemoved(layer);
        }
    }

    protected void fireEditLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        for (EditLayerChangeListener editLayerChangeListener : editLayerChangeListeners) {
            editLayerChangeListener.editLayerChanged(osmDataLayer, osmDataLayer2);
        }
    }

    public MapView(final JPanel jPanel, ViewportData viewportData) {
        this.initialViewport = viewportData;
        Main.pref.addPreferenceChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                for (JComponent jComponent : MapView.getMapNavigationComponents(MapView.this)) {
                    MapView.this.add(jComponent);
                }
                MapView.this.mapMover = new MapMover(MapView.this, jPanel);
            }
        });
        DataSet.addSelectionListener(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MapView.this.requestFocus();
            }
        });
        if (Shortcut.findShortcut(9, 0) != null) {
            this.setFocusTraversalKeysEnabled(false);
        }
    }

    public static List<? extends JComponent> getMapNavigationComponents(MapView mapView) {
        MapSlider mapSlider = new MapSlider(mapView);
        mapSlider.setBounds(3, 0, 114, 30);
        mapSlider.setFocusTraversalKeysEnabled(Shortcut.findShortcut(9, 0) == null);
        MapScaler mapScaler = new MapScaler(mapView);
        mapScaler.setLocation(10, 30);
        return Arrays.asList(mapSlider, mapScaler);
    }

    public void rememberLastPositionOnScreen() {
        this.oldSize = this.getSize();
        this.oldLoc = this.getLocationOnScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGpxLayer(GpxLayer gpxLayer) {
        List<Layer> list = this.layers;
        synchronized (list) {
            if (this.layers.isEmpty()) {
                this.layers.add(gpxLayer);
                return;
            }
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                if (!(this.layers.get(i) instanceof OsmDataLayer)) continue;
                if (i == this.layers.size() - 1) {
                    this.layers.add(gpxLayer);
                } else {
                    this.layers.add(i + 1, gpxLayer);
                }
                return;
            }
            this.layers.add(0, gpxLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayer(Layer layer) {
        boolean bl = layer instanceof OsmDataLayer;
        EnumSet<LayerListenerType> enumSet = EnumSet.noneOf(LayerListenerType.class);
        Layer layer2 = this.activeLayer;
        OsmDataLayer osmDataLayer = this.editLayer;
        List<Layer> list = this.layers;
        synchronized (list) {
            if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
                this.playHeadMarker = PlayHeadMarker.create();
            }
            if (layer instanceof GpxLayer) {
                this.addGpxLayer((GpxLayer)layer);
            } else if (this.layers.isEmpty()) {
                this.layers.add(layer);
            } else if (layer.isBackgroundLayer()) {
                int n;
                for (n = 0; n < this.layers.size() && !this.layers.get(n).isBackgroundLayer(); ++n) {
                }
                this.layers.add(n, layer);
            } else {
                this.layers.add(0, layer);
            }
            if (bl || layer2 == null) {
                enumSet.addAll(this.setActiveLayer(layer, true));
            }
            if (bl) {
                ((OsmDataLayer)layer).addLayerStateChangeListener(this);
            }
            layer.addPropertyChangeListener(this);
            Main.addProjectionChangeListener(layer);
            AudioPlayer.reset();
        }
        this.fireLayerAdded(layer);
        this.onActiveEditLayerChanged(layer2, osmDataLayer, enumSet);
        if (!enumSet.isEmpty()) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet getCurrentDataSet() {
        List<Layer> list = this.layers;
        synchronized (list) {
            if (this.editLayer != null) {
                return this.editLayer.data;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveLayerDrawable() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.editLayer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveLayerVisible() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.isActiveLayerDrawable() && this.editLayer.isVisible();
        }
    }

    protected Layer determineNextActiveLayer(List<Layer> list) {
        for (Layer layer : list) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayer(Layer layer) {
        EnumSet<LayerListenerType> enumSet = EnumSet.noneOf(LayerListenerType.class);
        Layer layer2 = this.activeLayer;
        OsmDataLayer osmDataLayer = this.editLayer;
        List<Layer> list = this.layers;
        synchronized (list) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>(this.layers);
            if (!arrayList.remove(layer)) {
                return;
            }
            enumSet = this.setEditLayer(arrayList);
            if (layer == this.activeLayer) {
                enumSet.addAll(this.setActiveLayer(this.determineNextActiveLayer(arrayList), false));
            }
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).removeLayerPropertyChangeListener(this);
            }
            this.layers.remove(layer);
            Main.removeProjectionChangeListener(layer);
            layer.removePropertyChangeListener(this);
            layer.destroy();
            AudioPlayer.reset();
        }
        this.onActiveEditLayerChanged(layer2, osmDataLayer, enumSet);
        this.fireLayerRemoved(layer);
        this.repaint();
    }

    private void onEditLayerChanged(OsmDataLayer osmDataLayer) {
        this.fireEditLayerChanged(osmDataLayer, this.editLayer);
        this.refreshTitle();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveLayer(Layer layer, int n) {
        EnumSet<LayerListenerType> enumSet;
        Layer layer2 = this.activeLayer;
        OsmDataLayer osmDataLayer = this.editLayer;
        List<Layer> list = this.layers;
        synchronized (list) {
            int n2 = this.layers.indexOf(layer);
            if (n2 == -1) {
                throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
            }
            if (n == n2) {
                return;
            }
            this.layers.remove(n2);
            if (n >= this.layers.size()) {
                this.layers.add(layer);
            } else {
                this.layers.add(n, layer);
            }
            enumSet = this.setEditLayer(this.layers);
            AudioPlayer.reset();
        }
        this.onActiveEditLayerChanged(layer2, osmDataLayer, enumSet);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayerPos(Layer layer) {
        int n;
        List<Layer> list = this.layers;
        synchronized (list) {
            n = this.layers.indexOf(layer);
        }
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getVisibleLayersInZOrder() {
        List<Layer> list = this.layers;
        synchronized (list) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            boolean bl = false;
            ListIterator<Layer> listIterator = this.layers.listIterator(this.layers.size());
            while (listIterator.hasPrevious()) {
                Layer layer = listIterator.previous();
                if (!layer.isVisible()) continue;
                if (layer == this.activeLayer && layer instanceof OsmDataLayer) {
                    bl = true;
                    continue;
                }
                if (bl && !(layer instanceof OsmDataLayer)) {
                    arrayList.add(this.activeLayer);
                    bl = false;
                }
                arrayList.add(layer);
            }
            if (bl) {
                arrayList.add(this.activeLayer);
            }
            return arrayList;
        }
    }

    private void paintLayer(Layer layer, Graphics2D graphics2D, Bounds bounds) {
        if (layer.getOpacity() < 1.0) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
        }
        layer.paint(graphics2D, this, bounds);
        graphics2D.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics graphics) {
        double d;
        int n;
        int d2;
        Graphics2D object3;
        boolean bl;
        if (!this.prepareToDraw()) {
            return;
        }
        List<Layer> list = this.getVisibleLayersInZOrder();
        int n3 = 0;
        for (Layer object2 : list) {
            if (object2.isChanged() || object2 == this.changedLayer) break;
            ++n3;
        }
        MapView i = this;
        synchronized (i) {
            bl = !this.paintPreferencesChanged;
            this.paintPreferencesChanged = false;
        }
        boolean bl2 = bl = bl && this.nonChangedLayers.size() <= n3 && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(graphics.getClipBounds());
        if (bl) {
            void var5_9;
            boolean graphics2D2 = false;
            while (var5_9 < this.nonChangedLayers.size()) {
                if (list.get((int)var5_9) != this.nonChangedLayers.get((int)var5_9)) {
                    bl = false;
                    break;
                }
                ++var5_9;
            }
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(graphics.getClip());
        Bounds bounds = this.getLatLonBounds(graphics.getClipBounds());
        if (!bl || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != this.getWidth() || this.nonChangedLayersBuffer.getHeight() != this.getHeight()) {
                this.nonChangedLayersBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            }
            object3 = this.nonChangedLayersBuffer.createGraphics();
            object3.setClip(graphics.getClip());
            object3.setColor(PaintColors.getBackgroundColor());
            object3.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (d2 = 0; d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), object3, bounds);
            }
        } else if (this.nonChangedLayers.size() != n3) {
            object3 = this.nonChangedLayersBuffer.createGraphics();
            object3.setClip(graphics.getClip());
            for (d2 = this.nonChangedLayers.size(); d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), object3, bounds);
            }
        }
        this.nonChangedLayers.clear();
        this.changedLayer = null;
        for (n = 0; n < n3; ++n) {
            this.nonChangedLayers.add(list.get(n));
        }
        this.lastViewID = this.getViewID();
        this.lastClipBounds = graphics.getClipBounds();
        graphics2D.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        for (n = n3; n < list.size(); ++n) {
            this.paintLayer(list.get(n), graphics2D, bounds);
        }
        Object object = this.temporaryLayers;
        synchronized (object) {
            for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
                mapViewPaintable.paint(graphics2D, this, bounds);
            }
        }
        graphics2D.setColor(Color.WHITE);
        object = this.getProjection().getWorldBoundsLatLon();
        double d3 = ((Bounds)object).getMinLon();
        Point point = this.getPoint(((Bounds)object).getMin());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point.x, point.y);
        double d4 = ((Bounds)object).getMax().lat();
        for (d = ((Bounds)object).getMinLat(); d <= d4; d += 1.0) {
            point = this.getPoint(new LatLon(d >= d4 ? d4 : d, d3));
            generalPath.lineTo(point.x, point.y);
        }
        d = d4;
        d4 = ((Bounds)object).getMax().lon();
        while (d3 <= d4) {
            point = this.getPoint(new LatLon(d, d3 >= d4 ? d4 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 += 1.0;
        }
        d3 = d4;
        d4 = ((Bounds)object).getMinLat();
        while (d >= d4) {
            point = this.getPoint(new LatLon(d <= d4 ? d4 : d, d3));
            generalPath.lineTo(point.x, point.y);
            d -= 1.0;
        }
        d = d4;
        d4 = ((Bounds)object).getMinLon();
        while (d3 >= d4) {
            point = this.getPoint(new LatLon(d, d3 <= d4 ? d4 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 -= 1.0;
        }
        int n2 = this.getWidth();
        int n4 = this.getHeight();
        Area area = new Area(generalPath);
        Area area2 = new Area(new Rectangle(-1, -1, n2 + 2, n4 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
        if (Main.isDisplayingMapView() && Main.map.filterDialog != null) {
            Main.map.filterDialog.drawOSDText(graphics2D);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public boolean prepareToDraw() {
        if (this.initialViewport != null) {
            this.zoomTo(this.initialViewport);
            this.initialViewport = null;
        }
        if (BugReportExceptionHandler.exceptionHandlingInProgress()) {
            return false;
        }
        if (this.getCenter() == null) {
            return false;
        }
        if (this.oldLoc != null && this.oldSize != null) {
            Point point = this.getLocationOnScreen();
            EastNorth eastNorth = new EastNorth(this.getCenter().getX() + ((double)(point.x - this.oldLoc.x) - (double)(this.oldSize.width - this.getWidth()) / 2.0) * this.getScale(), this.getCenter().getY() + ((double)(this.oldLoc.y - point.y) + (double)(this.oldSize.height - this.getHeight()) / 2.0) * this.getScale());
            this.oldLoc = null;
            this.oldSize = null;
            this.zoomTo(eastNorth);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Layer> getAllLayers() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return Collections.unmodifiableCollection(new ArrayList<Layer>(this.layers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getAllLayersAsList() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Layer>(this.layers));
        }
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> clazz) {
        return new ArrayList(Utils.filteredCollection(this.getAllLayers(), clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLayers() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.layers.size();
        }
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    private EnumSet<LayerListenerType> setEditLayer(List<Layer> list) {
        OsmDataLayer osmDataLayer = this.findNewEditLayer(list);
        if (osmDataLayer != this.editLayer) {
            if (osmDataLayer == null) {
                this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
            }
            this.editLayer = osmDataLayer;
            return EnumSet.of(LayerListenerType.EDIT_LAYER_CHANGE);
        }
        return EnumSet.noneOf(LayerListenerType.class);
    }

    private OsmDataLayer findNewEditLayer(List<Layer> list) {
        OsmDataLayer osmDataLayer;
        OsmDataLayer osmDataLayer2 = osmDataLayer = list.contains(this.editLayer) ? this.editLayer : null;
        if (this.activeLayer != this.editLayer || !list.contains(this.editLayer)) {
            if (this.activeLayer instanceof OsmDataLayer && list.contains(this.activeLayer)) {
                osmDataLayer = (OsmDataLayer)this.activeLayer;
            } else {
                for (Layer layer : list) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    osmDataLayer = (OsmDataLayer)layer;
                    break;
                }
            }
        }
        return osmDataLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveLayer(Layer layer) {
        EnumSet<LayerListenerType> enumSet;
        OsmDataLayer osmDataLayer;
        Layer layer2;
        List<Layer> list = this.layers;
        synchronized (list) {
            layer2 = this.activeLayer;
            osmDataLayer = this.editLayer;
            enumSet = this.setActiveLayer(layer, true);
        }
        this.onActiveEditLayerChanged(layer2, osmDataLayer, enumSet);
        this.repaint();
    }

    private EnumSet<LayerListenerType> setActiveLayer(Layer layer, boolean bl) {
        if (layer != null && !this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (layer == this.activeLayer) {
            return EnumSet.noneOf(LayerListenerType.class);
        }
        this.activeLayer = layer;
        EnumSet<LayerListenerType> enumSet = EnumSet.of(LayerListenerType.ACTIVE_LAYER_CHANGE);
        if (bl) {
            enumSet.addAll(this.setEditLayer(this.layers));
        }
        return enumSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getActiveLayer() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.activeLayer;
        }
    }

    private void onActiveEditLayerChanged(Layer layer, OsmDataLayer osmDataLayer, EnumSet<LayerListenerType> enumSet) {
        if (enumSet.contains((Object)LayerListenerType.EDIT_LAYER_CHANGE)) {
            this.onEditLayerChanged(osmDataLayer);
        }
        if (enumSet.contains((Object)LayerListenerType.ACTIVE_LAYER_CHANGE)) {
            this.onActiveLayerChanged(layer);
        }
    }

    private void onActiveLayerChanged(Layer layer) {
        this.fireActiveLayerChanged(layer, this.activeLayer);
        for (final AbstractButton abstractButton : Main.map.allMapModeButtons) {
            MapMode mapMode = (MapMode)abstractButton.getAction();
            final boolean bl = mapMode.layerIsSupported(this.activeLayer);
            if (bl) {
                Main.registerActionShortcut(mapMode, mapMode.getShortcut());
            } else {
                Main.unregisterShortcut(mapMode.getShortcut());
            }
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    abstractButton.setEnabled(bl);
                }
            });
        }
        AudioPlayer.reset();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsmDataLayer getEditLayer() {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.editLayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLayer(Layer layer) {
        List<Layer> list = this.layers;
        synchronized (list) {
            return this.layers.contains(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return this.temporaryLayers.add(mapViewPaintable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return this.temporaryLayers.remove(mapViewPaintable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MapViewPaintable> getTemporaryLayers() {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<MapViewPaintable>(this.temporaryLayers));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OsmDataLayer osmDataLayer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if (propertyChangeEvent.getPropertyName().equals(Layer.OPACITY_PROP) || propertyChangeEvent.getPropertyName().equals(Layer.FILTER_STATE_PROP)) {
            Layer layer = (Layer)propertyChangeEvent.getSource();
            if (layer.isVisible()) {
                this.changedLayer = layer;
                this.repaint();
            }
        } else if ((propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (osmDataLayer = (OsmDataLayer)propertyChangeEvent.getSource()) == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshTitle() {
        if (Main.parent != null) {
            List<Layer> list = this.layers;
            synchronized (list) {
                boolean bl = this.editLayer != null && (this.editLayer.requiresSaveToFile() || this.editLayer.requiresUploadToServer() && !this.editLayer.isUploadDiscouraged());
                ((JFrame)Main.parent).setTitle((bl ? "* " : "") + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
                ((JFrame)Main.parent).getRootPane().putClientProperty("Window.documentModified", bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        MapView mapView = this;
        synchronized (mapView) {
            this.paintPreferencesChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Main.pref.removePreferenceChangeListener(this);
        DataSet.removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear(this);
        if (this.mapMover != null) {
            this.mapMover.destroy();
        }
        Collection<MapViewPaintable> collection = this.layers;
        synchronized (collection) {
            this.activeLayer = null;
            this.changedLayer = null;
            this.editLayer = null;
            this.layers.clear();
            this.nonChangedLayers.clear();
        }
        collection = this.temporaryLayers;
        synchronized (collection) {
            this.temporaryLayers.clear();
        }
    }

    @Override
    public void uploadDiscouragedChanged(OsmDataLayer osmDataLayer, boolean bl) {
        if (osmDataLayer == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    public String getLayerInformationForSourceTag() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.getLayersOfType(GpxLayer.class).isEmpty()) {
            arrayList.add("survey");
        }
        for (GeoImageLayer layer : this.getLayersOfType(GeoImageLayer.class)) {
            arrayList.add(layer.getName());
        }
        for (ImageryLayer imageryLayer : this.getLayersOfType(ImageryLayer.class)) {
            arrayList.add(ImageryInfo.ImageryType.BING.equals((Object)imageryLayer.getInfo().getImageryType()) ? "Bing" : imageryLayer.getName());
        }
        return Utils.join("; ", arrayList);
    }

    public void addRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.add(repaintListener);
    }

    public void removeRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.remove(repaintListener);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.repaintListeners != null) {
            for (RepaintListener repaintListener : this.repaintListeners) {
                repaintListener.repaint(l, n, n2, n3, n4);
            }
        }
        super.repaint(l, n, n2, n3, n4);
    }

    public static interface RepaintListener {
        public void repaint(long var1, int var3, int var4, int var5, int var6);
    }

    private static enum LayerListenerType {
        ACTIVE_LAYER_CHANGE,
        EDIT_LAYER_CHANGE;

    }

    public static interface EditLayerChangeListener {
        public void editLayerChanged(OsmDataLayer var1, OsmDataLayer var2);
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

