/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class GeoJSONWriter {
    private final OsmDataLayer layer;
    private final Projection projection;
    private static final boolean skipEmptyNodes = true;

    public GeoJSONWriter(OsmDataLayer osmDataLayer, Projection projection) {
        this.layer = osmDataLayer;
        this.projection = projection;
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean bl) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
        hashMap.put("javax.json.stream.JsonGenerator.prettyPrinting", bl);
        try (JsonWriter jsonWriter = Json.createWriterFactory(hashMap).createWriter(stringWriter);){
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("type", "FeatureCollection").add("crs", Json.createObjectBuilder().add("type", "name").add("name", this.projection.toCode())).add("generator", "JOSM");
            this.appendLayerBounds(this.layer.data, jsonObjectBuilder);
            this.appendLayerFeatures(this.layer.data, jsonObjectBuilder);
            jsonWriter.writeObject(jsonObjectBuilder.build());
            String string = stringWriter.toString();
            return string;
        }
    }

    private JsonArrayBuilder getCoorArray(JsonArrayBuilder jsonArrayBuilder, LatLon latLon) {
        return GeoJSONWriter.getCoorArray(jsonArrayBuilder, this.projection.latlon2eastNorth(latLon));
    }

    private static JsonArrayBuilder getCoorArray(JsonArrayBuilder jsonArrayBuilder, EastNorth eastNorth) {
        return jsonArrayBuilder.add(eastNorth.getX()).add(eastNorth.getY());
    }

    protected void appendPrimitive(OsmPrimitive osmPrimitive, JsonArrayBuilder jsonArrayBuilder) {
        if (osmPrimitive.isIncomplete()) {
            return;
        }
        if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
            jsonObjectBuilder.add(entry.getKey(), entry.getValue());
        }
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        osmPrimitive.accept(new GeometryPrimitiveVisitor(jsonObjectBuilder2));
        jsonArrayBuilder.add(Json.createObjectBuilder().add("type", "Feature").add("properties", jsonObjectBuilder).add("geometry", jsonObjectBuilder2));
    }

    protected void appendLayerBounds(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        Iterator<Bounds> iterator;
        if (dataSet != null && (iterator = dataSet.getDataSourceBounds().iterator()).hasNext()) {
            Bounds bounds = new Bounds(iterator.next());
            while (iterator.hasNext()) {
                bounds.extend(iterator.next());
            }
            this.appendBounds(bounds, jsonObjectBuilder);
        }
    }

    protected void appendBounds(Bounds bounds, JsonObjectBuilder jsonObjectBuilder) {
        if (bounds != null) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            this.getCoorArray(jsonArrayBuilder, bounds.getMin());
            this.getCoorArray(jsonArrayBuilder, bounds.getMax());
            jsonObjectBuilder.add("bbox", jsonArrayBuilder);
        }
    }

    protected void appendLayerFeatures(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (dataSet != null) {
            for (Node osmPrimitive : dataSet.getNodes()) {
                this.appendPrimitive(osmPrimitive, jsonArrayBuilder);
            }
            for (Way way : dataSet.getWays()) {
                this.appendPrimitive(way, jsonArrayBuilder);
            }
        }
        jsonObjectBuilder.add("features", jsonArrayBuilder);
    }

    private class GeometryPrimitiveVisitor
    implements PrimitiveVisitor {
        private final JsonObjectBuilder geomObj;

        GeometryPrimitiveVisitor(JsonObjectBuilder jsonObjectBuilder) {
            this.geomObj = jsonObjectBuilder;
        }

        @Override
        public void visit(INode iNode) {
            this.geomObj.add("type", "Point");
            LatLon latLon = iNode.getCoor();
            if (latLon != null) {
                this.geomObj.add("coordinates", GeoJSONWriter.this.getCoorArray(Json.createArrayBuilder(), iNode.getCoor()));
            }
        }

        @Override
        public void visit(IWay iWay) {
            this.geomObj.add("type", "LineString");
            if (iWay instanceof Way) {
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                for (Node node : ((Way)iWay).getNodes()) {
                    LatLon latLon = node.getCoor();
                    if (latLon == null) continue;
                    jsonArrayBuilder.add(GeoJSONWriter.this.getCoorArray(Json.createArrayBuilder(), latLon));
                }
                this.geomObj.add("coordinates", jsonArrayBuilder);
            }
        }

        @Override
        public void visit(IRelation iRelation) {
        }
    }
}

