/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("gpx", "gpx", I18n.tr("GPX Files", new Object[0]), true);

    public GpxImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String string = file.getName();
        try (InputStream inputStream = Compression.getUncompressedFileInputStream(file);){
            GpxReader gpxReader = new GpxReader(inputStream);
            boolean bl = gpxReader.parse(true);
            gpxReader.getGpxData().storageFile = file;
            GpxImporter.addLayers(GpxImporter.loadLayers(gpxReader.getGpxData(), bl, string, I18n.tr("Markers from {0}", string)));
        }
        catch (SAXException sAXException) {
            Main.error(sAXException);
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", string), sAXException);
        }
    }

    public static void addLayers(final GpxImporterData gpxImporterData) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (gpxImporterData.markerLayer != null) {
                    Main.main.addLayer(gpxImporterData.markerLayer);
                }
                if (gpxImporterData.gpxLayer != null) {
                    Main.main.addLayer(gpxImporterData.gpxLayer);
                }
                gpxImporterData.postLayerTask.run();
            }
        });
    }

    public static GpxImporterData loadLayers(final GpxData gpxData, final boolean bl, final String string, String string2) {
        GpxLayer gpxLayer = null;
        MarkerLayer markerLayer = null;
        if (gpxData.hasRoutePoints() || gpxData.hasTrackPoints()) {
            gpxLayer = new GpxLayer(gpxData, string, gpxData.storageFile != null);
        }
        if (Main.pref.getBoolean("marker.makeautomarkers", true) && !gpxData.waypoints.isEmpty()) {
            markerLayer = new MarkerLayer(gpxData, string2, gpxData.storageFile, gpxLayer);
            if (markerLayer.data.isEmpty()) {
                markerLayer = null;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!bl) {
                    String string2 = gpxData.storageFile == null ? I18n.tr("Error occurred while parsing gpx data for layer ''{0}''. Only a part of the file will be available.", string) : I18n.tr("Error occurred while parsing gpx file ''{0}''. Only a part of the file will be available.", gpxData.storageFile.getPath());
                    JOptionPane.showMessageDialog(null, string2);
                }
            }
        };
        return new GpxImporterData(gpxLayer, markerLayer, runnable);
    }

    public static GpxImporterData loadLayers(InputStream inputStream, File file, String string, String string2, ProgressMonitor progressMonitor) throws IOException {
        try {
            GpxReader gpxReader = new GpxReader(inputStream);
            boolean bl = gpxReader.parse(true);
            gpxReader.getGpxData().storageFile = file;
            return GpxImporter.loadLayers(gpxReader.getGpxData(), bl, string, string2);
        }
        catch (SAXException sAXException) {
            Main.error(sAXException);
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", string), sAXException);
        }
    }

    public static class GpxImporterData {
        private GpxLayer gpxLayer;
        private MarkerLayer markerLayer;
        private Runnable postLayerTask;

        public GpxImporterData(GpxLayer gpxLayer, MarkerLayer markerLayer, Runnable runnable) {
            this.gpxLayer = gpxLayer;
            this.markerLayer = markerLayer;
            this.postLayerTask = runnable;
        }

        public GpxLayer getGpxLayer() {
            return this.gpxLayer;
        }

        public MarkerLayer getMarkerLayer() {
            return this.markerLayer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

