/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.Utils;

public abstract class Plugin
implements MapFrameListener {
    private PluginInformation info;

    public Plugin(PluginInformation pluginInformation) {
        this.info = pluginInformation;
    }

    public PluginInformation getPluginInformation() {
        return this.info;
    }

    public void setPluginInformation(PluginInformation pluginInformation) {
        this.info = pluginInformation;
    }

    public String getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), this.info.name).getPath();
    }

    @Override
    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return null;
    }

    public void addDownloadSelection(List<DownloadSelection> list) {
    }

    public void copy(String string, String string2) throws IOException {
        String string3 = this.getPluginDir();
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(string3, string2));
             InputStream inputStream = this.getClass().getResourceAsStream(string);){
            if (inputStream == null) {
                throw new IOException("Resource not found: " + string);
            }
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            while (n > 0) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
    }

    public ClassLoader getPluginResourceClassLoader() {
        File file = Main.pref.getPluginsDirectory();
        File file2 = new File(file, this.info.name + ".jar");
        final URL uRL = Utils.fileToURL(file2);
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(new URL[]{uRL}, Main.class.getClassLoader());
            }
        });
    }
}

