/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.messages;

import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.MessageUtil;
import com.oracle.truffle.interop.messages.Receiver;

public final class Read
implements Message {
    private final Object receiver;
    private final Argument id;

    private Read(Object receiver, Argument id) {
        this.receiver = receiver;
        this.id = id;
    }

    public static Read create(Receiver receiver, Argument id) {
        return new Read(receiver, id);
    }

    public static Read create(Message receiver, Argument id) {
        return new Read(receiver, id);
    }

    public Argument getId() {
        return this.id;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean matchStructure(Object message) {
        if (!(message instanceof Read)) {
            return false;
        }
        Read m1 = this;
        Read m2 = (Read)message;
        return MessageUtil.compareMessage(m1.getReceiver(), m2.getReceiver());
    }

    public String toString() {
        return String.format("Read(%s, %s)", this.receiver.toString(), this.id.toString());
    }
}

