/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.node;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropPredicate;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.interop.ForeignAccessArguments;
import com.oracle.truffle.interop.node.ObjectAccessNode;

class CachedObjectAccessNode
extends ObjectAccessNode {
    @Node.Child
    private DirectCallNode callTarget;
    @Node.Child
    private ObjectAccessNode next;
    private final InteropPredicate languageCheck;

    protected CachedObjectAccessNode(DirectCallNode callTarget, ObjectAccessNode next, InteropPredicate languageCheck) {
        this.callTarget = callTarget;
        this.next = next;
        this.languageCheck = languageCheck;
        this.callTarget.forceInlining();
    }

    protected CachedObjectAccessNode(CachedObjectAccessNode prev) {
        this(prev.callTarget, prev.next, prev.languageCheck);
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        return this.doAccess(frame, receiver, arguments);
    }

    private Object doAccess(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        if (this.languageCheck.test(receiver)) {
            return this.callTarget.call(frame, ForeignAccessArguments.create(receiver, arguments));
        }
        return this.doNext(frame, receiver, arguments);
    }

    private Object doNext(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        return this.next.executeWith(frame, receiver, arguments);
    }
}

