/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import org.jruby.truffle.format.runtime.exceptions.FormatException;

public class PackTokenizer {
    private static final String SIMPLE_TOKENS = "CSLIQcsliqnNvVAaZUXx*<>!_@DdFfEeGgPpHhMmuwBb";
    private final String format;
    private final boolean extended;
    private int position;
    private Object peek;

    public PackTokenizer(String format, boolean extended) {
        this.format = format;
        this.extended = extended;
    }

    public boolean peek(char c) {
        Object peek = this.peek();
        if (peek == null) {
            return false;
        }
        return peek.equals(Character.valueOf(c));
    }

    public Object peek() {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    public Object next() {
        if (this.peek != null) {
            Object token = this.peek;
            this.peek = null;
            return token;
        }
        this.consumeWhitespace();
        if (this.position >= this.format.length()) {
            return null;
        }
        char c = this.format.charAt(this.position);
        if (c == '%') {
            throw new FormatException("% is not supported");
        }
        String chars = this.extended ? "CSLIQcsliqnNvVAaZUXx*<>!_@DdFfEeGgPpHhMmuwBb()" : SIMPLE_TOKENS;
        if (chars.indexOf(c) > -1) {
            ++this.position;
            return Character.valueOf(c);
        }
        if (Character.isDigit(c)) {
            int start = this.position++;
            while (this.position < this.format.length() && Character.isDigit(this.format.charAt(this.position))) {
                ++this.position;
            }
            return Integer.parseInt(this.format.substring(start, this.position));
        }
        throw new UnsupportedOperationException(String.format("unexpected token %c", Character.valueOf(c)));
    }

    private void consumeWhitespace() {
        while (this.position < this.format.length()) {
            char c = this.format.charAt(this.position);
            if (c == '#') {
                ++this.position;
                while (this.position < this.format.length() && (c = this.format.charAt(this.position)) != '\r' && c != '\n') {
                    ++this.position;
                }
            } else if (!Character.isWhitespace(c) && c != '\u0000') break;
            ++this.position;
        }
    }
}

