/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;

public class LoadRequiredLibrariesNode
extends RubyNode {
    @Node.Child
    CallDispatchHeadNode requireNode;

    public LoadRequiredLibrariesNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.requireNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        for (String requiredLibrary : this.getRequiredLibraries()) {
            this.requireNode.call(frame, self, "require", null, this.createString(StringOperations.encodeByteList(requiredLibrary, (Encoding)UTF8Encoding.INSTANCE)));
        }
        return this.nil();
    }

    @CompilerDirectives.TruffleBoundary
    private Collection<String> getRequiredLibraries() {
        return this.getContext().getRuntime().getInstanceConfig().getRequiredLibraries();
    }
}

