/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class HashGuards {
    public static boolean isNullHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getStore(hash) == null;
    }

    public static boolean isPackedHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return !HashGuards.isNullHash(hash) && !HashGuards.isBucketHash(hash);
    }

    public static boolean isBucketHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getStore(hash) instanceof Entry[];
    }

    public static boolean isEmptyHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getSize(hash) == 0;
    }

    public static boolean isCompareByIdentity(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getCompareByIdentity(hash);
    }

    public static boolean hasDefaultValue(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getDefaultValue(hash) != null;
    }

    public static boolean hasDefaultBlock(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getDefaultBlock(hash) != null;
    }
}

