/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.RetryException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class TryNode
extends RubyNode {
    @Node.Child
    private ExceptionTranslatingNode tryPart;
    @Node.Children
    final RescueNode[] rescueParts;
    @Node.Child
    private RubyNode elsePart;
    private final BranchProfile elseProfile = BranchProfile.create();
    private final BranchProfile controlFlowProfile = BranchProfile.create();
    private final BranchProfile raiseExceptionProfile = BranchProfile.create();

    public TryNode(RubyContext context, SourceSection sourceSection, ExceptionTranslatingNode tryPart, RescueNode[] rescueParts, RubyNode elsePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.rescueParts = rescueParts;
        this.elsePart = elsePart;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        while (true) {
            try {
                result = this.tryPart.execute(frame);
            }
            catch (ControlFlowException exception) {
                this.controlFlowProfile.enter();
                throw exception;
            }
            catch (RaiseException exception) {
                this.raiseExceptionProfile.enter();
                try {
                    return this.handleException(frame, exception);
                }
                catch (RetryException e) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
            }
            break;
        }
        this.elseProfile.enter();
        if (this.elsePart != null) {
            result = this.elsePart.execute(frame);
        }
        return result;
    }

    private Object handleException(VirtualFrame frame, RaiseException exception) {
        CompilerDirectives.transferToInterpreter();
        for (RescueNode rescue : this.rescueParts) {
            if (!rescue.canHandle(frame, exception.getRubyException())) continue;
            return this.setLastExceptionAndRunRescue(frame, exception, rescue);
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setLastExceptionAndRunRescue(VirtualFrame frame, RaiseException exception, RescueNode rescue) {
        DynamicObject threadLocals = Layouts.THREAD.getThreadLocals(this.getContext().getThreadManager().getCurrentThread());
        Object lastException = threadLocals.get("$!", this.nil());
        threadLocals.set("$!", exception.getRubyException());
        try {
            Object object = rescue.execute(frame);
            return object;
        }
        finally {
            threadLocals.set("$!", lastException);
        }
    }
}

