/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ArrayForeignAccessFactory;
import org.jruby.truffle.runtime.core.BasicForeignAccessFactory;
import org.jruby.truffle.runtime.core.HashForeignAccessFactory;
import org.jruby.truffle.runtime.core.StringForeignAccessFactory;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public class RubyObjectType
extends ObjectType {
    @Override
    public String toString(DynamicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        RubyContext context = this.getContext();
        if (RubyGuards.isRubyString(object)) {
            return Helpers.decodeByteList((Ruby)context.getRuntime(), (ByteList)StringOperations.getByteList(object));
        }
        if (RubyGuards.isRubySymbol(object)) {
            return Layouts.SYMBOL.getString(object);
        }
        if (RubyGuards.isRubyException(object)) {
            return Layouts.EXCEPTION.getMessage(object).toString();
        }
        if (RubyGuards.isRubyModule(object)) {
            return Layouts.MODULE.getFields(object).toString();
        }
        return String.format("DynamicObject@%x<logicalClass=%s>", System.identityHashCode(object), Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(object)).getName());
    }

    @Override
    public ForeignAccessFactory getForeignAccessFactory() {
        RubyContext context = this.getContext();
        if (Layouts.ARRAY.isArray(this)) {
            return new ArrayForeignAccessFactory(context);
        }
        if (Layouts.HASH.isHash(this)) {
            return new HashForeignAccessFactory(context);
        }
        if (Layouts.STRING.isString(this)) {
            return new StringForeignAccessFactory(context);
        }
        return new BasicForeignAccessFactory(context);
    }

    private RubyContext getContext() {
        return Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(this)).getContext();
    }
}

