/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.ArrayLayout;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;

public class ArrayLayoutImpl
extends BasicObjectLayoutImpl
implements ArrayLayout {
    public static final ArrayLayout INSTANCE = new ArrayLayoutImpl();
    protected static final Shape.Allocator ARRAY_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey STORE_IDENTIFIER = new HiddenKey("store");
    protected static final Property STORE_PROPERTY = Property.create(STORE_IDENTIFIER, ARRAY_ALLOCATOR.locationForType(Object.class), 0);
    protected static final HiddenKey SIZE_IDENTIFIER = new HiddenKey("size");
    protected static final Property SIZE_PROPERTY = Property.create(SIZE_IDENTIFIER, ARRAY_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected ArrayLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createArrayShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ArrayType(logicalClass, metaClass)).addProperty(STORE_PROPERTY).addProperty(SIZE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createArray(DynamicObjectFactory factory, Object store, int size) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsArray(factory));
        assert (factory.getShape().hasProperty(STORE_IDENTIFIER));
        assert (factory.getShape().hasProperty(SIZE_IDENTIFIER));
        return factory.newInstance(store, size);
    }

    @Override
    public boolean isArray(Object object) {
        return object instanceof DynamicObject && this.isArray((DynamicObject)object);
    }

    @Override
    public boolean isArray(DynamicObject object) {
        return this.isArray(object.getShape().getObjectType());
    }

    @Override
    public boolean isArray(ObjectType objectType) {
        return objectType instanceof ArrayType;
    }

    private boolean createsArray(DynamicObjectFactory factory) {
        return this.isArray(factory.getShape().getObjectType());
    }

    @Override
    public Object getStore(DynamicObject object) {
        assert (this.isArray(object));
        assert (object.getShape().hasProperty(STORE_IDENTIFIER));
        return STORE_PROPERTY.get(object, true);
    }

    @Override
    public void setStore(DynamicObject object, Object value) {
        assert (this.isArray(object));
        assert (object.getShape().hasProperty(STORE_IDENTIFIER));
        try {
            STORE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getSize(DynamicObject object) {
        assert (this.isArray(object));
        assert (object.getShape().hasProperty(SIZE_IDENTIFIER));
        return (Integer)SIZE_PROPERTY.get(object, true);
    }

    @Override
    public void setSize(DynamicObject object, int value) {
        assert (this.isArray(object));
        assert (object.getShape().hasProperty(SIZE_IDENTIFIER));
        try {
            SIZE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class ArrayType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ArrayType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ArrayType setLogicalClass(DynamicObject logicalClass) {
            return new ArrayType(logicalClass, this.metaClass);
        }

        @Override
        public ArrayType setMetaClass(DynamicObject metaClass) {
            return new ArrayType(this.logicalClass, metaClass);
        }
    }
}

