/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.methods;

import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.methods.Arity;

public class SharedMethodInfo {
    private final SourceSection sourceSection;
    private final LexicalScope lexicalScope;
    private final Arity arity;
    private final String name;
    private final boolean isBlock;
    private final ArgumentDescriptor[] argumentDescriptors;
    private final boolean alwaysClone;
    private final boolean alwaysInline;
    private final boolean needsCallerFrame;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope lexicalScope, Arity arity, String name, boolean isBlock, ArgumentDescriptor[] argumentDescriptors, boolean alwaysClone, boolean alwaysInline, boolean needsCallerFrame) {
        assert (sourceSection != null);
        assert (name != null);
        this.sourceSection = sourceSection;
        this.lexicalScope = lexicalScope;
        this.arity = arity;
        this.name = name;
        this.isBlock = isBlock;
        this.argumentDescriptors = argumentDescriptors;
        this.alwaysClone = alwaysClone;
        this.alwaysInline = alwaysInline;
        this.needsCallerFrame = needsCallerFrame;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public Arity getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return Arrays.copyOf(this.argumentDescriptors, this.argumentDescriptors.length);
    }

    public boolean shouldAlwaysClone() {
        return this.alwaysClone;
    }

    public boolean shouldAlwaysInline() {
        return this.alwaysInline;
    }

    public boolean needsCallerFrame() {
        return this.needsCallerFrame;
    }

    public SharedMethodInfo withName(String newName) {
        return new SharedMethodInfo(this.sourceSection, this.lexicalScope, this.arity, newName, this.isBlock, this.argumentDescriptors, this.alwaysClone, this.alwaysInline, this.needsCallerFrame);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isBlock) {
            builder.append("block in ");
        }
        builder.append(this.name);
        builder.append(":");
        builder.append(this.sourceSection.getShortDescription());
        return builder.toString();
    }
}

