/*
 * %kadu copyright begin%
 * Copyright 2009, 2010, 2011 Piotr Galiszewski (piotr.galiszewski@kadu.im)
 * Copyright 2012 Wojciech Treter (juzefwt@gmail.com)
 * Copyright 2011 Piotr Dąbrowski (ultr@ultr.pl)
 * Copyright 2009, 2010, 2011, 2013 Rafał Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * Copyright 2010 Bartosz Brachaczek (b.brachaczek@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WINDOW_NOTIFIER_WINDOW_H
#define WINDOW_NOTIFIER_WINDOW_H

#include <QtWidgets/QDialog>

#include "os/generic/desktop-aware-object.h"

class Notification;

class WindowNotifierWindow : public QDialog, DesktopAwareObject
{
	Q_OBJECT

	Notification *CurrentNotification;

	void createGui();
	void addButton(Notification *notification, QWidget *parent, const QString &caption, const char *slot);

public:
	explicit WindowNotifierWindow(Notification *notification, QWidget *parent = 0);
	virtual ~WindowNotifierWindow();

signals:
	void closed(Notification *notification);

};

#endif // WINDOW_NOTIFIER_WINDOW_H
