// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, GE, IS, PackageJson, QuarantinedKeyRing, SigChain, TmpKeyRing, TrackWrapper, TrackerProofGen, UntrackerProofGen, User, akatch, athrow, chain_err, colors, constants, db, deepeq, env, filter, fpeq, iced, kbpgp, libkeybase, load_key, log, make_esc, master_ring, merkle_client, req, session, tor, unix_time, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3, _ref4, _ref5;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  req = require('./req');

  db = require('./db');

  constants = require('./constants').constants;

  _ref = require('iced-error'), chain_err = _ref.chain_err, make_esc = _ref.make_esc;

  _ref1 = require('./err'), GE = _ref1.GE, E = _ref1.E;

  deepeq = require('deep-equal');

  SigChain = require('./sigchain').SigChain;

  log = require('./log');

  _ref2 = require('./sigs'), UntrackerProofGen = _ref2.UntrackerProofGen, TrackerProofGen = _ref2.TrackerProofGen;

  session = require('./session').session;

  env = require('./env').env;

  TrackWrapper = require('./trackwrapper').TrackWrapper;

  _ref3 = require('pgp-utils').util, fpeq = _ref3.fpeq, unix_time = _ref3.unix_time;

  _ref4 = require('./keyring'), QuarantinedKeyRing = _ref4.QuarantinedKeyRing, TmpKeyRing = _ref4.TmpKeyRing, load_key = _ref4.load_key, master_ring = _ref4.master_ring;

  _ref5 = require('iced-utils').util, athrow = _ref5.athrow, akatch = _ref5.akatch;

  IS = constants.import_state;

  PackageJson = require('./package').PackageJson;

  libkeybase = require('libkeybase');

  tor = require('./tor');

  colors = require('./colors');

  kbpgp = require('kbpgp');

  merkle_client = require('./merkle_client').merkle_client;

  filter = function(d, v) {
    var k, out, _i, _len;
    out = {};
    for (_i = 0, _len = v.length; _i < _len; _i++) {
      k = v[_i];
      if (d != null) {
        out[k] = d[k];
      }
    }
    return out;
  };

  exports.User = User = (function() {
    User.cache = {};

    User.server_cache = {};

    User.FIELDS = ["basics", "public_keys", "id", "merkle_data", "private_keys", "logged_in"];

    function User(args) {
      var k, _i, _len, _ref6;
      _ref6 = User.FIELDS;
      for (_i = 0, _len = _ref6.length; _i < _len; _i++) {
        k = _ref6[_i];
        this[k] = args[k];
      }
      this._dirty = false;
      this.sig_chain = null;
      this._is_self = false;
      this._have_secret_key = false;
      this.sibkeys = [];
      this.gpg_keys = [];
    }

    User.prototype.set_logged_in = function() {
      return this.logged_in = session.logged_in();
    };

    User.prototype.set_is_self = function(b) {
      return this._is_self = b;
    };

    User.prototype.is_self = function() {
      return this._is_self;
    };

    User.prototype.set_have_secret_key = function(b) {
      return this._have_secret_key = b;
    };

    User.prototype.have_secret_key = function() {
      return this._have_secret_key;
    };

    User.prototype.to_obj = function() {
      var k, out, _i, _len, _ref6;
      out = {};
      _ref6 = User.FIELDS;
      for (_i = 0, _len = _ref6.length; _i < _len; _i++) {
        k = _ref6[_i];
        out[k] = this[k];
      }
      return out;
    };

    User.prototype.private_key_bundle = function() {
      var _ref6, _ref7;
      return (_ref6 = this.private_keys) != null ? (_ref7 = _ref6.primary) != null ? _ref7.bundle : void 0 : void 0;
    };

    User.prototype.names = function() {
      var fp, ki64, ret;
      ret = [
        {
          type: constants.lookups.username,
          name: this.basics.username
        }
      ];
      if ((ki64 = this.key_id_64()) != null) {
        ret.push({
          type: constants.lookups.key_id_64_to_user,
          name: ki64
        });
      }
      if ((fp = this.fingerprint(false)) != null) {
        ret.push({
          type: constants.lookups.key_fingerprint_to_user,
          name: fp
        });
      }
      return ret;
    };

    User.prototype.store = function(force_store, cb) {
      var err, un, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      un = this.username();
      (function(_this) {
        return (function(__iced_k) {
          if (force_store || _this._dirty) {
            log.debug("+ " + un + ": storing user to local DB");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.store"
              });
              db.put({
                key: _this.id,
                value: _this.to_obj(),
                names: _this.names()
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 94
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(log.debug("- " + un + ": stored user to local DB"));
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((_this.sig_chain != null) && (err == null)) {
              log.debug("+ " + un + ": storing signature chain");
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.store"
                });
                _this.sig_chain.store(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 98
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(log.debug("- " + un + ": stored signature chain"));
              });
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err);
          });
        };
      })(this));
    };

    User.prototype.update_fields = function(remote) {
      var k, _i, _len, _ref6;
      _ref6 = User.FIELDS;
      for (_i = 0, _len = _ref6.length; _i < _len; _i++) {
        k = _ref6[_i];
        this.update_field(remote, k);
      }
      return true;
    };

    User.prototype.update_field = function(remote, which) {
      if (!(deepeq(this[which], remote[which]))) {
        this[which] = remote[which];
        return this._dirty = true;
      }
    };

    User.prototype.load_sig_chain_from_storage = function(cb) {
      var err, ph, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      log.debug("+ load sig chain from local storage");
      (function(_this) {
        return (function(__iced_k) {
          var _ref6;
          if ((ph = (_ref6 = _this.merkle_data) != null ? _ref6.payload_hash : void 0) != null) {
            log.debug("| loading sig chain w/ payload hash " + ph);
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.load_sig_chain_from_storage"
              });
              SigChain.load(_this.id, _this.username(), ph, __iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    err = arguments[0];
                    return __slot_1.sig_chain = arguments[1];
                  };
                })(_this),
                lineno: 123
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            log.debug("| No payload hash tail pointer found");
            return __iced_k(_this.sig_chain = new SigChain(_this.id, _this.username()));
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- loaded sig chain from local storage");
          return cb(err);
        };
      })(this));
    };

    User.prototype.load_full_sig_chain = function(cb) {
      var err, sc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ load full sig chain");
      sc = new SigChain(this.id, this.username());
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.load_full_sig_chain"
          });
          sc.update(null, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 135
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this.sig_chain = sc;
          }
          log.debug("- loaded full sig chain");
          return cb(err);
        };
      })(this));
    };

    User.prototype.update_sig_chain = function(remote_seqno, cb) {
      var did_update, err, last, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ update sig chain; remote_seqno=" + remote_seqno);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.update_sig_chain"
          });
          _this.sig_chain.update(remote_seqno, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return did_update = arguments[1];
              };
            })(),
            lineno: 144
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (did_update) {
            last = _this.sig_chain.last().export_to_user();
            log.debug("| update sig_chain last link to " + (JSON.stringify(last)));
            _this._dirty = true;
          }
          log.debug("- updated sig chain");
          return cb(err);
        };
      })(this));
    };

    User.prototype.update_with = function(remote, cb) {
      var a, b, err, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref6, _ref7;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      log.debug("+ updating local user w/ remote");
      a = (_ref6 = this.basics) != null ? _ref6.id_version : void 0;
      b = remote != null ? (_ref7 = remote.basics) != null ? _ref7.id_version : void 0 : void 0;
      if ((b == null) || a > b) {
        err = new E.VersionRollbackError("Server version-rollback suspected: Local " + a + " > " + b);
      } else {
        this.update_fields(remote);
      }
      (function(_this) {
        return (function(__iced_k) {
          if (err == null) {
            (function(__iced_k) {
              var _ref8;
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.update_with"
              });
              _this.update_sig_chain((_ref8 = remote.merkle_data) != null ? _ref8.seqno : void 0, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 169
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- finished update");
          return cb(err);
        };
      })(this));
    };

    User.map_key_to_user_local = function(query, cb) {
      var b, err, k, ret, row, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ map_key_to_user_local " + (JSON.stringify(query)));
      err = ret = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.map_key_to_user_local"
          });
          db.lookup(query, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return row = arguments[1];
              };
            })(),
            lineno: 180
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          k = JSON.stringify(query);
          if (err != null) {

          } else if (typeof row === "undefined" || row === null) {
            err = new E.NotFoundError("Key not found for query " + k);
          } else {
            b = row.basics;
            ret = {
              uid: b.uid,
              username: b.username
            };
          }
          log.debug("- map_key_to_user_local -> " + err);
          return cb(err, ret);
        };
      })(this));
    };

    User.map_key_to_user = function(query, cb) {
      var basics, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ map_key_to_user: " + (JSON.stringify(query)));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.map_key_to_user"
          });
          User.map_key_to_user_local(query, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return basics = arguments[1];
              };
            })(),
            lineno: 195
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (typeof err !== "undefined" && err !== null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.map_key_to_user"
                });
                User.map_key_to_user_remote(query, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      err = arguments[0];
                      return basics = arguments[1];
                    };
                  })(),
                  lineno: 196
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- mapped -> " + err);
            return cb(err, basics);
          });
        };
      })(this));
    };

    User.map_key_to_user_remote = function(query, cb) {
      var L, body, d, err, key, qs, req_args, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      qs = JSON.stringify(query);
      log.debug("+ " + qs + ": map to username");
      err = null;
      L = constants.lookups;
      body = null;
      key = (function() {
        switch (query.type) {
          case L.key_fingerprint_to_user:
            return 'fingerprint';
          case L.key_id_64_to_user:
            return 'pgp_key_id';
          default:
            err = new E.BadQueryError("Bad query type: " + query.type);
            return null;
        }
      })();
      (function(_this) {
        return (function(__iced_k) {
          if (err == null) {
            d = {};
            d[key] = query.name;
            req_args = {
              endpoint: "key/basics",
              args: d
            };
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.map_key_to_user_remote"
              });
              req.get(req_args, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return body = arguments[1];
                  };
                })(),
                lineno: 220
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- " + qs + ": map -> " + err);
          return cb(err, body);
        };
      })(this));
    };

    User.load = function(_arg, cb) {
      var cache, err, ki64, require_public_key, ret, secret, self, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, ki64 = _arg.ki64, require_public_key = _arg.require_public_key, cache = _arg.cache, self = _arg.self, secret = _arg.secret;
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if ((username != null) && ((ret = User.cache[username]) != null)) {
            return __iced_k(log.debug("| hit user cache for " + username));
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.load"
              });
              User._load2({
                username: username,
                ki64: ki64,
                require_public_key: require_public_key,
                cache: cache,
                self: self,
                secret: secret
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return ret = arguments[1];
                  };
                })(),
                lineno: 231
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    User._load2 = function(_arg, cb) {
      var cache, changed, err, esc, fetched_from_server, force_store, k, ki64, local, parsed_keys, remote, require_public_key, secret, self, user, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, ki64 = _arg.ki64, require_public_key = _arg.require_public_key, cache = _arg.cache, self = _arg.self, secret = _arg.secret;
      esc = make_esc(cb, "User::load");
      k = username != null ? username : "Key: " + ki64;
      log.debug("+ " + username + ": load user");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User._load2"
          });
          User.load_from_storage({
            username: username,
            ki64: ki64
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return local = arguments[0];
              };
            })(),
            lineno: 241
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref6;
          if (username == null) {
            username = typeof local !== "undefined" && local !== null ? (_ref6 = local.basics) != null ? _ref6.username : void 0 : void 0;
          }
          (function(__iced_k) {
            if (self && secret && !tor.strict()) {
              log.debug("| Checking session since we're loading User as self (and need secret key)");
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User._load2"
                });
                session.load_and_check(esc(__iced_deferrals.defer({
                  lineno: 248
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              if (self && tor.strict()) {
                return __iced_k(log.warn("Tor strict mode: " + (colors.bold('not')) + " syncing your profile with the server"));
              } else {
                fetched_from_server = true;
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/user.iced",
                    funcname: "User._load2"
                  });
                  User.load_from_server({
                    self: self,
                    secret: secret,
                    username: username,
                    local_user: local
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return remote = arguments[0];
                      };
                    })(),
                    lineno: 254
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              }
            })(function() {
              changed = true;
              force_store = false;
              (function(__iced_k) {
                if (typeof local !== "undefined" && local !== null) {
                  user = local;
                  (function(__iced_k) {
                    if (typeof remote !== "undefined" && remote !== null) {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/Users/max/src/keybase/node-client/src/user.iced",
                          funcname: "User._load2"
                        });
                        user.update_with(remote, esc(__iced_deferrals.defer({
                          lineno: 261
                        })));
                        __iced_deferrals._fulfill();
                      })(__iced_k);
                    } else {
                      return __iced_k();
                    }
                  })(__iced_k);
                } else {
                  (function(__iced_k) {
                    if (typeof remote !== "undefined" && remote !== null) {
                      user = remote;
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/Users/max/src/keybase/node-client/src/user.iced",
                          funcname: "User._load2"
                        });
                        user.load_full_sig_chain(esc(__iced_deferrals.defer({
                          lineno: 264
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        return __iced_k(force_store = true);
                      });
                    } else {
                      return __iced_k(tor.strict() ? err = new E.TorStrictError("Can't load your info from the server in strict Tor mode") : err = new E.NotFoundError("User " + username + " wasn't found"));
                    }
                  })(__iced_k);
                }
              })(function() {
                (function(__iced_k) {
                  if (typeof err !== "undefined" && err !== null) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/node-client/src/user.iced",
                        funcname: "User._load2"
                      });
                      athrow(err, esc(__iced_deferrals.defer({
                        lineno: 271
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k();
                  }
                })(function() {
                  (function(__iced_k) {
                    var _ref7;
                    if (require_public_key && (((_ref7 = user.merkle_data) != null ? _ref7.eldest_kid : void 0) == null)) {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/Users/max/src/keybase/node-client/src/user.iced",
                          funcname: "User._load2"
                        });
                        athrow(new Error("user doesn't have a public key"), esc(__iced_deferrals.defer({
                          lineno: 274
                        })));
                        __iced_deferrals._fulfill();
                      })(__iced_k);
                    } else {
                      return __iced_k();
                    }
                  })(function() {
                    (function(__iced_k) {
                      var _ref7;
                      if (((_ref7 = user.public_keys) != null ? _ref7.all_bundles : void 0) == null) {
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/Users/max/src/keybase/node-client/src/user.iced",
                            funcname: "User._load2"
                          });
                          athrow(new Error("User key bundles missing."), esc(__iced_deferrals.defer({
                            lineno: 277
                          })));
                          __iced_deferrals._fulfill();
                        })(__iced_k);
                      } else {
                        return __iced_k();
                      }
                    })(function() {
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/Users/max/src/keybase/node-client/src/user.iced",
                          funcname: "User._load2"
                        });
                        libkeybase.ParsedKeys.parse({
                          key_bundles: user.public_keys.all_bundles
                        }, esc(__iced_deferrals.defer({
                          assign_fn: (function() {
                            return function() {
                              return parsed_keys = arguments[0];
                            };
                          })(),
                          lineno: 278
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        log.debug("+ " + username + ": verifying signatures");
                        (function(__iced_k) {
                          __iced_deferrals = new iced.Deferrals(__iced_k, {
                            parent: ___iced_passed_deferral,
                            filename: "/Users/max/src/keybase/node-client/src/user.iced",
                            funcname: "User._load2"
                          });
                          user._verify({
                            parsed_keys: parsed_keys,
                            self: self
                          }, esc(__iced_deferrals.defer({
                            lineno: 284
                          })));
                          __iced_deferrals._fulfill();
                        })(function() {
                          log.debug("- " + username + ": verified signatures");
                          (function(__iced_k) {
                            if (fetched_from_server) {
                              (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                  parent: ___iced_passed_deferral,
                                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                                  funcname: "User._load2"
                                });
                                user.store(force_store, esc(__iced_deferrals.defer({
                                  lineno: 289
                                })));
                                __iced_deferrals._fulfill();
                              })(__iced_k);
                            } else {
                              return __iced_k();
                            }
                          })(function() {
                            log.debug("- " + username + ": loaded user");
                            if (cache && (typeof err === "undefined" || err === null) && (typeof user !== "undefined" && user !== null)) {
                              User.cache[username] = user;
                            }
                            return cb(err, user);
                          });
                        });
                      });
                    });
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    User.load_from_server = function(_arg, cb) {
      var args, body, esc, leaf, local_id_version, local_seqno, local_user, merkle_data, payload_hash, pub, ret, root, secret, self, seqno, server_id_version, server_seqno, sig_id, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      self = _arg.self, secret = _arg.secret, username = _arg.username, local_user = _arg.local_user;
      esc = make_esc(cb, "User::load_from_server");
      log.debug("+ " + username + ": load user from server");
      if ((ret = User.server_cache[username]) != null) {
        log.debug("| hit server cache");
        cb(null, ret);
        return;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.load_from_server"
          });
          merkle_client().find_and_verify({
            username: username
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                leaf = arguments[0];
                root = arguments[1];
                return server_id_version = arguments[2];
              };
            })(),
            lineno: 311
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref6, _ref7;
          local_id_version = local_user != null ? (_ref6 = local_user.basics) != null ? _ref6.id_version : void 0 : void 0;
          local_seqno = local_user != null ? (_ref7 = local_user.merkle_data) != null ? _ref7.seqno : void 0 : void 0;
          if (typeof leaf !== "undefined" && leaf !== null) {
            pub = leaf.get_public();
            server_seqno = pub != null ? pub.seqno : void 0;
            if (server_id_version === local_id_version && server_seqno === local_seqno && local_user._format_up_to_date({})) {
              log.debug("| id_version (" + local_id_version + ") and seqno (" + local_seqno + ") haven't changed.");
              cb(null, null);
              return;
            } else if (server_id_version < local_id_version) {
              cb(new Error("Server id version (" + server_id_version + ") rolled back from local (" + local_id_version + ")"));
              return;
            } else if (server_seqno < local_seqno) {
              cb(new Error("Server seqno (" + server_seqno + ") rolled back from local (" + local_seqno + ")"));
              return;
            }
            if (pub != null) {
              seqno = pub.seqno;
              sig_id = pub.sig_id + libkeybase.SIG_ID_SUFFIX;
              payload_hash = pub.payload_hash;
            }
            merkle_data = {
              seqno: seqno,
              sig_id: sig_id,
              payload_hash: payload_hash,
              eldest_kid: leaf.get_eldest_kid()
            };
          } else {
            merkle_data = null;
          }
          args = {
            endpoint: "user/lookup",
            args: {
              username: username
            },
            need_cookie: self && secret
          };
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/user.iced",
              funcname: "User.load_from_server"
            });
            req.get(args, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return body = arguments[0];
                };
              })(),
              lineno: 354
            })));
            __iced_deferrals._fulfill();
          })(function() {
            ret = new User(body.them);
            ret.set_logged_in();
            ret.merkle_data = merkle_data;
            User.server_cache[username] = ret;
            log.debug("- " + username + ": loaded user from server");
            return cb(null, ret);
          });
        };
      })(this));
    };

    User.prototype._format_up_to_date = function(_arg) {
      var _ref6;
      _arg;
      if (((_ref6 = this.public_keys) != null ? _ref6.all_bundles : void 0) == null) {
        return false;
      }
      return true;
    };

    User.load_from_storage = function(_arg, cb) {
      var err, ki64, name, ret, row, type, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, ki64 = _arg.ki64;
      name = username || ki64;
      log.debug("+ " + name + ": load user from local storage");
      type = username != null ? constants.lookups.username : constants.lookups.key_id_64_to_user;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.load_from_storage"
          });
          db.lookup({
            type: type,
            name: name
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return row = arguments[1];
              };
            })(),
            lineno: 380
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((typeof err === "undefined" || err === null) && (typeof row !== "undefined" && row !== null)) {
              ret = new User(row);
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.load_from_storage"
                });
                ret.load_sig_chain_from_storage(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 383
                }));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(typeof err !== "undefined" && err !== null ? ret = null : void 0);
              });
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- " + name + ": loaded user from local storage -> " + err + " / " + ret);
            return cb(err, ret);
          });
        };
      })(this));
    };

    User.prototype.fingerprint = function(upper_case) {
      var _ref6, _ref7;
      if (upper_case == null) {
        upper_case = false;
      }
      if (this._fingerprint == null) {
        this._fingerprint = {
          lc: (_ref6 = this.default_key()) != null ? _ref6.fingerprint().toString('hex') : void 0
        };
        this._fingerprint.uc = (_ref7 = this._fingerprint.lc) != null ? _ref7.toUpperCase() : void 0;
      }
      return this._fingerprint[upper_case ? 'uc' : 'lc'];
    };

    User.prototype.key_id_64 = function() {
      var fp;
      if ((fp = this.fingerprint(false)) != null) {
        return fp.slice(-16);
      } else {
        return null;
      }
    };

    User.resolve_user_name = function(_arg, cb) {
      var ass_out, body, err, esc, uri, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username;
      log.debug("+ resolving username " + username);
      esc = make_esc(cb, "resolve_user_name");
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.resolve_user_name"
          });
          akatch((function() {
            return libkeybase.assertion.URI.parse({
              s: username,
              strict: false
            });
          }), esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return uri = arguments[0];
              };
            })(),
            lineno: 415
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (!uri.is_keybase()) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.resolve_user_name"
                });
                req.get({
                  endpoint: "user/lookup",
                  args: uri.to_lookup_query()
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return body = arguments[0];
                    };
                  })(),
                  lineno: 417
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(body.them.length === 0 ? err = new E.NotFoundError("No user found for '" + username + "'") : body.them.length > 1 ? err = new E.AmbiguityError("Multiple results returned for '" + username + "'; expected only 1") : (username = body.them[0].basics.username, ass_out = uri));
              });
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- resolved to " + username);
            return cb(err, username, ass_out);
          });
        };
      })(this));
    };

    User.load_me = function(opts, cb) {
      var esc, me, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "User::load_me");
      log.debug("+ User::load_me");
      (function(_this) {
        return (function(__iced_k) {
          if ((username = env().get_username()) == null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.load_me"
              });
              athrow(new E.NoUsernameError("no username for current user; try `keybase login`"), esc(__iced_deferrals.defer({
                lineno: 448
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/user.iced",
              funcname: "User.load_me"
            });
            User.load({
              username: username,
              self: true,
              secret: opts.secret
            }, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return me = arguments[0];
                };
              })(),
              lineno: 449
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.load_me"
              });
              me._load_me_2(opts, esc(__iced_deferrals.defer({
                lineno: 450
              })));
              __iced_deferrals._fulfill();
            })(function() {
              log.debug("- User::load_me");
              return cb(null, me);
            });
          });
        };
      })(this));
    };

    User.prototype._load_me_2 = function(_arg, cb) {
      var do_install, err, esc, install_key, load_secret, maybe_secret, secret, un, verify_opts, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      secret = _arg.secret, maybe_secret = _arg.maybe_secret, install_key = _arg.install_key, verify_opts = _arg.verify_opts;
      esc = make_esc(cb, "User::_load_me_2");
      un = this.username();
      this.set_is_self(true);
      if (this.sibkeys.length === 0) {
        cb(null);
        return;
      }
      load_secret = secret || maybe_secret;
      (function(_this) {
        return (function(__iced_k) {
          if (load_secret) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User._load_me_2"
              });
              master_ring().make_secret_gpg_key_from_user({
                user: _this
              }, __iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    err = arguments[0];
                    return __slot_1.key = arguments[1];
                  };
                })(_this),
                lineno: 468
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            _this.key = _this.default_key();
            log.debug("+ " + un + ": checking public key");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User._load_me_2"
              });
              _this.key.find(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 473
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(log.debug("- " + un + ": checked public key"));
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((typeof err === "undefined" || err === null) && load_secret) {
              return __iced_k(_this.set_have_secret_key(true));
            } else {
              (function(__iced_k) {
                if ((typeof err !== "undefined" && err !== null) && (err instanceof E.NoLocalKeyError) && maybe_secret) {
                  _this.key = _this.default_key();
                  log.debug("+ " + un + ": checking public key");
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/user.iced",
                      funcname: "User._load_me_2"
                    });
                    _this.key.find(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 482
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(log.debug("- " + un + ": checked public key"));
                  });
                } else {
                  return __iced_k();
                }
              })(__iced_k);
            }
          })(function() {
            (function(__iced_k) {
              if ((typeof err !== "undefined" && err !== null) && (err instanceof E.NoLocalKeyError) && install_key) {
                return __iced_k(do_install = true);
              } else {
                (function(__iced_k) {
                  if (typeof err !== "undefined" && err !== null) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/node-client/src/user.iced",
                        funcname: "User._load_me_2"
                      });
                      athrow(err, esc(__iced_deferrals.defer({
                        lineno: 488
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k(do_install = false);
                  }
                })(__iced_k);
              }
            })(function() {
              (function(__iced_k) {
                if (do_install) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/user.iced",
                      funcname: "User._load_me_2"
                    });
                    _this.key.commit({}, esc(__iced_deferrals.defer({
                      lineno: 493
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(function() {
                return cb(null);
              });
            });
          });
        };
      })(this));
    };

    User.prototype.check_key = function(_arg, cb) {
      var err, key, ret, secret, store, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      secret = _arg.secret, store = _arg.store;
      ret = {};
      log.debug("+ " + (this.username()) + ": check public key");
      (function(_this) {
        return (function(__iced_k) {
          if (_this.fingerprint() != null) {
            ret.remote = !secret || (_this.private_key_bundle() != null);
            (function(__iced_k) {
              if (secret) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/user.iced",
                    funcname: "User.check_key"
                  });
                  master_ring().make_secret_gpg_key_from_user({
                    user: _this
                  }, __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        err = arguments[0];
                        return key = arguments[1];
                      };
                    })(),
                    lineno: 506
                  }));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                key = _this.default_key();
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/user.iced",
                    funcname: "User.check_key"
                  });
                  key.find(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return err = arguments[0];
                      };
                    })(),
                    lineno: 509
                  }));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              }
            })(function() {
              return __iced_k(typeof err === "undefined" || err === null ? (ret.local = true, store ? _this.key = key : void 0) : err instanceof E.NoLocalKeyError ? (err = null, ret.local = false) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- " + (_this.username()) + ": check_public_key: ret=" + (JSON.stringify(ret)) + "; err=" + err);
          return cb(err, ret);
        };
      })(this));
    };

    User.prototype.load_public_key = function(_arg, cb) {
      var err, query, signer, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      signer = _arg.signer;
      log.debug("+ load public key for " + (this.username()));
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this.key == null) {
            query = {
              username: _this.username(),
              fingerprint: _this.fingerprint()
            };
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/user.iced",
                funcname: "User.load_public_key"
              });
              load_key(query, __iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    err = arguments[0];
                    return __slot_1.key = arguments[1];
                  };
                })(_this),
                lineno: 527
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- load public key; found=" + (!!_this.key) + "; err=" + err);
          return cb(err, _this.key);
        };
      })(this));
    };

    User.prototype.username = function() {
      return this.basics.username;
    };

    User.prototype.import_public_keys = function(_arg, cb) {
      var esc, key, keyring, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      keyring = _arg.keyring;
      esc = make_esc(cb, "User::import_public_keys");
      log.debug("+ Import public keys from " + (keyring.to_string()));
      (function(_this) {
        return (function(__iced_k) {
          var _i, _len, _ref6, _results, _while;
          _ref6 = _this.gpg_keys;
          _len = _ref6.length;
          _i = 0;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                ++_i;
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(_i < _len)) {
              return _break();
            } else {
              key = _ref6[_i];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.import_public_keys"
                });
                key.save(esc(__iced_deferrals.defer({
                  lineno: 541
                })));
                __iced_deferrals._fulfill();
              })(_next);
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- Import public keys from " + (keyring.to_string()));
          return cb(null);
        };
      })(this));
    };

    User.prototype.display_cryptocurrency_addresses = function(opts, cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.display_cryptocurrency_addresses"
          });
          _this.sig_chain.display_cryptocurrency_addresses(opts, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 548
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    User.prototype.check_remote_proofs = function(opts, cb) {
      var err, n_proofs, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      opts.gpg_keys = this.gpg_keys;
      opts.username = this.username();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.check_remote_proofs"
          });
          _this.sig_chain.check_remote_proofs(opts, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                warnings = arguments[1];
                return n_proofs = arguments[2];
              };
            })(),
            lineno: 556
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, warnings, n_proofs);
        };
      })(this));
    };

    User.prototype._verify = function(_arg, cb) {
      var err, esc, opts, parsed_keys, self, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref6;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      opts = _arg.opts, parsed_keys = _arg.parsed_keys, self = _arg.self;
      esc = make_esc(cb, "User::verify");
      this.sibkeys = [];
      this.gpg_keys = [];
      if (((_ref6 = this.merkle_data) != null ? _ref6.eldest_kid : void 0) == null) {
        cb(null);
        return;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User._verify"
          });
          _this.sig_chain.verify_sig({
            opts: opts,
            key: _this.key,
            parsed_keys: parsed_keys,
            merkle_data: _this.merkle_data
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.sibkeys = arguments[1];
              };
            })(_this),
            lineno: 579
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            if (self && (err instanceof libkeybase.E.KeyOwnershipError)) {
              log.warn("You have not proven ownership of your key. Run `keybase push --update`.");
              _this.sibkeys = [parsed_keys.get_merged_pgp_key_manager(_this.merkle_data.eldest_kid)];
            } else {
              cb(err);
              return;
            }
          }
          _this.gpg_keys = master_ring().make_all_public_gpg_keys_from_user({
            user: _this
          });
          return cb(null);
        };
      })(this));
    };

    User.prototype.default_key = function() {
      return this.gpg_keys[0];
    };

    User.prototype.list_remote_proofs = function(opts) {
      var _ref6;
      return (_ref6 = this.sig_chain) != null ? _ref6.list_remote_proofs(opts) : void 0;
    };

    User.prototype.list_trackees = function() {
      var _ref6;
      return (_ref6 = this.sig_chain) != null ? _ref6.list_trackees() : void 0;
    };

    User.prototype.list_cryptocurrency_addresses = function() {
      var _ref6;
      return (_ref6 = this.sig_chain) != null ? _ref6.list_cryptocurrency_addresses() : void 0;
    };

    User.prototype.merkle_root = function() {
      var _ref6;
      return (_ref6 = this.sig_chain) != null ? _ref6.merkle_root_to_track_obj() : void 0;
    };

    User.prototype.gen_remote_proof_gen = function(_arg, cb) {
      var arg, err, klass, remote_name_normalized, ret, sig_id, supersede, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      klass = _arg.klass, remote_name_normalized = _arg.remote_name_normalized, sig_id = _arg.sig_id, supersede = _arg.supersede;
      arg = {
        remote_name_normalized: remote_name_normalized,
        sig_id: sig_id,
        supersede: supersede
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.gen_remote_proof_gen"
          });
          _this.gen_sig_base({
            klass: klass,
            arg: arg
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 613
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    User.prototype.gen_sig_base = function(_arg, cb) {
      var arg, err, klass, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      klass = _arg.klass, arg = _arg.arg;
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.gen_sig_base"
          });
          _this.load_public_key({}, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 620
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            arg.eldest_kid = _this.merkle_data.eldest_kid;
            arg.km = _this.key;
            arg.merkle_root = _this.merkle_root();
            arg.client = (new PackageJson()).track_obj();
            ret = new klass(arg);
          }
          return cb(err, ret);
        };
      })(this));
    };

    User.prototype.gen_track_proof_gen = function(_arg, cb) {
      var arg, err, klass, last_link, ret, track_obj, uid, untrack_obj, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref6;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      uid = _arg.uid, track_obj = _arg.track_obj, untrack_obj = _arg.untrack_obj;
      last_link = (_ref6 = this.sig_chain) != null ? _ref6.true_last() : void 0;
      klass = untrack_obj != null ? UntrackerProofGen : TrackerProofGen;
      arg = {
        seqno: (last_link != null ? last_link.seqno() + 1 : 1),
        prev: (last_link != null ? last_link.id : null),
        uid: uid
      };
      if (track_obj != null) {
        arg.track = track_obj;
      }
      if (untrack_obj != null) {
        arg.untrack = untrack_obj;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/user.iced",
            funcname: "User.gen_track_proof_gen"
          });
          _this.gen_sig_base({
            klass: klass,
            arg: arg
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 640
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    User.prototype.gen_track_obj = function() {
      var out, pkp, _ref6, _ref7, _ref8, _ref9;
      pkp = this.public_keys.primary;
      out = {
        basics: filter(this.basics, ["id_version", "last_id_change", "username"]),
        id: this.id,
        key: {
          kid: (_ref6 = this.merkle_data) != null ? _ref6.eldest_kid : void 0
        },
        seq_tail: (_ref7 = this.sig_chain) != null ? (_ref8 = _ref7.true_last()) != null ? _ref8.to_track_obj() : void 0 : void 0,
        remote_proofs: (_ref9 = this.sig_chain) != null ? _ref9.remote_proofs_to_track_obj() : void 0,
        ctime: unix_time()
      };
      return out;
    };

    User.prototype.remove_key = function(cb) {
      var esc, key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "User::remove_key");
      (function(_this) {
        return (function(__iced_k) {
          var _i, _len, _ref6, _results, _while;
          _ref6 = _this.gpg_keys;
          _len = _ref6.length;
          _i = 0;
          _results = [];
          _while = function(__iced_k) {
            var _break, _continue, _next;
            _break = function() {
              return __iced_k(_results);
            };
            _continue = function() {
              return iced.trampoline(function() {
                ++_i;
                return _while(__iced_k);
              });
            };
            _next = function(__iced_next_arg) {
              _results.push(__iced_next_arg);
              return _continue();
            };
            if (!(_i < _len)) {
              return _break();
            } else {
              key = _ref6[_i];
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/user.iced",
                  funcname: "User.remove_key"
                });
                key.remove(esc(__iced_deferrals.defer({
                  lineno: 663
                })));
                __iced_deferrals._fulfill();
              })(_next);
            }
          };
          _while(__iced_k);
        });
      })(this)((function(_this) {
        return function() {
          return cb(null);
        };
      })(this));
    };

    User.prototype.gen_untrack_obj = function() {
      var out, pkp;
      pkp = this.public_keys.primary;
      out = {
        basics: filter(this.basics, ["id_version", "last_id_change", "username"]),
        id: this.id,
        key: filter(pkp, ["kid", "key_fingerprint"])
      };
      return out;
    };

    return User;

  })();

}).call(this);
