/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.tools.StringTools;

public class StringToolsTest
extends TestCase {
    public void testAssureSet() {
        try {
            StringTools.assureSet((String)"", (String)"varName");
            StringToolsTest.fail();
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        try {
            StringTools.assureSet((String)" \t", (String)"varName");
            StringToolsTest.fail();
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        try {
            StringTools.assureSet(null, (String)"varName");
            StringToolsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StringTools.assureSet((String)"foo", (String)"varName");
    }

    public void testReadStream() throws IOException {
        String content = StringTools.readStream((InputStream)new FileInputStream("src/test/resources/testinput.txt"), (String)"utf-8");
        StringToolsTest.assertEquals((String)"one\ntwo\n\u00f6\u00e4\u00fc\u00df\n\u0219\u021b\u00ee\u00e2\u0103\u0218\u021a\u00ce\u00c2\u0102\n", (String)content);
    }

    public void testIsAllUppercase() {
        StringToolsTest.assertTrue((boolean)StringTools.isAllUppercase((String)"A"));
        StringToolsTest.assertTrue((boolean)StringTools.isAllUppercase((String)"ABC"));
        StringToolsTest.assertTrue((boolean)StringTools.isAllUppercase((String)"ASV-EDR"));
        StringToolsTest.assertTrue((boolean)StringTools.isAllUppercase((String)"ASV-\u00d6\u00c4\u00dc"));
        StringToolsTest.assertTrue((boolean)StringTools.isAllUppercase((String)""));
        StringToolsTest.assertFalse((boolean)StringTools.isAllUppercase((String)"\u00df"));
        StringToolsTest.assertFalse((boolean)StringTools.isAllUppercase((String)"AAAAAAAAAAAAq"));
        StringToolsTest.assertFalse((boolean)StringTools.isAllUppercase((String)"a"));
        StringToolsTest.assertFalse((boolean)StringTools.isAllUppercase((String)"abc"));
    }

    public void testIsMixedCase() {
        StringToolsTest.assertTrue((boolean)StringTools.isMixedCase((String)"AbC"));
        StringToolsTest.assertTrue((boolean)StringTools.isMixedCase((String)"MixedCase"));
        StringToolsTest.assertTrue((boolean)StringTools.isMixedCase((String)"iPod"));
        StringToolsTest.assertTrue((boolean)StringTools.isMixedCase((String)"AbCdE"));
        StringToolsTest.assertFalse((boolean)StringTools.isMixedCase((String)""));
        StringToolsTest.assertFalse((boolean)StringTools.isMixedCase((String)"ABC"));
        StringToolsTest.assertFalse((boolean)StringTools.isMixedCase((String)"abc"));
        StringToolsTest.assertFalse((boolean)StringTools.isMixedCase((String)"!"));
        StringToolsTest.assertFalse((boolean)StringTools.isMixedCase((String)"Word"));
    }

    public void testIsCapitalizedWord() {
        StringToolsTest.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Abc"));
        StringToolsTest.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Uppercase"));
        StringToolsTest.assertTrue((boolean)StringTools.isCapitalizedWord((String)"Ipod"));
        StringToolsTest.assertFalse((boolean)StringTools.isCapitalizedWord((String)""));
        StringToolsTest.assertFalse((boolean)StringTools.isCapitalizedWord((String)"ABC"));
        StringToolsTest.assertFalse((boolean)StringTools.isCapitalizedWord((String)"abc"));
        StringToolsTest.assertFalse((boolean)StringTools.isCapitalizedWord((String)"!"));
        StringToolsTest.assertFalse((boolean)StringTools.isCapitalizedWord((String)"wOrD"));
    }

    public void testStartsWithUppercase() {
        StringToolsTest.assertTrue((boolean)StringTools.startsWithUppercase((String)"A"));
        StringToolsTest.assertTrue((boolean)StringTools.startsWithUppercase((String)"\u00c4\u00d6"));
        StringToolsTest.assertFalse((boolean)StringTools.startsWithUppercase((String)""));
        StringToolsTest.assertFalse((boolean)StringTools.startsWithUppercase((String)"\u00df"));
        StringToolsTest.assertFalse((boolean)StringTools.startsWithUppercase((String)"-"));
    }

    public void testUppercaseFirstChar() {
        StringToolsTest.assertEquals(null, (String)StringTools.uppercaseFirstChar(null));
        StringToolsTest.assertEquals((String)"", (String)StringTools.uppercaseFirstChar((String)""));
        StringToolsTest.assertEquals((String)"A", (String)StringTools.uppercaseFirstChar((String)"A"));
        StringToolsTest.assertEquals((String)"\u00d6\u00e4\u00fc", (String)StringTools.uppercaseFirstChar((String)"\u00f6\u00e4\u00fc"));
        StringToolsTest.assertEquals((String)"\u00dfa", (String)StringTools.uppercaseFirstChar((String)"\u00dfa"));
        StringToolsTest.assertEquals((String)"'Test'", (String)StringTools.uppercaseFirstChar((String)"'test'"));
        StringToolsTest.assertEquals((String)"''Test", (String)StringTools.uppercaseFirstChar((String)"''test"));
        StringToolsTest.assertEquals((String)"''T", (String)StringTools.uppercaseFirstChar((String)"''t"));
        StringToolsTest.assertEquals((String)"'''", (String)StringTools.uppercaseFirstChar((String)"'''"));
    }

    public void testLowercaseFirstChar() {
        StringToolsTest.assertEquals(null, (String)StringTools.lowercaseFirstChar(null));
        StringToolsTest.assertEquals((String)"", (String)StringTools.lowercaseFirstChar((String)""));
        StringToolsTest.assertEquals((String)"a", (String)StringTools.lowercaseFirstChar((String)"A"));
        StringToolsTest.assertEquals((String)"\u00f6\u00e4\u00fc", (String)StringTools.lowercaseFirstChar((String)"\u00d6\u00e4\u00fc"));
        StringToolsTest.assertEquals((String)"\u00dfa", (String)StringTools.lowercaseFirstChar((String)"\u00dfa"));
        StringToolsTest.assertEquals((String)"'test'", (String)StringTools.lowercaseFirstChar((String)"'Test'"));
        StringToolsTest.assertEquals((String)"''test", (String)StringTools.lowercaseFirstChar((String)"''Test"));
        StringToolsTest.assertEquals((String)"''t", (String)StringTools.lowercaseFirstChar((String)"''T"));
        StringToolsTest.assertEquals((String)"'''", (String)StringTools.lowercaseFirstChar((String)"'''"));
    }

    public void testReaderToString() throws IOException {
        String str = StringTools.readerToString((Reader)new StringReader("bla\n\u00f6\u00e4\u00fc"));
        StringToolsTest.assertEquals((String)"bla\n\u00f6\u00e4\u00fc", (String)str);
        StringBuilder longStr = new StringBuilder();
        for (int i = 0; i < 4000; ++i) {
            longStr.append("x");
        }
        longStr.append("1234567");
        StringToolsTest.assertEquals((int)4007, (int)longStr.length());
        String str2 = StringTools.readerToString((Reader)new StringReader(longStr.toString()));
        StringToolsTest.assertEquals((String)longStr.toString(), (String)str2);
    }

    public void testEscapeXMLandHTML() {
        StringToolsTest.assertEquals((String)"!\u00e4&quot;&lt;&gt;&amp;&amp;", (String)StringTools.escapeXML((String)"!\u00e4\"<>&&"));
        StringToolsTest.assertEquals((String)"!\u00e4&quot;&lt;&gt;&amp;&amp;", (String)StringTools.escapeHTML((String)"!\u00e4\"<>&&"));
    }

    public void testListToString() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        list.add(",");
        StringToolsTest.assertEquals((String)"foo,bar,,", (String)StringTools.listToString(list, (String)","));
        StringToolsTest.assertEquals((String)"foo\tbar\t,", (String)StringTools.listToString(list, (String)"\t"));
    }

    public void testTrimWhitespace() {
        try {
            StringToolsTest.assertEquals(null, (String)StringTools.trimWhitespace(null));
            StringToolsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StringToolsTest.assertEquals((String)"", (String)StringTools.trimWhitespace((String)""));
        StringToolsTest.assertEquals((String)"", (String)StringTools.trimWhitespace((String)" "));
        StringToolsTest.assertEquals((String)"XXY", (String)StringTools.trimWhitespace((String)" \nXX\t Y"));
        StringToolsTest.assertEquals((String)"XXY", (String)StringTools.trimWhitespace((String)" \r\nXX\t Y"));
        StringToolsTest.assertEquals((String)"word", (String)StringTools.trimWhitespace((String)"word"));
        StringToolsTest.assertEquals((String)"1 234,56", (String)StringTools.trimWhitespace((String)"1 234,56"));
        StringToolsTest.assertEquals((String)"1234,56", (String)StringTools.trimWhitespace((String)"1  234,56"));
    }

    public void testAddSpace() {
        Language demoLanguage = TestTools.getDemoLanguage();
        StringToolsTest.assertEquals((String)" ", (String)StringTools.addSpace((String)"word", (Language)demoLanguage));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)",", (Language)demoLanguage));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)",", (Language)demoLanguage));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)",", (Language)demoLanguage));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)".", (Language)new FakeLanguage("fr")));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)".", (Language)new FakeLanguage("de")));
        StringToolsTest.assertEquals((String)" ", (String)StringTools.addSpace((String)"!", (Language)new FakeLanguage("fr")));
        StringToolsTest.assertEquals((String)"", (String)StringTools.addSpace((String)"!", (Language)new FakeLanguage("de")));
    }

    public void testIsWhitespace() {
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isWhitespace((String)"  "));
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isWhitespace((String)"\t"));
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isWhitespace((String)"\u2002"));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isWhitespace((String)"\u00a0"));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isWhitespace((String)"abc"));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isWhitespace((String)"\\u02"));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isWhitespace((String)"\u0001"));
    }

    public void testIsPositiveNumber() {
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isPositiveNumber((char)'3'));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isPositiveNumber((char)'a'));
    }

    public void testIsEmpty() {
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isEmpty((String)""));
        StringToolsTest.assertEquals((boolean)true, (boolean)StringTools.isEmpty(null));
        StringToolsTest.assertEquals((boolean)false, (boolean)StringTools.isEmpty((String)"a"));
    }

    public void testFilterXML() {
        StringToolsTest.assertEquals((String)"test", (String)StringTools.filterXML((String)"test"));
        StringToolsTest.assertEquals((String)"<<test>>", (String)StringTools.filterXML((String)"<<test>>"));
        StringToolsTest.assertEquals((String)"test", (String)StringTools.filterXML((String)"<b>test</b>"));
        StringToolsTest.assertEquals((String)"A sentence with a test", (String)StringTools.filterXML((String)"A sentence with a <em>test</em>"));
    }

    public void testAsString() {
        StringToolsTest.assertNull((Object)StringTools.asString(null));
        StringToolsTest.assertEquals((String)"foo!", (String)"foo!");
    }
}

