/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import morfologik.fsa.CFSA;
import morfologik.fsa.CFSA2;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAFinalStatesIterator;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.fsa.StateVisitor;

public abstract class FSA
implements Iterable<ByteBuffer> {
    public abstract int getRootNode();

    public abstract int getFirstArc(int var1);

    public abstract int getNextArc(int var1);

    public abstract int getArc(int var1, byte var2);

    public abstract byte getArcLabel(int var1);

    public abstract boolean isArcFinal(int var1);

    public abstract boolean isArcTerminal(int var1);

    public abstract int getEndNode(int var1);

    public abstract Set<FSAFlags> getFlags();

    public int getArcCount(int node) {
        int count = 0;
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            ++count;
            arc = this.getNextArc(arc);
        }
        return count;
    }

    public int getRightLanguageCount(int node) {
        throw new UnsupportedOperationException("Automaton not compiled with " + (Object)((Object)FSAFlags.NUMBERS));
    }

    public Iterable<ByteBuffer> getSequences(final int node) {
        if (node == 0) {
            return Collections.emptyList();
        }
        return new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new FSAFinalStatesIterator(FSA.this, node);
            }
        };
    }

    public final Iterable<ByteBuffer> getSequences() {
        return this.getSequences(this.getRootNode());
    }

    @Override
    public final Iterator<ByteBuffer> iterator() {
        return this.getSequences().iterator();
    }

    public <T extends StateVisitor> T visitAllStates(T v) {
        return this.visitInPostOrder(v);
    }

    public <T extends StateVisitor> T visitInPostOrder(T v) {
        return this.visitInPostOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPostOrder(T v, int node) {
        this.visitInPostOrder(v, node, new BitSet());
        return v;
    }

    private boolean visitInPostOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return true;
        }
        visited.set(node);
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (!this.isArcTerminal(arc) && !this.visitInPostOrder(v, this.getEndNode(arc), visited)) {
                return false;
            }
            arc = this.getNextArc(arc);
        }
        return v.accept(node);
    }

    public <T extends StateVisitor> T visitInPreOrder(T v) {
        return this.visitInPreOrder(v, this.getRootNode());
    }

    public <T extends StateVisitor> T visitInPreOrder(T v, int node) {
        this.visitInPreOrder(v, node, new BitSet());
        return v;
    }

    private void visitInPreOrder(StateVisitor v, int node, BitSet visited) {
        if (visited.get(node)) {
            return;
        }
        visited.set(node);
        if (v.accept(node)) {
            int arc = this.getFirstArc(node);
            while (arc != 0) {
                if (!this.isArcTerminal(arc)) {
                    this.visitInPreOrder(v, this.getEndNode(arc), visited);
                }
                arc = this.getNextArc(arc);
            }
        }
    }

    public static <T extends FSA> T read(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, Math.max(13, 1024));
        }
        in.mark(12);
        FSAHeader header = FSAHeader.read(in);
        in.reset();
        if (header.version == 5) {
            return (T)new FSA5(in);
        }
        if (header.version == -59) {
            return (T)new CFSA(in);
        }
        if (header.version == -58) {
            return (T)new CFSA2(in);
        }
        throw new IOException("Unsupported automaton version: " + header.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSA read(File fsa) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fsa));
        try {
            Object t = FSA.read(is);
            return t;
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

