/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import morfologik.util.BufferUtils;

public final class WordData
implements Cloneable {
    private static final String COLLECTIONS_ERROR_MESSAGE = "Not suitable for use in Java collections framework (volatile content). Refer to documentation.";
    private final CharsetDecoder decoder;
    CharSequence wordCharSequence;
    private CharBuffer stemCharSequence;
    private CharBuffer tagCharSequence;
    ByteBuffer wordBuffer;
    ByteBuffer stemBuffer;
    ByteBuffer tagBuffer;

    WordData(CharsetDecoder decoder) {
        this.decoder = decoder;
        this.stemBuffer = ByteBuffer.allocate(0);
        this.tagBuffer = ByteBuffer.allocate(0);
        this.stemCharSequence = CharBuffer.allocate(0);
        this.tagCharSequence = CharBuffer.allocate(0);
    }

    WordData(String stem, String tag, String encoding) {
        this(Charset.forName(encoding).newDecoder());
        try {
            if (stem != null) {
                this.stemBuffer.put(stem.getBytes(encoding));
            }
            if (tag != null) {
                this.tagBuffer.put(tag.getBytes(encoding));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer getStemBytes(ByteBuffer target) {
        target = BufferUtils.ensureCapacity((ByteBuffer)target, (int)this.stemBuffer.remaining());
        this.stemBuffer.mark();
        target.put(this.stemBuffer);
        this.stemBuffer.reset();
        target.flip();
        return target;
    }

    public ByteBuffer getTagBytes(ByteBuffer target) {
        target = BufferUtils.ensureCapacity((ByteBuffer)target, (int)this.tagBuffer.remaining());
        this.tagBuffer.mark();
        target.put(this.tagBuffer);
        this.tagBuffer.reset();
        target.flip();
        return target;
    }

    public ByteBuffer getWordBytes(ByteBuffer target) {
        target = BufferUtils.ensureCapacity((ByteBuffer)target, (int)this.wordBuffer.remaining());
        this.wordBuffer.mark();
        target.put(this.wordBuffer);
        this.wordBuffer.reset();
        target.flip();
        return target;
    }

    public CharSequence getTag() {
        this.tagCharSequence = this.decode(this.tagBuffer, this.tagCharSequence);
        return this.tagCharSequence.remaining() == 0 ? null : this.tagCharSequence;
    }

    public CharSequence getStem() {
        this.stemCharSequence = this.decode(this.stemBuffer, this.stemCharSequence);
        return this.stemCharSequence.remaining() == 0 ? null : this.stemCharSequence;
    }

    public CharSequence getWord() {
        return this.wordCharSequence;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException(COLLECTIONS_ERROR_MESSAGE);
    }

    public int hashCode() {
        throw new UnsupportedOperationException(COLLECTIONS_ERROR_MESSAGE);
    }

    public String toString() {
        return "WordData[" + this.getWord() + "," + this.getStem() + "," + this.getTag() + "]";
    }

    protected WordData clone() {
        WordData clone = new WordData(this.decoder);
        clone.wordCharSequence = this.cloneCharSequence(this.wordCharSequence);
        clone.wordBuffer = this.getWordBytes(null);
        clone.stemBuffer = this.getStemBytes(null);
        clone.tagBuffer = this.getTagBytes(null);
        return clone;
    }

    private CharSequence cloneCharSequence(CharSequence chs) {
        if (chs instanceof String) {
            return chs;
        }
        return chs.toString();
    }

    void reset() {
        this.wordCharSequence = null;
        this.wordBuffer = null;
        this.stemCharSequence.clear();
        this.tagCharSequence.clear();
        this.stemBuffer.clear();
        this.tagBuffer.clear();
    }

    private CharBuffer decode(ByteBuffer bytes, CharBuffer chars) {
        chars.clear();
        int maxCapacity = (int)((float)bytes.remaining() * this.decoder.maxCharsPerByte());
        if (chars.capacity() <= maxCapacity) {
            chars = CharBuffer.allocate(maxCapacity);
        }
        bytes.mark();
        this.decoder.reset();
        this.decoder.decode(bytes, chars, true);
        chars.flip();
        bytes.reset();
        return chars;
    }
}

