/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;

public abstract class AbstractPatternRule
extends Rule {
    protected final Language language;
    protected final List<PatternToken> patternTokens;
    protected final boolean testUnification;
    protected final boolean sentStart;
    protected String subId;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    private final String id;
    private final String description;
    private final boolean getUnified;
    private final boolean groupsOrUnification;

    public AbstractPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.patternTokens = new ArrayList<PatternToken>((Collection)Objects.requireNonNull(patternTokens, "patternTokens cannot be null"));
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.getUnified = getUnified;
        this.testUnification = this.initUnifier();
        boolean bl = this.sentStart = this.patternTokens.size() > 0 && this.patternTokens.get(0).isSentenceStart();
        if (!this.testUnification) {
            boolean found = false;
            for (PatternToken elem : this.patternTokens) {
                if (!elem.hasAndGroup()) continue;
                found = true;
                break;
            }
            this.groupsOrUnification = found;
        } else {
            this.groupsOrUnification = true;
        }
    }

    @Override
    public boolean supportsLanguage(Language language) {
        return language.equalsConsiderVariantsIfSpecified(this.language);
    }

    private boolean initUnifier() {
        for (PatternToken pToken : this.patternTokens) {
            if (!pToken.isUnified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id + "[" + this.subId + "]:" + this.patternTokens + ":" + this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        return null;
    }

    @Override
    public void reset() {
    }

    public final Language getLanguage() {
        return this.language;
    }

    public final void setStartPositionCorrection(int startPositionCorrection) {
        this.startPositionCorrection = startPositionCorrection;
    }

    public final int getStartPositionCorrection() {
        return this.startPositionCorrection;
    }

    public final void setEndPositionCorrection(int endPositionCorrection) {
        this.endPositionCorrection = endPositionCorrection;
    }

    public final int getEndPositionCorrection() {
        return this.endPositionCorrection;
    }

    public final String getSubId() {
        return this.subId;
    }

    public final void setSubId(String subId) {
        this.subId = subId;
    }

    public boolean isGroupsOrUnification() {
        return this.groupsOrUnification;
    }

    public boolean isGetUnified() {
        return this.getUnified;
    }

    public boolean isSentStart() {
        return this.sentStart;
    }

    public boolean isTestUnification() {
        return this.testUnification;
    }

    public List<PatternToken> getPatternTokens() {
        return this.patternTokens;
    }
}

