/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.creators;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.IdManager;
import org.pdfsam.guiclient.business.thumbnails.creators.ThumbnailsCreator;
import org.pdfsam.guiclient.business.thumbnails.executors.ThumbnailsExecutor;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentInfo;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.exceptions.ThumbnailCreationException;
import org.pdfsam.i18n.GettextResource;

public abstract class AbstractThumbnailCreator
implements ThumbnailsCreator {
    private static final Logger log = Logger.getLogger(AbstractThumbnailCreator.class.getPackage().getName());
    private String providedPassword = "";
    private File inputFile = null;
    private JVisualPdfPageSelectionPanel panel;
    private long currentId = 0L;

    @Override
    public BufferedImage getPageImage(String fileName, String password, int page, int rotation) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        if (fileName == null || fileName.length() <= 0) {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to create image for a null input document"));
        }
        File inputFile = new File(fileName);
        retVal = this.getPageImage(inputFile, password, page, rotation);
        return retVal;
    }

    @Override
    public BufferedImage getPageImage(String fileName, String password, int page) throws ThumbnailCreationException {
        return this.getPageImage(fileName, password, page, 0);
    }

    @Override
    public BufferedImage getThumbnail(String fileName, String password, int page, float resizePercentage) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        if (fileName == null || fileName.length() <= 0) {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to create image for a null input document"));
        }
        File inputFile = new File(fileName);
        retVal = this.getThumbnail(inputFile, password, page, resizePercentage);
        return retVal;
    }

    @Override
    public void clean(long id) {
        IdManager.getInstance().cancelExecution(id);
    }

    @Override
    public void initThumbnailsPanel(String fileName, String password, JVisualPdfPageSelectionPanel panel, long id, List<DocumentPage> template) throws ThumbnailCreationException {
        if (fileName != null && fileName.length() > 0) {
            File inputFile = new File(fileName);
            this.initThumbnailsPanel(inputFile, password, panel, id, template);
        } else {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to create thumbnails for a null input document"));
        }
    }

    @Override
    public void initThumbnailsPanel(File inputFile, String password, JVisualPdfPageSelectionPanel panel, long id, List<DocumentPage> template) throws ThumbnailCreationException {
        this.setProvidedPassword(password);
        this.setInputFile(inputFile);
        this.setPanel(panel);
        this.setCurrentId(id);
        this.initThumbnailsCreation();
        if (this.openInputDocument()) {
            Vector<VisualPageListItem> modelList;
            panel.setSelectedPdfDocument(inputFile);
            panel.setSelectedPdfDocumentPassword(this.getProvidedPassword());
            DocumentInfo documentInfo = this.getDocumentInfo();
            if (documentInfo != null) {
                panel.setDocumentProperties(documentInfo);
                panel.setDocumentPropertiesVisible(true);
            }
            if ((modelList = this.getDocumentModel(template)) != null && modelList.size() > 0) {
                ((VisualListModel)panel.getThumbnailList().getModel()).setData(modelList);
                ThumbnailsExecutor.getInstance().invokeAll(this.getGenerationTasks(modelList), this.getCloserTask(), id);
            }
        } else {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to open the input document"));
        }
        this.finalizeThumbnailsCreation();
    }

    @Override
    public BufferedImage getPageImage(File inputFile, String password, int page) throws ThumbnailCreationException {
        return this.getPageImage(inputFile, password, page, 0);
    }

    protected abstract void initThumbnailsCreation() throws ThumbnailCreationException;

    protected abstract boolean openInputDocument() throws ThumbnailCreationException;

    protected abstract DocumentInfo getDocumentInfo() throws ThumbnailCreationException;

    protected abstract Vector<VisualPageListItem> getDocumentModel(List<DocumentPage> var1) throws ThumbnailCreationException;

    protected abstract Callable<Boolean> getCloserTask() throws ThumbnailCreationException;

    protected abstract Collection<? extends Callable<Boolean>> getGenerationTasks(Vector<VisualPageListItem> var1) throws ThumbnailCreationException;

    protected abstract void finalizeThumbnailsCreation() throws ThumbnailCreationException;

    protected String getProvidedPassword() {
        return this.providedPassword;
    }

    protected void setProvidedPassword(String providedPassword) {
        this.providedPassword = providedPassword;
    }

    protected File getInputFile() {
        return this.inputFile;
    }

    private void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    protected JVisualPdfPageSelectionPanel getPanel() {
        return this.panel;
    }

    private void setPanel(JVisualPdfPageSelectionPanel panel) {
        this.panel = panel;
    }

    protected long getCurrentId() {
        return this.currentId;
    }

    private void setCurrentId(long currentId) {
        this.currentId = currentId;
    }
}

