/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.business.listeners.mediators.UpdateCheckerMediator;
import org.pdfsam.guiclient.business.thumbnails.ThumbnailCreatorsRegisty;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.guiclient.utils.ThemeUtility;
import org.pdfsam.guiclient.utils.XmlUtility;
import org.pdfsam.i18n.GettextResource;

public class JSettingsPanel
extends AbstractPlugablePanel {
    private static final long serialVersionUID = -8466940940495530909L;
    private static final Logger log = Logger.getLogger(JSettingsPanel.class.getPackage().getName());
    private JTextField loadDefaultEnv;
    private JTextField defaultDirectory;
    private JComboBox languageCombo;
    private JComboBox comboLog;
    private JComboBox comboLaf;
    private JComboBox comboTheme;
    private JCheckBox checkNewVersion;
    private JCheckBox askOverwriteConfirmation;
    private JComboBox comboThumbnailsCreators;
    private JCheckBox playSounds;
    private JHelpLabel envHelpLabel;
    private SpringLayout settingsLayout;
    private SpringLayout grayBorderSettingsLayout;
    private final JButton browseButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton browseDestDirButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton saveButton = new JButton();
    private final JButton checkNowButton = new JButton();
    private final EnterDoClickListener browseDestDirEnterKeyListener = new EnterDoClickListener(this.browseDestDirButton);
    private final EnterDoClickListener browseEnterKeyListener = new EnterDoClickListener(this.browseButton);
    private final EnterDoClickListener saveEnterKeyListener = new EnterDoClickListener(this.saveButton);
    private final JPanel settingsOptionsPanel = new JPanel();
    private final JPanel gridOptionsPanel = new JPanel();
    private final SettingsFocusPolicy settingsFocusPolicy = new SettingsFocusPolicy();
    private final JLabel themeLabel = new JLabel();
    private final JLabel subThemeLabel = new JLabel();
    private final JLabel languageLabel = new JLabel();
    private final JLabel logLabel = new JLabel();
    private final JLabel creatorLabel = new JLabel();
    private final JLabel loadDefaultEnvLabel = new JLabel();
    private final JLabel defaultDirLabel = new JLabel();
    private Configuration config;
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.0.9e";

    public JSettingsPanel() {
        this.initialize();
    }

    private void initialize() {
        int i;
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/settings.png");
        this.setPreferredSize(new Dimension(400, 480));
        this.settingsLayout = new SpringLayout();
        this.setLayout(this.settingsLayout);
        this.settingsOptionsPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Settings")));
        this.grayBorderSettingsLayout = new SpringLayout();
        this.settingsOptionsPanel.setLayout(this.grayBorderSettingsLayout);
        this.add(this.settingsOptionsPanel);
        this.gridOptionsPanel.setLayout(new GridLayout(5, 4, 3, 3));
        this.themeLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Look and feel:"));
        this.subThemeLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Theme:"));
        this.languageLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Language:"));
        this.logLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Log level:"));
        this.creatorLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Thumbnails creator") + ":");
        this.loadDefaultEnvLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Load default environment at startup:"));
        this.defaultDirLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Default working directory:"));
        this.settingsOptionsPanel.add(this.loadDefaultEnvLabel);
        this.settingsOptionsPanel.add(this.defaultDirLabel);
        this.loadDefaultEnv = new JTextField();
        this.loadDefaultEnv.setText(Configuration.getInstance().getDefaultEnvironment());
        this.loadDefaultEnv.setBorder(new EtchedBorder(1));
        this.settingsOptionsPanel.add(this.loadDefaultEnv);
        this.defaultDirectory = new JTextField();
        this.defaultDirectory.setText(this.config.getDefaultWorkingDirectory());
        this.defaultDirectory.setBorder(new EtchedBorder(1));
        this.settingsOptionsPanel.add(this.defaultDirectory);
        this.languageCombo = new JComboBox<Object>(this.loadLanguages().toArray());
        try {
            for (int i2 = 0; i2 < this.languageCombo.getItemCount(); ++i2) {
                if (!((StringItem)this.languageCombo.getItemAt(i2)).getId().equals(this.config.getSelectedLanguage())) continue;
                this.languageCombo.setSelectedItem(this.languageCombo.getItemAt(i2));
                break;
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
        this.comboLaf = new JComboBox<Object>(ThemeUtility.getLAFList().toArray());
        try {
            String lookAndFeel = Integer.toString(Configuration.getInstance().getLookAndFeel());
            for (i = 0; i < this.comboLaf.getItemCount(); ++i) {
                if (!((StringItem)this.comboLaf.getItemAt(i)).getId().equals(lookAndFeel)) continue;
                this.comboLaf.setSelectedItem(this.comboLaf.getItemAt(i));
                break;
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
        this.comboTheme = new JComboBox<Object>(ThemeUtility.getThemeList().toArray());
        try {
            String theme = Integer.toString(Configuration.getInstance().getTheme());
            for (i = 0; i < this.comboTheme.getItemCount(); ++i) {
                if (!((StringItem)this.comboTheme.getItemAt(i)).getId().equals(theme)) continue;
                this.comboTheme.setSelectedItem(this.comboTheme.getItemAt(i));
                break;
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
        if (!ThemeUtility.isPlastic(Integer.parseInt(((StringItem)this.comboLaf.getSelectedItem()).getId()))) {
            this.comboTheme.setEnabled(false);
        }
        this.comboLaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ThemeUtility.isPlastic(Integer.parseInt(((StringItem)JSettingsPanel.this.comboLaf.getSelectedItem()).getId()))) {
                        JSettingsPanel.this.comboTheme.setEnabled(false);
                    } else {
                        JSettingsPanel.this.comboTheme.setEnabled(true);
                    }
                }
                catch (Exception exc) {
                    JSettingsPanel.this.comboTheme.setFocusable(false);
                }
            }
        });
        this.comboLog = new JComboBox<Object>(this.loadLogLevels().toArray());
        try {
            for (int i3 = 0; i3 < this.comboLog.getItemCount(); ++i3) {
                if (!((StringItem)this.comboLog.getItemAt(i3)).getId().equals(Integer.toString(Configuration.getInstance().getLoggingLevel()))) continue;
                this.comboLog.setSelectedItem(this.comboLog.getItemAt(i3));
                break;
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
        this.checkNewVersion = new JCheckBox(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check for updates at startup"));
        this.checkNewVersion.setSelected(this.config.isCheckForUpdates());
        this.settingsOptionsPanel.add(this.checkNewVersion);
        this.comboThumbnailsCreators = new JComboBox<Object>(ThumbnailCreatorsRegisty.getInstalledCreators().toArray());
        try {
            for (int i4 = 0; i4 < this.comboThumbnailsCreators.getItemCount(); ++i4) {
                if (!((StringItem)this.comboThumbnailsCreators.getItemAt(i4)).getId().equals(this.config.getThumbnailsCreatorIdentifier())) continue;
                this.comboThumbnailsCreators.setSelectedItem(this.comboThumbnailsCreators.getItemAt(i4));
                break;
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
        }
        this.checkNowButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check now"));
        this.checkNowButton.setMargin(new Insets(2, 2, 2, 2));
        this.gridOptionsPanel.add(this.languageLabel);
        this.gridOptionsPanel.add(this.languageCombo);
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(this.themeLabel);
        this.gridOptionsPanel.add(this.comboLaf);
        this.gridOptionsPanel.add(this.subThemeLabel);
        this.gridOptionsPanel.add(this.comboTheme);
        this.gridOptionsPanel.add(this.logLabel);
        this.gridOptionsPanel.add(this.comboLog);
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(this.creatorLabel);
        this.gridOptionsPanel.add(this.comboThumbnailsCreators);
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(this.checkNewVersion);
        this.gridOptionsPanel.add(new JLabel());
        this.gridOptionsPanel.add(this.checkNowButton);
        this.gridOptionsPanel.add(new JLabel());
        this.settingsOptionsPanel.add(this.gridOptionsPanel);
        this.playSounds = new JCheckBox(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Play alert sounds"));
        this.playSounds.setSelected(this.config.isPlaySounds());
        this.settingsOptionsPanel.add(this.playSounds);
        this.askOverwriteConfirmation = new JCheckBox(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Ask for confirmation when overwrite checkbox is selected"));
        this.askOverwriteConfirmation.setSelected(this.config.isAskOverwriteConfirmation());
        this.settingsOptionsPanel.add(this.askOverwriteConfirmation);
        String helpTextEnv = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Settings ") + "</b><ul>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Language") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set your preferred language (restart needed)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Look and feel") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set your preferred look and feel and your preferred theme (restart needed)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Log level") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set a log detail level (restart needed)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Thumbnails creator") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the thumbnails creation library") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check for updates") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set when new version availability should be checked (restart needed)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Play alert sounds") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Turn on or off alert sounds") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Ask overwrite confirmation") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Show a dialog box asking the user for confirmation when the \"overwrite\" is selected") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Default env.") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Select a previously saved env. file that will be automatically loaded at startup") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Default working directory") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Select a directory where documents will be saved and loaded by default") + ".</li>" + "</ul></body></html>";
        this.envHelpLabel = new JHelpLabel(helpTextEnv, true);
        this.settingsOptionsPanel.add(this.envHelpLabel);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.XML_FILE, 2, JSettingsPanel.this.loadDefaultEnv.getText());
                if (fileChooser.showOpenDialog(JSettingsPanel.this.browseButton.getParent()) == 0 && fileChooser.getSelectedFile() != null) {
                    JSettingsPanel.this.loadDefaultEnv.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.settingsOptionsPanel.add(this.browseButton);
        this.browseDestDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.NO_FILTER, 1, JSettingsPanel.this.defaultDirectory.getText());
                if (fileChooser.showOpenDialog(JSettingsPanel.this.browseButton.getParent()) == 0 && fileChooser.getSelectedFile() != null) {
                    JSettingsPanel.this.defaultDirectory.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.settingsOptionsPanel.add(this.browseDestDirButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/images/filesave.png")));
        this.saveButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Save"));
        this.saveButton.setMargin(new Insets(5, 5, 5, 5));
        this.saveButton.setSize(new Dimension(88, 25));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Configuration.getInstance().setLoggingLevel(Integer.parseInt(((StringItem)JSettingsPanel.this.comboLog.getSelectedItem()).getId()));
                    Configuration.getInstance().setLookAndFeel(Integer.parseInt(((StringItem)JSettingsPanel.this.comboLaf.getSelectedItem()).getId()));
                    Configuration.getInstance().setTheme(Integer.parseInt(((StringItem)JSettingsPanel.this.comboTheme.getSelectedItem()).getId()));
                    Configuration.getInstance().setSelectedLanguage(((StringItem)JSettingsPanel.this.languageCombo.getSelectedItem()).getId());
                    Configuration.getInstance().setPlaySounds(JSettingsPanel.this.playSounds.isSelected());
                    Configuration.getInstance().setAskOverwriteConfirmation(JSettingsPanel.this.askOverwriteConfirmation.isSelected());
                    Configuration.getInstance().setCheckForUpdates(JSettingsPanel.this.checkNewVersion.isSelected());
                    Configuration.getInstance().setDefaultEnvironment(JSettingsPanel.this.loadDefaultEnv.getText());
                    Configuration.getInstance().setDefaultWorkingDirectory(JSettingsPanel.this.defaultDirectory.getText());
                    Configuration.getInstance().setThumbnailsCreatorIdentifier(((StringItem)JSettingsPanel.this.comboThumbnailsCreators.getSelectedItem()).getId());
                    Configuration.getInstance().save();
                    log.info(GettextResource.gettext((ResourceBundle)JSettingsPanel.this.config.getI18nResourceBundle(), (String)"Configuration saved."));
                }
                catch (Exception ex) {
                    log.error(GettextResource.gettext((ResourceBundle)JSettingsPanel.this.config.getI18nResourceBundle(), (String)"Error: "), ex);
                    DialogUtility.errorGenericDialog(JSettingsPanel.this, GettextResource.gettext((ResourceBundle)JSettingsPanel.this.config.getI18nResourceBundle(), (String)"Error saving configuration"), GettextResource.gettext((ResourceBundle)JSettingsPanel.this.config.getI18nResourceBundle(), (String)"An error occured saving the configuration, please look at the log panel to have more informations."));
                }
            }
        });
        this.add(this.saveButton);
        this.browseDestDirButton.addKeyListener(this.browseDestDirEnterKeyListener);
        this.browseButton.addKeyListener(this.browseEnterKeyListener);
        this.saveButton.addKeyListener(this.saveEnterKeyListener);
        this.setLayout();
    }

    private Vector<StringItem> loadLanguages() {
        Vector<StringItem> langs = new Vector<StringItem>(10, 5);
        try {
            Document document = XmlUtility.parseXmlFile(this.getClass().getResource("/org/pdfsam/i18n/languages.xml"));
            List nodeList = document.selectNodes("/languages/language");
            for (int i = 0; nodeList != null && i < nodeList.size(); ++i) {
                Node langNode = (Node)nodeList.get(i);
                if (langNode == null) continue;
                langs.add(new StringItem(langNode.selectSingleNode("@value").getText(), langNode.selectSingleNode("@description").getText()));
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), e);
            langs.add(new StringItem("en_GB", "English (UK)"));
        }
        Collections.sort(langs);
        return langs;
    }

    private Vector<StringItem> loadLogLevels() {
        Vector<StringItem> logs = new Vector<StringItem>(10, 5);
        logs.add(new StringItem(Integer.toString(10000), Level.DEBUG.toString()));
        logs.add(new StringItem(Integer.toString(20000), Level.INFO.toString()));
        logs.add(new StringItem(Integer.toString(30000), Level.WARN.toString()));
        logs.add(new StringItem(Integer.toString(40000), Level.ERROR.toString()));
        logs.add(new StringItem(Integer.toString(50000), Level.FATAL.toString()));
        logs.add(new StringItem(Integer.toString(Integer.MAX_VALUE), Level.OFF.toString()));
        return logs;
    }

    @Override
    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    @Override
    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Settings");
    }

    @Override
    public String getVersion() {
        return PLUGIN_VERSION;
    }

    private void setLayout() {
        this.settingsLayout.putConstraint("South", (Component)this.settingsOptionsPanel, 370, "North", (Component)this);
        this.settingsLayout.putConstraint("East", (Component)this.settingsOptionsPanel, -5, "East", (Component)this);
        this.settingsLayout.putConstraint("North", (Component)this.settingsOptionsPanel, 5, "North", (Component)this);
        this.settingsLayout.putConstraint("West", (Component)this.settingsOptionsPanel, 5, "West", (Component)this);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.gridOptionsPanel, 5, "North", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.gridOptionsPanel, 5, "West", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.playSounds, 20, "North", (Component)this.playSounds);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.playSounds, -5, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.playSounds, 5, "South", (Component)this.gridOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.playSounds, 0, "West", (Component)this.gridOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.askOverwriteConfirmation, 20, "North", (Component)this.askOverwriteConfirmation);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.askOverwriteConfirmation, -5, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.askOverwriteConfirmation, 10, "South", (Component)this.playSounds);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.askOverwriteConfirmation, 0, "West", (Component)this.playSounds);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.loadDefaultEnvLabel, 20, "North", (Component)this.loadDefaultEnvLabel);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.loadDefaultEnvLabel, -5, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.loadDefaultEnvLabel, 5, "South", (Component)this.askOverwriteConfirmation);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.loadDefaultEnvLabel, 0, "West", (Component)this.askOverwriteConfirmation);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.loadDefaultEnv, 20, "North", (Component)this.loadDefaultEnv);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.loadDefaultEnv, -100, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.loadDefaultEnv, 5, "South", (Component)this.loadDefaultEnvLabel);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.loadDefaultEnv, 0, "West", (Component)this.loadDefaultEnvLabel);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.browseButton, 25, "North", (Component)this.browseButton);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.browseButton, -5, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.browseButton, 0, "North", (Component)this.loadDefaultEnv);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.browseButton, -90, "East", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.defaultDirLabel, 20, "North", (Component)this.defaultDirLabel);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.defaultDirLabel, 0, "East", (Component)this.loadDefaultEnvLabel);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.defaultDirLabel, 5, "South", (Component)this.loadDefaultEnv);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.defaultDirLabel, 0, "West", (Component)this.loadDefaultEnvLabel);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.defaultDirectory, 20, "North", (Component)this.defaultDirectory);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.defaultDirectory, 0, "East", (Component)this.loadDefaultEnv);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.defaultDirectory, 5, "South", (Component)this.defaultDirLabel);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.defaultDirectory, 0, "West", (Component)this.loadDefaultEnv);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.browseDestDirButton, 25, "North", (Component)this.browseDestDirButton);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.browseDestDirButton, 0, "East", (Component)this.browseButton);
        this.grayBorderSettingsLayout.putConstraint("North", (Component)this.browseDestDirButton, 0, "North", (Component)this.defaultDirectory);
        this.grayBorderSettingsLayout.putConstraint("West", (Component)this.browseDestDirButton, 0, "West", (Component)this.browseButton);
        this.grayBorderSettingsLayout.putConstraint("South", (Component)this.envHelpLabel, -1, "South", (Component)this.settingsOptionsPanel);
        this.grayBorderSettingsLayout.putConstraint("East", (Component)this.envHelpLabel, -1, "East", (Component)this.settingsOptionsPanel);
        this.settingsLayout.putConstraint("East", (Component)this.saveButton, -10, "East", (Component)this);
        this.settingsLayout.putConstraint("North", (Component)this.saveButton, 5, "South", (Component)this.settingsOptionsPanel);
    }

    @Override
    public FocusTraversalPolicy getFocusPolicy() {
        return this.settingsFocusPolicy;
    }

    @Override
    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        return arg0;
    }

    @Override
    public void loadJobNode(Node arg0) throws LoadJobException {
        log.debug(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Unimplemented method for JSettingsPanel"));
    }

    @Override
    public void resetPanel() {
    }

    public void setCheckUpdateMediator(UpdateCheckerMediator updateCheckerMediator) {
        this.checkNowButton.addActionListener(updateCheckerMediator);
    }

    public class SettingsFocusPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(JSettingsPanel.this.languageCombo)) {
                return JSettingsPanel.this.comboLaf;
            }
            if (aComponent.equals(JSettingsPanel.this.comboLaf)) {
                if (JSettingsPanel.this.comboTheme.isEnabled()) {
                    return JSettingsPanel.this.comboTheme;
                }
                return JSettingsPanel.this.comboLog;
            }
            if (aComponent.equals(JSettingsPanel.this.comboTheme)) {
                return JSettingsPanel.this.comboLog;
            }
            if (aComponent.equals(JSettingsPanel.this.comboLog)) {
                return JSettingsPanel.this.comboThumbnailsCreators;
            }
            if (aComponent.equals(JSettingsPanel.this.comboThumbnailsCreators)) {
                return JSettingsPanel.this.checkNewVersion;
            }
            if (aComponent.equals(JSettingsPanel.this.checkNewVersion)) {
                return JSettingsPanel.this.checkNowButton;
            }
            if (aComponent.equals(JSettingsPanel.this.checkNowButton)) {
                return JSettingsPanel.this.playSounds;
            }
            if (aComponent.equals(JSettingsPanel.this.playSounds)) {
                return JSettingsPanel.this.askOverwriteConfirmation;
            }
            if (aComponent.equals(JSettingsPanel.this.askOverwriteConfirmation)) {
                return JSettingsPanel.this.loadDefaultEnv;
            }
            if (aComponent.equals(JSettingsPanel.this.loadDefaultEnv)) {
                return JSettingsPanel.this.browseButton;
            }
            if (aComponent.equals(JSettingsPanel.this.browseButton)) {
                return JSettingsPanel.this.defaultDirectory;
            }
            if (aComponent.equals(JSettingsPanel.this.defaultDirectory)) {
                return JSettingsPanel.this.browseDestDirButton;
            }
            if (aComponent.equals(JSettingsPanel.this.browseDestDirButton)) {
                return JSettingsPanel.this.saveButton;
            }
            if (aComponent.equals(JSettingsPanel.this.saveButton)) {
                return JSettingsPanel.this.languageCombo;
            }
            return JSettingsPanel.this.languageCombo;
        }

        @Override
        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(JSettingsPanel.this.browseButton)) {
                return JSettingsPanel.this.loadDefaultEnv;
            }
            if (aComponent.equals(JSettingsPanel.this.loadDefaultEnv)) {
                return JSettingsPanel.this.askOverwriteConfirmation;
            }
            if (aComponent.equals(JSettingsPanel.this.askOverwriteConfirmation)) {
                return JSettingsPanel.this.playSounds;
            }
            if (aComponent.equals(JSettingsPanel.this.playSounds)) {
                return JSettingsPanel.this.checkNowButton;
            }
            if (aComponent.equals(JSettingsPanel.this.checkNowButton)) {
                return JSettingsPanel.this.checkNewVersion;
            }
            if (aComponent.equals(JSettingsPanel.this.checkNewVersion)) {
                return JSettingsPanel.this.comboThumbnailsCreators;
            }
            if (aComponent.equals(JSettingsPanel.this.comboThumbnailsCreators)) {
                return JSettingsPanel.this.comboLog;
            }
            if (aComponent.equals(JSettingsPanel.this.comboLog)) {
                if (JSettingsPanel.this.comboTheme.isEnabled()) {
                    return JSettingsPanel.this.comboTheme;
                }
                return JSettingsPanel.this.comboLaf;
            }
            if (aComponent.equals(JSettingsPanel.this.comboTheme)) {
                return JSettingsPanel.this.comboLaf;
            }
            if (aComponent.equals(JSettingsPanel.this.comboLaf)) {
                return JSettingsPanel.this.languageCombo;
            }
            if (aComponent.equals(JSettingsPanel.this.saveButton)) {
                return JSettingsPanel.this.browseDestDirButton;
            }
            if (aComponent.equals(JSettingsPanel.this.browseDestDirButton)) {
                return JSettingsPanel.this.defaultDirectory;
            }
            if (aComponent.equals(JSettingsPanel.this.defaultDirectory)) {
                return JSettingsPanel.this.browseButton;
            }
            if (aComponent.equals(JSettingsPanel.this.languageCombo)) {
                return JSettingsPanel.this.saveButton;
            }
            return JSettingsPanel.this.languageCombo;
        }

        @Override
        public Component getDefaultComponent(Container CycleRootComp) {
            return JSettingsPanel.this.languageCombo;
        }

        @Override
        public Component getLastComponent(Container CycleRootComp) {
            return JSettingsPanel.this.browseButton;
        }

        @Override
        public Component getFirstComponent(Container CycleRootComp) {
            return JSettingsPanel.this.languageCombo;
        }
    }
}

