/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class SynchTools {
    private static byte[] bytes;

    public static void delSynchFile(File file) throws IOException {
        file.delete();
    }

    public static byte[] getBytes() {
        return bytes;
    }

    public static File getSynchFile() throws IOException {
        return File.createTempFile("synchfile", ".synch");
    }

    public static void setBytes(byte[] byArray) {
        bytes = byArray;
    }

    public static void setSynchFile(File file) throws IOException {
        SynchTools.setSynchFile(file, SynchTools.getBytes());
        bytes = null;
    }

    public static void setSynchFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (byArray != null) {
            fileOutputStream.write(byArray);
        }
        fileOutputStream.close();
    }

    public static void setSynchFile(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static void waitSynchFile(File file, int n) throws IOException {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (l2 < (long)n && !file.exists()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("waiting for synch file '" + file.getPath() + "' interrupted");
            }
            l2 = System.currentTimeMillis() - l;
        }
        if (!file.exists()) {
            throw new IOException("timeout waiing for synch file '" + file.getPath() + "'");
        }
    }
}

