/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ArgTools {
    private static int nesting = 0;
    public static final IFunctor toString = new IFunctor(){

        public Object perform(IFunctorCall iFunctorCall) throws FunctorInvocationException {
            Args args = (Args)iFunctorCall.getReceiver();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Iterator<IArgs.IBinding> iterator = args.bindings();
            while (iterator.hasNext()) {
                IArgs.IBinding iBinding = iterator.next();
                if (iBinding.getName() != null) {
                    stringBuilder.append(iBinding.getName());
                } else {
                    stringBuilder.append(n);
                }
                stringBuilder.append(" = ");
                stringBuilder.append(iBinding.getValue());
                stringBuilder.append("\n");
                ++n;
            }
            return stringBuilder.toString();
        }
    };
    private static Set visited;

    protected static <T> T convert(Object object, Class<T> clazz) throws ConversionException {
        return ConverterRegistry.get().convert(object, clazz);
    }

    protected static <T> T convert(Object object, Class<T> clazz, Object object2) {
        try {
            T t = ArgTools.convert(object, clazz);
            if (t != null) {
                return t;
            }
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return (T)object2;
    }

    public static IArgs createArgs() {
        return Args.create();
    }

    public static IArgs getArgs(IArgs iArgs, String string, IArgs iArgs2) {
        if (iArgs == null) {
            return iArgs2;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return iArgs2;
        }
        return ArgTools.toArgs(object);
    }

    public static boolean getBool(IArgs iArgs, String string, boolean bl) {
        if (iArgs == null) {
            return bl;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return Converter.asBoolean(string2, bl);
        }
        return ArgTools.convert(object, Boolean.class, bl);
    }

    public static boolean getBoolean(IArgs iArgs, String string, boolean bl) {
        return ArgTools.getBool(iArgs, string, bl);
    }

    public static byte getByte(IArgs iArgs, String string, byte by) {
        if (iArgs == null) {
            return by;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            try {
                return Byte.parseByte((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return by;
            }
        }
        return ArgTools.convert(object, Byte.class, by);
    }

    public static byte[] getByteArray(IArgs iArgs, String string, byte[] byArray) {
        if (iArgs == null) {
            return byArray;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return Base64.decode((String)object);
        }
        if (object instanceof ILocator) {
            try {
                return LocatorTools.getBytes((ILocator)object);
            }
            catch (IOException iOException) {
                return byArray;
            }
        }
        if (object instanceof ILocatorSupport) {
            try {
                return LocatorTools.getBytes(((ILocatorSupport)object).getLocator());
            }
            catch (IOException iOException) {
                return byArray;
            }
        }
        return ArgTools.convert(object, byte[].class, byArray);
    }

    public static char getChar(IArgs iArgs, String string, char c) {
        String string2;
        if (iArgs == null) {
            return c;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof String && (string2 = (String)object).length() > 0) {
            return string2.charAt(0);
        }
        return ArgTools.convert(object, Character.class, Character.valueOf(c)).charValue();
    }

    public static char[] getCharArray(IArgs iArgs, String string, char[] cArray) throws IllegalArgumentException {
        if (iArgs == null) {
            return cArray;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return cArray;
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        try {
            return ArgTools.convert(object, char[].class);
        }
        catch (ConversionException conversionException) {
            return cArray;
        }
    }

    public static Class getClass(IArgs iArgs, String string, Class clazz) {
        if (iArgs == null) {
            return clazz;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return clazz;
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                return ClassTools.createClass(string2, Object.class, null);
            }
            catch (Exception exception) {
                return clazz;
            }
        }
        return ArgTools.convert(object, Class.class, clazz);
    }

    public static Color getColor(IArgs iArgs, String string, Color color) {
        if (iArgs == null) {
            return color;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return color;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            try {
                return Color.decode((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        return ArgTools.convert(object, Color.class, color);
    }

    public static Date getDate(IArgs iArgs, String string, Date date) {
        if (iArgs == null) {
            return date;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return date;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                return DateFormat.getInstance().parse(string2);
            }
            catch (ParseException parseException) {
                return date;
            }
        }
        return ArgTools.convert(object, Date.class, date);
    }

    public static IDigest getDigest(IArgs iArgs, String string) throws IOException {
        if (iArgs == null) {
            return null;
        }
        Object object = ArgTools.getPath(iArgs, string);
        return DigestTools.createDigest(object);
    }

    public static <T extends EnumItem> T getEnumItem(IArgs iArgs, EnumMeta<T> enumMeta, String string) {
        return ArgTools.getEnumItem(iArgs, enumMeta, string, enumMeta.getDefault());
    }

    public static <T extends EnumItem> T getEnumItem(IArgs iArgs, EnumMeta<T> enumMeta, String string, String string2) {
        if (iArgs == null) {
            return enumMeta.getItemOrDefault(string2);
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return enumMeta.getItemOrDefault(string2);
        }
        if (object instanceof EnumItem) {
            return (T)((EnumItem)object);
        }
        if (object instanceof String) {
            String string3 = (String)object;
            return enumMeta.getItemOrDefault(string3);
        }
        return (T)((EnumItem)ArgTools.convert(object, enumMeta.getEnumClazz(), enumMeta.getItemOrDefault(string2)));
    }

    public static <T extends EnumItem> T getEnumItem(IArgs iArgs, EnumMeta<T> enumMeta, String string, T t) {
        if (iArgs == null) {
            return t;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return t;
        }
        if (object instanceof EnumItem) {
            return (T)((EnumItem)object);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return enumMeta.getItemOrDefault(string2);
        }
        return (T)((EnumItem)ArgTools.convert(object, enumMeta.getEnumClazz(), t));
    }

    public static File getFile(IArgs iArgs, String string, File file) {
        if (iArgs == null) {
            return file;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof String) {
            return new File((String)object);
        }
        if (object instanceof FileLocator) {
            return ((FileLocator)object).getFile();
        }
        if (object instanceof ILocator) {
            return new File(((ILocator)object).getFullName());
        }
        return ArgTools.convert(object, File.class, file);
    }

    public static float getFloat(IArgs iArgs, String string, float f) {
        if (iArgs == null) {
            return f;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.indexOf("%") != -1) {
                try {
                    Number number = NumberFormat.getPercentInstance().parse(string2);
                    return number.floatValue();
                }
                catch (ParseException parseException) {
                    return f;
                }
            }
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }
        return ArgTools.convert(object, Float.class, Float.valueOf(f)).floatValue();
    }

    public static int getInt(IArgs iArgs, String string, int n) {
        if (iArgs == null) {
            return n;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return ArgTools.convert(object, Integer.class, n);
    }

    public static List getList(IArgs iArgs, String string, List list) {
        if (iArgs == null) {
            return list;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return list;
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof String) {
            return Converter.asList((String)object);
        }
        if (object instanceof IArgs) {
            return ArgTools.toList((IArgs)object);
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        return ArgTools.convert(object, List.class, list);
    }

    public static ILocator getLocator(IArgs iArgs, String string, ILocator iLocator, ILocatorFactory iLocatorFactory) {
        if (iArgs == null) {
            return iLocator;
        }
        Object object = ArgTools.getPath(iArgs, string);
        return LocatorTools.createLocator(object, iLocatorFactory, iLocator);
    }

    public static List<ILocator> getLocators(IArgs iArgs, String string, ILocatorFactory iLocatorFactory) {
        if (iArgs == null) {
            return null;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return null;
        }
        if (object instanceof ILocator[]) {
            return Arrays.asList((ILocator[])object);
        }
        ArrayList<ILocator> arrayList = new ArrayList<ILocator>();
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                ILocator iLocator = LocatorTools.createLocator(e, iLocatorFactory, null);
                if (iLocator == null) continue;
                arrayList.add(iLocator);
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                ILocator iLocator = LocatorTools.createLocator(objectArray[n], iLocatorFactory, null);
                if (iLocator != null) {
                    arrayList.add(iLocator);
                }
                ++n;
            }
        } else if (object instanceof IArgs) {
            Object object2;
            Iterator<IArgs.IBinding> iterator = ((IArgs)object).bindings();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2.getName() != null) break;
                ILocator iLocator = LocatorTools.createLocator(object2.getValue(), iLocatorFactory, null);
                if (iLocator == null) continue;
                arrayList.add(iLocator);
            }
            if (arrayList.isEmpty() && (object2 = LocatorTools.createLocator(object, iLocatorFactory, null)) != null) {
                arrayList.add((ILocator)object2);
            }
        } else {
            ILocator iLocator = LocatorTools.createLocator(object, iLocatorFactory, null);
            if (iLocator != null) {
                arrayList.add(iLocator);
            }
        }
        return arrayList;
    }

    public static Level getLogLevel(IArgs iArgs, String string, Level level) {
        if (iArgs == null) {
            return level;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return level;
        }
        if (object instanceof Level) {
            return (Level)object;
        }
        if (object instanceof String) {
            try {
                return Level.parse((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return level;
            }
        }
        return ArgTools.convert(object, Level.class, level);
    }

    public static long getLong(IArgs iArgs, String string, long l) {
        if (iArgs == null) {
            return l;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        return ArgTools.convert(object, Long.class, l);
    }

    public static Map getMap(IArgs iArgs, String string, Map map) {
        if (iArgs == null) {
            return map;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return map;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof String) {
            return Converter.asMap((String)object);
        }
        if (object instanceof IArgs) {
            return ArgTools.toMap((IArgs)object);
        }
        return ArgTools.convert(object, Map.class, map);
    }

    public static Object getObject(IArgs iArgs, String string, Object object) {
        if (iArgs == null) {
            return object;
        }
        Object object2 = ArgTools.getPath(iArgs, string);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public static Object getPath(IArgs iArgs, String string) {
        int n;
        String string2;
        String[] stringArray = string.split("\\.");
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            Object object;
            string2 = stringArray[n2];
            try {
                n = Integer.parseInt(string2.trim());
                object = iArgs.get(n);
            }
            catch (NumberFormatException numberFormatException) {
                object = iArgs.get(string2);
            }
            iArgs = ArgTools.toArgs(object);
            ++n2;
        }
        string2 = stringArray[n2];
        try {
            n = Integer.parseInt(string2.trim());
            return iArgs.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return iArgs.get(string2);
        }
    }

    public static Point2D getPoint(IArgs iArgs, String string, Point2D point2D) {
        if (iArgs == null) {
            return point2D;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return point2D;
        }
        if (object instanceof Point2D) {
            return (Point2D)object;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            String[] stringArray = string2.split("[x*@]");
            if (stringArray == null || stringArray.length != 2) {
                return point2D;
            }
            try {
                float f = Float.parseFloat(stringArray[0]);
                float f2 = Float.parseFloat(stringArray[1]);
                return new Point2D.Float(f, f2);
            }
            catch (NumberFormatException numberFormatException) {
                return point2D;
            }
        }
        return ArgTools.convert(object, Point2D.class, point2D);
    }

    public static String getString(IArgs iArgs, String string, String string2) {
        if (iArgs == null) {
            return string2;
        }
        Object object = ArgTools.getPath(iArgs, string);
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        return ArgTools.convert(object, String.class, String.valueOf(object));
    }

    public static <T> T getValue(IArgs iArgs, String string, Class<T> clazz, Object object) {
        if (iArgs == null) {
            return (T)object;
        }
        Object object2 = ArgTools.getPath(iArgs, string);
        return ArgTools.convert(object2, clazz, object);
    }

    public static String prefix(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        return String.valueOf(string) + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    public static IArgs putAll(IArgs iArgs, IArgs iArgs2) {
        Iterator<IArgs.IBinding> iterator = iArgs2.bindings();
        while (iterator.hasNext()) {
            IArgs.IBinding iBinding = iterator.next();
            if (iBinding.getName() == null) continue;
            iArgs.put(iBinding.getName(), iBinding.getValue());
        }
        return iArgs;
    }

    public static IArgs putAll(IArgs iArgs, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            ArgTools.putPath(iArgs, String.valueOf(entry.getKey()), entry.getValue());
        }
        return iArgs;
    }

    public static IArgs putAllDeep(IArgs iArgs, IArgs iArgs2) {
        Iterator<IArgs.IBinding> iterator = iArgs2.bindings();
        while (iterator.hasNext()) {
            IArgs.IBinding iBinding = iterator.next();
            if (iBinding.getName() == null) continue;
            Object object = iArgs.get(iBinding.getName());
            Object object2 = iBinding.getValue();
            if (object instanceof IArgs && object2 instanceof IArgs) {
                ArgTools.putAllDeep((IArgs)object, (IArgs)object2);
                continue;
            }
            iArgs.put(iBinding.getName(), iBinding.getValue());
        }
        return iArgs;
    }

    public static IArgs putAllIfAbsent(IArgs iArgs, IArgs iArgs2) {
        Iterator<IArgs.IBinding> iterator = iArgs2.bindings();
        while (iterator.hasNext()) {
            IArgs.IBinding iBinding = iterator.next();
            if (iBinding.getName() == null || iArgs.isDefined(iBinding.getName())) continue;
            iArgs.put(iBinding.getName(), iBinding.getValue());
        }
        return iArgs;
    }

    public static IArgs putAllIfAbsent(IArgs iArgs, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = String.valueOf(entry.getKey());
            if (iArgs.isDefined(string)) continue;
            ArgTools.putPath(iArgs, string, entry.getValue());
        }
        return iArgs;
    }

    public static IArgs putAllIfAbsentDeep(IArgs iArgs, IArgs iArgs2) {
        Iterator<IArgs.IBinding> iterator = iArgs2.bindings();
        while (iterator.hasNext()) {
            IArgs.IBinding iBinding = iterator.next();
            if (iBinding.getName() == null) continue;
            Object object = iArgs.get(iBinding.getName());
            Object object2 = iBinding.getValue();
            if (object instanceof IArgs && object2 instanceof IArgs) {
                ArgTools.putAllIfAbsentDeep((IArgs)object, (IArgs)object2);
                continue;
            }
            if (iArgs.isDefined(iBinding.getName())) continue;
            iArgs.put(iBinding.getName(), iBinding.getValue());
        }
        return iArgs;
    }

    public static void putDefinition(IArgs iArgs, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("[\\:\\=]", 2);
        if (stringArray.length > 1) {
            ArgTools.putPath(iArgs, stringArray[0], stringArray[1]);
        } else {
            ArgTools.putPath(iArgs, stringArray[0], true);
        }
    }

    public static IArgs putMapped(IArgs iArgs, IArgs iArgs2, String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray2.length) {
            ArgTools.putPath(iArgs, stringArray[n], ArgTools.getPath(iArgs2, stringArray2[n]));
            ++n;
        }
        return iArgs;
    }

    public static IArgs putPath(IArgs iArgs, String string, Object object) {
        int n;
        String string2;
        String[] stringArray = string.split("\\.");
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            Object object2;
            block6: {
                string2 = stringArray[n2];
                try {
                    n = Integer.parseInt(string2.trim());
                    object2 = iArgs.get(n);
                    if (!(object2 instanceof IArgs)) {
                        object2 = ArgTools.toArgs(object2);
                        iArgs.put(n, object2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = iArgs.get(string2);
                    if (object2 instanceof IArgs) break block6;
                    object2 = ArgTools.toArgs(object2);
                    iArgs.put(string2, object2);
                }
            }
            iArgs = (IArgs)object2;
            ++n2;
        }
        string2 = stringArray[n2];
        try {
            n = Integer.parseInt(string2.trim());
            iArgs.put(n, object);
        }
        catch (NumberFormatException numberFormatException) {
            iArgs.put(string2, object);
        }
        return iArgs;
    }

    public static IArgs toArgs(Object map) {
        if (map instanceof IArgs) {
            return (IArgs)((Object)map);
        }
        if (map == null) {
            return Args.create();
        }
        if (map instanceof String) {
            map = Converter.asMap((String)((Object)map));
        }
        if (map instanceof Map) {
            Args args = Args.create();
            ArgTools.putAll((IArgs)args, map);
            return args;
        }
        if (map instanceof List) {
            return new Args((List)((Object)map));
        }
        return ArgTools.convert(map, IArgs.class, Args.create());
    }

    public static List toList(IArgs iArgs) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iArgs != null) {
            Iterator<IArgs.IBinding> iterator = iArgs.bindings();
            while (iterator.hasNext()) {
                IArgs.IBinding iBinding = iterator.next();
                arrayList.add(iBinding.getValue());
            }
        }
        return arrayList;
    }

    public static Map toMap(IArgs iArgs) {
        int n = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (iArgs != null) {
            Iterator<IArgs.IBinding> iterator = iArgs.bindings();
            while (iterator.hasNext()) {
                IArgs.IBinding iBinding = iterator.next();
                Object object = iBinding.getValue();
                String string = iBinding.getName() != null ? iBinding.getName() : "" + n;
                hashMap.put(string, object);
                ++n;
            }
        }
        return hashMap;
    }

    public static Map toMapDeep(IArgs iArgs) {
        int n = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (iArgs != null) {
            Iterator<IArgs.IBinding> iterator = iArgs.bindings();
            while (iterator.hasNext()) {
                IArgs.IBinding iBinding = iterator.next();
                Object object = iBinding.getValue();
                if (object instanceof IArgs) {
                    object = ArgTools.toMapDeep((IArgs)object);
                }
                String string = iBinding.getName() != null ? iBinding.getName() : "" + n;
                hashMap.put(string, object);
                ++n;
            }
        }
        return hashMap;
    }

    public static Map<String, Object> toMapDeepFlat(IArgs iArgs) {
        return ArgTools.toMapDeepFlat(iArgs, null, new HashMap<String, Object>());
    }

    public static Map<String, Object> toMapDeepFlat(IArgs iArgs, String string, Map<String, Object> map) {
        int n = 0;
        Iterator<IArgs.IBinding> iterator = iArgs.bindings();
        while (iterator.hasNext()) {
            Object object;
            IArgs.IBinding iBinding = iterator.next();
            String string2 = iBinding.getName() != null ? iBinding.getName() : "" + n;
            if (!StringTools.isEmpty(string)) {
                string2 = String.valueOf(string) + "." + string2;
            }
            if ((object = iBinding.getValue()) instanceof IArgs) {
                ArgTools.toMapDeepFlat((IArgs)object, string2, map);
            } else {
                map.put(string2, object);
            }
            ++n;
        }
        return map;
    }

    public static synchronized String toString(IArgs iArgs, String string) {
        if (visited == null) {
            visited = new HashSet();
            nesting = 0;
        }
        if (visited.contains(iArgs)) {
            return "...recursive...";
        }
        if (nesting == 5) {
            return "...nested to deep...";
        }
        visited.add(iArgs);
        ++nesting;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Iterator<IArgs.IBinding> iterator = iArgs.bindings();
            while (iterator.hasNext()) {
                Object object;
                IArgs.IBinding iBinding = iterator.next();
                if (!iBinding.isDefined()) {
                    ArgTools.toStringUndefined(string, stringBuilder, iBinding.getName());
                } else if (iBinding.getName() != null) {
                    object = iBinding.getValue();
                    if (object instanceof IArgs) {
                        ArgTools.toStringArgs(string, stringBuilder, iBinding.getName(), (IArgs)object);
                    } else {
                        ArgTools.toStringPlain(string, stringBuilder, iBinding.getName(), object);
                    }
                } else {
                    object = iBinding.getValue();
                    if (object instanceof IArgs) {
                        ArgTools.toStringArgs(string, stringBuilder, "" + n, (IArgs)object);
                    } else {
                        ArgTools.toStringPlain(string, stringBuilder, "" + n, object);
                    }
                }
                ++n;
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            if (--nesting == 0) {
                visited = null;
            }
        }
    }

    protected static void toStringArgs(String string, StringBuilder stringBuilder, String string2, IArgs iArgs) {
        int n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append(string2);
        stringBuilder.append(" = ");
        stringBuilder.append("{");
        stringBuilder.append("\n");
        stringBuilder.append(ArgTools.toString(iArgs, string));
        stringBuilder.append("\n");
        n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append("}");
        stringBuilder.append("\n");
    }

    protected static void toStringPlain(String string, StringBuilder stringBuilder, String string2, Object object) {
        int n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append(string2);
        stringBuilder.append(" = ");
        stringBuilder.append(StringTools.safeString(object));
        stringBuilder.append("\n");
    }

    protected static void toStringUndefined(String string, StringBuilder stringBuilder, String string2) {
        int n = 1;
        while (n < nesting) {
            stringBuilder.append("   ");
            ++n;
        }
        stringBuilder.append(string2);
        stringBuilder.append(" = UNDEFINED");
        stringBuilder.append("\n");
    }

    public static void visitNamedBindings(String string, IArgs iArgs, IBindingProcessor iBindingProcessor) {
        iBindingProcessor.visitArgs(string, iArgs);
        Iterator<IArgs.IBinding> iterator = iArgs.bindings();
        while (iterator.hasNext()) {
            IArgs.IBinding iBinding = iterator.next();
            String string2 = iBinding.getName();
            if (string2 == null) continue;
            Object object = iBinding.getValue();
            if (object instanceof IArgs) {
                ArgTools.visitNamedBindings(StringTools.pathAppend(string, ".", string2), (IArgs)object, iBindingProcessor);
                continue;
            }
            iBindingProcessor.visitBinding(string, iArgs, iBinding);
        }
    }

    public static interface IBindingProcessor {
        public Object visitArgs(String var1, IArgs var2);

        public Object visitBinding(String var1, IArgs var2, IArgs.IBinding var3);
    }
}

