/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.logging.IDumpObject;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CommonDumpObject
implements IDumpObject {
    @Override
    public List<String> dump(String string, Object object, IDumpObject iDumpObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            String string2 = byArray.length > 50 ? String.valueOf(HexTools.bytesToHexString(byArray, 0, 49)) + "..." : HexTools.bytesToHexString(byArray);
            arrayList.add(String.valueOf(string) + "byte[" + byArray.length + "] " + string2);
        } else if (object instanceof char[]) {
            arrayList.add(String.valueOf(string) + "a character array");
        } else if (object instanceof IValueHolder) {
            IValueHolder iValueHolder = (IValueHolder)object;
            List<String> list = iDumpObject.dump("", iValueHolder.get(), iDumpObject);
            Iterator<String> iterator = list.iterator();
            arrayList.add(String.valueOf(string) + "a reference to " + iterator.next());
            while (iterator.hasNext()) {
                arrayList.add(String.valueOf(string) + iterator.next());
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            arrayList.add(String.valueOf(string) + "[");
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                arrayList.addAll(iDumpObject.dump(String.valueOf(string) + "    ", object2, iDumpObject));
                ++n2;
            }
            arrayList.add(String.valueOf(string) + "]");
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            arrayList.add(String.valueOf(string) + Arrays.toString(nArray));
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            arrayList.add(String.valueOf(string) + n + " | 0x" + Integer.toHexString(n));
        } else if (object instanceof Byte) {
            byte by = (Byte)object;
            arrayList.add(String.valueOf(string) + by + " | 0x" + Integer.toHexString(by));
        } else {
            arrayList.add(String.valueOf(string) + StringTools.safeString(object));
        }
        return arrayList;
    }
}

