/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class ThreadFilter
implements Filter {
    private ThreadLocal<Integer> threadActivation = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public ThreadFilter(boolean bl) {
        if (bl) {
            this.activate();
        }
    }

    public boolean activate() {
        int n = this.threadActivation.get();
        this.threadActivation.set(n + 1);
        return n == 0;
    }

    public boolean deactivate() {
        int n = this.threadActivation.get();
        this.threadActivation.set(n - 1);
        return n == 1;
    }

    public boolean isActive() {
        return this.threadActivation.get() > 0;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return this.threadActivation.get() > 0;
    }
}

