/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NumberList
extends NumberWrapper {
    public static char SEPARATOR = (char)59;
    public static char SEPARATOR_ALT = (char)44;
    private List list = new ArrayList();

    @Override
    public boolean add(Object object) {
        if (object instanceof NumberWrapper) {
            this.getList().add(object);
            return true;
        }
        if (object instanceof Number) {
            this.getList().add(new NumberInstance((Number)object));
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        for (Object e : collection) {
            if (this.add(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (NumberWrapper numberWrapper : this.getList()) {
            if (!numberWrapper.contains(object)) continue;
            return true;
        }
        return false;
    }

    public List getList() {
        return this.list;
    }

    @Override
    protected double getMax() {
        double d = Double.MIN_VALUE;
        for (NumberWrapper numberWrapper : this.getList()) {
            if (!(numberWrapper.getMax() < d)) continue;
            d = numberWrapper.getMax();
        }
        return d;
    }

    @Override
    protected double getMin() {
        double d = Double.MAX_VALUE;
        for (NumberWrapper numberWrapper : this.getList()) {
            if (!(numberWrapper.getMin() < d)) continue;
            d = numberWrapper.getMin();
        }
        return d;
    }

    @Override
    public NumberWrapper increment(int n) {
        for (NumberWrapper numberWrapper : this.getList()) {
            numberWrapper.increment(n);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.getList().isEmpty()) {
            return true;
        }
        for (NumberWrapper numberWrapper : this.getList()) {
            if (numberWrapper.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator iterator() {
        return new NestedIterator(this.getList().iterator());
    }

    public void setList(List list) {
        this.list = list;
    }

    @Override
    public int size() {
        int n = 0;
        for (NumberWrapper numberWrapper : this.getList()) {
            n += numberWrapper.size();
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Number[this.size()];
        Iterator iterator = this.getList().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NumberWrapper numberWrapper = (NumberWrapper)iterator.next();
            Number[] numberArray = (Number[])numberWrapper.toArray();
            int n2 = 0;
            while (n2 < numberArray.length) {
                objectArray[n] = numberArray[n2];
                ++n;
                ++n2;
            }
        }
        return objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.getList().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(SEPARATOR);
        }
        return stringBuilder.toString();
    }
}

