/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Converter {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static boolean asBoolean(String string) throws ConverterException {
        if ((string = string.toLowerCase().trim()).equals("false") || string.equals("f") || string.equals("no") || string.equals("n") || string.equals("0") || string.equals("falsch") || string.equals("nein")) {
            return false;
        }
        if (string.equals("true") || string.equals("t") || string.equals("yes") || string.equals("y") || string.equals("1") || string.equals("wahr") || string.equals("w") || string.equals("ja") || string.equals("j")) {
            return true;
        }
        throw new ConverterException("Can't parse boolean string: " + string + " to a legal value");
    }

    public static boolean asBoolean(String string, boolean bl) {
        if (StringTools.isEmpty(string)) {
            return bl;
        }
        try {
            return Converter.asBoolean(string);
        }
        catch (ConverterException converterException) {
            return bl;
        }
    }

    public static boolean asBooleanChecked(String string, boolean bl) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return bl;
        }
        return Converter.asBoolean(string);
    }

    public static byte[] asBytes(String string) throws ConverterException {
        if (string.startsWith("[a]")) {
            try {
                return string.substring(3).getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ConverterException(unsupportedEncodingException);
            }
        }
        if (string.startsWith("[x]")) {
            return HexTools.hexStringToBytes(string.substring(3));
        }
        if (string.startsWith("[@]")) {
            return Base64.decode(string.substring(3));
        }
        return HexTools.hexStringToBytes(string);
    }

    public static double asDouble(String string) throws ConverterException {
        try {
            string = string.trim();
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse number string: " + string + " to a legal value");
        }
    }

    public static double asDouble(String string, double d) {
        if (StringTools.isEmpty(string)) {
            return d;
        }
        try {
            return Converter.asDouble(string);
        }
        catch (ConverterException converterException) {
            return d;
        }
    }

    public static double asDoubleChecked(String string, double d) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return d;
        }
        return Converter.asDouble(string);
    }

    public static File asFile(String string) throws ConverterException {
        String string2 = string.trim();
        if ((string2 = FileTools.trimPath(string2)).equals("")) {
            throw new ConverterException("Parameter " + string + " is not a valid Filename");
        }
        try {
            return new File(string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ConverterException("Can't parse file string: " + string2 + " to a file");
        }
    }

    public static float asFloat(String string) throws ConverterException {
        try {
            string = string.trim();
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse number string: " + string + " to a legal value");
        }
    }

    public static float asFloat(String string, float f) {
        if (StringTools.isEmpty(string)) {
            return f;
        }
        try {
            return Converter.asFloat(string);
        }
        catch (ConverterException converterException) {
            return f;
        }
    }

    public static float[] asFloatArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                fArray[n] = Float.parseFloat(string2.trim());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return fArray;
    }

    public static float asFloatChecked(String string, float f) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return f;
        }
        return Converter.asFloat(string);
    }

    public static int[] asIntArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ELEMENT_SEPARATOR, false);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n] = Integer.parseInt(string2.trim());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public static int asInteger(String string) throws ConverterException {
        try {
            string = string.trim();
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse integer string: " + string + " to a legal value");
        }
    }

    public static int asInteger(String string, int n) {
        if (StringTools.isEmpty(string)) {
            return n;
        }
        try {
            return Converter.asInteger(string);
        }
        catch (ConverterException converterException) {
            return n;
        }
    }

    public static int asIntegerChecked(String string, int n) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return n;
        }
        return Converter.asInteger(string);
    }

    public static List<String> asList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringReader stringReader = new StringReader(string);
        try {
            String string2;
            while ((string2 = ReaderTools.readToken(stringReader, ';')) != null) {
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public static long asLong(String string) throws ConverterException {
        try {
            string = string.trim();
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException("Can't parse integer string: " + string + " to a legal value");
        }
    }

    public static long asLong(String string, long l) {
        if (StringTools.isEmpty(string)) {
            return l;
        }
        try {
            return Converter.asLong(string);
        }
        catch (ConverterException converterException) {
            return l;
        }
    }

    public static long asLongChecked(String string, long l) throws ConverterException {
        if (StringTools.isEmpty(string)) {
            return l;
        }
        return Converter.asLong(string);
    }

    public static Map<String, String> asMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        if (StringTools.isEmpty(string)) {
            return hashMap;
        }
        StringReader stringReader = new StringReader(string);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(stringReader, ';')) != null) {
                if (entry.getKey() == null) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashMap;
    }

    public static Map<String, Boolean> asMapBoolean(String string) {
        Map<String, String> map = Converter.asMap(string);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(map.size() * 2);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Boolean bl = Boolean.valueOf(entry.getValue());
            hashMap.put(entry.getKey(), bl);
        }
        return hashMap;
    }

    public static String asString(String string, String string2) {
        if (StringTools.isEmpty(string)) {
            return string2;
        }
        return string.trim();
    }

    public static String[] asStringArray(String string) {
        if (string == null) {
            return null;
        }
        return string.split(ELEMENT_SEPARATOR);
    }

    public static Boolean asThreeState(String string) throws ConverterException {
        if ((string = string.toLowerCase().trim()).equals("false") || string.equals("f") || string.equals("no") || string.equals("n") || string.equals("0") || string.equals("falsch") || string.equals("nein")) {
            return Boolean.FALSE;
        }
        if (string.equals("true") || string.equals("t") || string.equals("yes") || string.equals("y") || string.equals("1") || string.equals("wahr") || string.equals("w") || string.equals("ja") || string.equals("j")) {
            return Boolean.TRUE;
        }
        if (string.equals("undeterminate") || string.equals("undefined") || string.equals("?") || string.equals("u")) {
            return null;
        }
        throw new ConverterException("Can't parse boolean string: " + string + " to a legal value");
    }

    public static Boolean asThreeState(String string, Boolean bl) {
        if (StringTools.isEmpty(string)) {
            return bl;
        }
        try {
            return Converter.asBoolean(string);
        }
        catch (ConverterException converterException) {
            return bl;
        }
    }

    private Converter() {
    }
}

