/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.IResource;
import de.intarsys.tools.transaction.IResourceType;
import de.intarsys.tools.transaction.ITransaction;
import de.intarsys.tools.transaction.PACKAGE;
import de.intarsys.tools.transaction.ResourceException;
import de.intarsys.tools.transaction.SubTransaction;
import de.intarsys.tools.transaction.TransactionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Transaction
implements ITransaction,
Serializable {
    private static int ID_COUNTER = 0;
    private static Logger Log = PACKAGE.Log;
    private final List children = new ArrayList();
    private final String id = String.valueOf(ID_COUNTER++);
    private final List<IResource> resources = new ArrayList<IResource>();

    protected Transaction() {
    }

    protected void addTransaction(Transaction transaction) {
        this.children.add(transaction);
    }

    @Override
    public void commit() throws TransactionException {
        ArrayList arrayList = new ArrayList(this.children);
        for (Transaction transaction : arrayList) {
            transaction.commit();
        }
        this.commitResources();
        this.stop();
    }

    protected void commitResources() throws TransactionException {
        for (IResource iResource : this.resources) {
            try {
                iResource.commit();
            }
            catch (ResourceException resourceException) {
                throw new TransactionException(resourceException);
            }
        }
    }

    @Override
    public void commitResume() throws TransactionException {
        ArrayList arrayList = new ArrayList(this.children);
        for (Transaction transaction : arrayList) {
            transaction.commitResume();
        }
        this.commitResources();
    }

    protected Transaction createTransaction() {
        return new SubTransaction(this);
    }

    public void delist(IResource iResource) throws TransactionException {
        if (!this.resources.remove(iResource)) {
            throw new TransactionException("resource not listed");
        }
        try {
            iResource.rollback();
        }
        catch (ResourceException resourceException) {
            throw new TransactionException(resourceException);
        }
    }

    public void enlist(IResource iResource) throws TransactionException {
        try {
            iResource.begin();
        }
        catch (ResourceException resourceException) {
            throw new TransactionException(resourceException);
        }
        this.resources.add(iResource);
    }

    public String getId() {
        return this.id;
    }

    protected <T extends IResource> T getResource(IResourceType<T> iResourceType) {
        for (IResource iResource : this.resources) {
            if (iResource.getType() != iResourceType) continue;
            return (T)iResource;
        }
        return null;
    }

    protected void removeTransaction(Transaction transaction) {
        this.children.remove(transaction);
    }

    protected void resume() {
        if (this.getParent() != null) {
            ((Transaction)this.getParent()).resume();
        }
        for (IResource iResource : this.resources) {
            iResource.resume();
        }
        Log.log(Level.FINE, "transaction[" + this.getId() + "] resumed");
    }

    @Override
    public void rollback() throws TransactionException {
        ArrayList arrayList = new ArrayList(this.children);
        for (Transaction transaction : arrayList) {
            transaction.rollback();
        }
        this.rollbackResources();
        this.stop();
    }

    protected void rollbackResources() throws TransactionException {
        for (IResource iResource : this.resources) {
            try {
                iResource.rollback();
            }
            catch (ResourceException resourceException) {
                throw new TransactionException(resourceException);
            }
        }
    }

    @Override
    public void rollbackResume() throws TransactionException {
        ArrayList arrayList = new ArrayList(this.children);
        for (Transaction transaction : arrayList) {
            transaction.rollbackResume();
        }
        this.rollbackResources();
    }

    protected void start() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] started");
    }

    protected void stop() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] stopped");
    }

    protected void suspend() {
        Log.log(Level.FINE, "transaction[" + this.getId() + "] suspended");
        ArrayList arrayList = new ArrayList(this.children);
        for (Transaction object : arrayList) {
            object.suspend();
        }
        for (IResource iResource : this.resources) {
            iResource.suspend();
        }
    }
}

