/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.url;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class URLEncodingTools {
    public static final String CHARSET_DEFAULT = "ISO_8859_1";

    protected static String decode(String string, String string2) throws UnsupportedEncodingException {
        return URLDecoder.decode(string, string2 != null ? string2 : CHARSET_DEFAULT);
    }

    public static Map<String, String> decodeEntity(String string, String string2) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter("&");
        while (scanner.hasNext()) {
            String[] stringArray = scanner.next().split("=");
            if (stringArray.length == 0 || stringArray.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String string3 = URLEncodingTools.decode(stringArray[0], string2);
            String string4 = "";
            if (stringArray.length == 2) {
                string4 = URLEncodingTools.decode(stringArray[1], string2);
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    protected static String encode(String string, String string2) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, string2 != null ? string2 : CHARSET_DEFAULT);
    }

    public static String encodeEntity(Map<String, String> map, String string) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2;
            String string3 = URLEncodingTools.encode(entry.getKey(), string);
            String string4 = entry.getValue();
            String string5 = string2 = string4 != null ? URLEncodingTools.encode(string4, string) : "";
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(string3);
            stringBuilder.append("=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

