/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.freetype;

import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.FreetypeException;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.PACKAGE;
import de.intarsys.cwt.freetype.SfntName;
import de.intarsys.cwt.freetype.nativec.FTBBox;
import de.intarsys.cwt.freetype.nativec.FTCharMap;
import de.intarsys.cwt.freetype.nativec.FTEnum;
import de.intarsys.cwt.freetype.nativec.FTFace;
import de.intarsys.cwt.freetype.nativec.FTSfntName;
import de.intarsys.cwt.freetype.nativec._FTNI;
import de.intarsys.nativec.type.NativeBuffer;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Face {
    private static final Logger Log = PACKAGE.Log;
    private final FTFace face;
    private final NativeBuffer fontData;
    private final _FTNI ftni;
    private CharMap cachedCharMap = null;

    protected Face(_FTNI _FTNI2, FTFace fTFace, NativeBuffer nativeBuffer) {
        this.ftni = _FTNI2;
        this.face = fTFace;
        this.fontData = nativeBuffer;
    }

    public void clearCache() {
        this.cachedCharMap = null;
    }

    public void doneFace() {
        int n = this.ftni.DoneFace(this.face);
        if (n != 0) {
            Log.log(Level.WARNING, "error " + n + " in DoneFace");
        }
    }

    public int getAscender() {
        return this.face.getAscender();
    }

    public Rectangle2D getBBox() {
        FTBBox fTBBox = this.face.getBBox();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.x = fTBBox.getMinX();
        float_.y = fTBBox.getMinY();
        float_.width = fTBBox.getMaxX() - fTBBox.getMinX();
        float_.height = fTBBox.getMaxY() - fTBBox.getMinY();
        return float_;
    }

    public int getCharIndex(int n) {
        return this.ftni.GetCharIndex(this.face, n);
    }

    public CharMap getCharMap() {
        if (this.cachedCharMap == null) {
            this.cachedCharMap = CharMap.create(this.ftni, this.face.getCharMap());
        }
        return this.cachedCharMap;
    }

    public CharMap getCharMap(int n) {
        return new CharMap(this.ftni, (FTCharMap)((Object)this.face.getCharMaps().getValue(n)));
    }

    public int getDescender() {
        return this.face.getDescender();
    }

    public FTFace getFace() {
        return this.face;
    }

    public String getFamilyName() {
        return this.face.getFamilyName();
    }

    public int getFirstChar() {
        return this.ftni.GetFirstChar(this.face);
    }

    public NativeBuffer getFontData() {
        return this.fontData;
    }

    public GlyphSlot getGlyphSlot() {
        return new GlyphSlot(this.ftni, this.face.getGlyphSlot());
    }

    public int getHeight() {
        return this.face.getHeight();
    }

    public int getNameIndex(String string) {
        return this.ftni.GetNameIndex(this.face, string);
    }

    public int getNumCharMaps() {
        return this.face.getNumCharMaps();
    }

    public String getPostscriptName() {
        return this.ftni.GetPostscriptName(this.face);
    }

    public SfntName getSfntName(int n) {
        FTSfntName fTSfntName = new FTSfntName();
        int n2 = this.ftni.GetSfntName(this.face, n, fTSfntName);
        if (n2 != 0) {
            return null;
        }
        return new SfntName(this.ftni, fTSfntName);
    }

    public int getSfntNameCount() {
        return this.ftni.GetSfntNameCount(this.face);
    }

    public String getStyleName() {
        return this.face.getStyleName();
    }

    public int getUnderlinePosition() {
        return this.face.getUnderlinePosition();
    }

    public int getUnderlineThickness() {
        return this.face.getUnderlineThickness();
    }

    public int getUnitsPerEM() {
        return this.face.getUnitsPerEM();
    }

    public void loadChar(int n, int n2) throws FreetypeException {
        int n3 = this.ftni.LoadChar(this.face, n, n2);
        if (n3 != 0) {
            throw new FreetypeException();
        }
    }

    public void loadGlyph(int n, int n2) throws FreetypeException {
        int n3 = this.ftni.LoadGlyph(this.face, n, n2);
        if (n3 != 0) {
            throw new FreetypeException();
        }
    }

    public void selectCharMap(FTEnum fTEnum) throws FreetypeException {
        int n = this.ftni.SelectCharMap(this.face, fTEnum);
        if (n != 0) {
            throw new FreetypeException();
        }
    }

    public void setCharMap(CharMap charMap) {
        this.ftni.SetCharMap(this.face, charMap.getCharMap());
        this.clearCache();
    }

    public void setCharSize(int n, int n2, int n3, int n4) {
        this.ftni.SetCharSize(this.face, n, n2, n3, n4);
    }
}

