/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class COSArray
extends COSCompositeObject {
    private final List objects;

    public static COSArray create() {
        return new COSArray();
    }

    public static COSArray create(int n) {
        return new COSArray(n);
    }

    public static COSArray createWith(float f, float f2, float f3, float f4) {
        COSArray cOSArray = new COSArray(4);
        cOSArray.basicAddSilent(COSFixed.create(f));
        cOSArray.basicAddSilent(COSFixed.create(f2));
        cOSArray.basicAddSilent(COSFixed.create(f3));
        cOSArray.basicAddSilent(COSFixed.create(f4));
        return cOSArray;
    }

    public static COSArray createWith(float f, float f2, float f3, float f4, float f5, float f6) {
        COSArray cOSArray = new COSArray(6);
        cOSArray.basicAddSilent(COSFixed.create(f));
        cOSArray.basicAddSilent(COSFixed.create(f2));
        cOSArray.basicAddSilent(COSFixed.create(f3));
        cOSArray.basicAddSilent(COSFixed.create(f4));
        cOSArray.basicAddSilent(COSFixed.create(f5));
        cOSArray.basicAddSilent(COSFixed.create(f6));
        return cOSArray;
    }

    protected COSArray() {
        this.objects = new ArrayList();
    }

    protected COSArray(int n) {
        this.objects = new ArrayList(n);
    }

    protected COSArray(List list) {
        this.objects = list;
    }

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromArray(this);
    }

    public COSArray add(COSObject cOSObject) {
        this.willChange(this);
        this.basicAddPropagate(cOSObject);
        if (this.objectListeners != null) {
            this.triggerChanged(this.objects.size(), COSNull.NULL, cOSObject);
        }
        return this;
    }

    public COSArray add(int n, COSObject cOSObject) {
        this.willChange(this);
        this.basicAddPropagate(n, cOSObject);
        if (this.objectListeners != null) {
            this.triggerChanged(n, COSNull.NULL, cOSObject);
        }
        return this;
    }

    @Override
    public COSArray asArray() {
        return this;
    }

    protected COSArray basicAddPropagate(COSDocumentElement cOSDocumentElement) {
        COSObject cOSObject = cOSDocumentElement.dereference();
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement2.addContainer(this);
        this.objects.add(cOSDocumentElement2);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        return this;
    }

    protected COSArray basicAddPropagate(int n, COSDocumentElement cOSDocumentElement) {
        COSObject cOSObject = cOSDocumentElement.dereference();
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement2.addContainer(this);
        this.objects.add(n, cOSDocumentElement2);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        return this;
    }

    public COSArray basicAddSilent(COSDocumentElement cOSDocumentElement) {
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        cOSDocumentElement2.addContainer(this);
        this.objects.add(cOSDocumentElement2);
        return this;
    }

    protected void basicClearPropagate() {
        ArrayList arrayList = new ArrayList(this.objects);
        this.objects.clear();
        for (COSDocumentElement cOSDocumentElement : arrayList) {
            COSObject cOSObject = cOSDocumentElement.dereference();
            this.willChange(cOSObject);
            ICOSContainer iCOSContainer = cOSDocumentElement.removeContainer(this);
            cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        }
    }

    public COSDocumentElement basicGet(int n) {
        return (COSDocumentElement)this.objects.get(n);
    }

    protected int basicIndexOf(COSDocumentElement cOSDocumentElement) {
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        int n = 0;
        Iterator iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement3 = (COSDocumentElement)iterator.next();
            if (cOSDocumentElement2 == cOSDocumentElement3) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Iterator basicIterator() {
        return this.objects.iterator();
    }

    protected boolean basicRemovePropagate(COSDocumentElement cOSDocumentElement) {
        COSObject cOSObject = cOSDocumentElement.dereference();
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        Iterator iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement3 = (COSDocumentElement)iterator.next();
            if (cOSDocumentElement2 != cOSDocumentElement3) continue;
            iterator.remove();
            this.willChange(cOSObject);
            ICOSContainer iCOSContainer = cOSDocumentElement2.removeContainer(this);
            cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
            return true;
        }
        return false;
    }

    protected COSDocumentElement basicRemovePropagate(int n) {
        COSDocumentElement cOSDocumentElement = (COSDocumentElement)this.objects.remove(n);
        COSObject cOSObject = cOSDocumentElement.dereference();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement.removeContainer(this);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        return cOSDocumentElement;
    }

    protected COSDocumentElement basicSetPropagate(int n, COSDocumentElement cOSDocumentElement) {
        COSObject cOSObject = cOSDocumentElement.dereference();
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement2.addContainer(this);
        COSDocumentElement cOSDocumentElement3 = this.objects.set(n, cOSDocumentElement2);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        if (cOSDocumentElement3 != cOSDocumentElement2) {
            COSObject cOSObject2 = cOSDocumentElement3.dereference();
            this.willChange(cOSObject2);
            iCOSContainer = cOSDocumentElement3.removeContainer(this);
            cOSObject2.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        }
        return cOSDocumentElement3;
    }

    @Override
    protected String basicToString() {
        return this.objects.toString();
    }

    public void clear() {
        this.willChange(this);
        this.basicClearPropagate();
        if (this.objectListeners != null) {
            this.triggerChanged(-1, null, null);
        }
    }

    @Override
    protected COSObject copyBasic() {
        return COSArray.create(this.size());
    }

    @Override
    public COSObject copyDeep(Map map) {
        COSArray cOSArray = (COSArray)super.copyDeep(map);
        Iterator iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)iterator.next();
            COSObject cOSObject = cOSDocumentElement.copyDeep(map);
            cOSArray.basicAddSilent(cOSObject);
        }
        return cOSArray;
    }

    @Override
    public COSObject copyShallow() {
        COSArray cOSArray = (COSArray)super.copyShallow();
        Iterator iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)iterator.next();
            cOSArray.basicAddSilent(cOSDocumentElement.copyShallowNested());
        }
        return cOSArray;
    }

    @Override
    protected COSObject copySubGraph(Map map) {
        COSArray cOSArray = (COSArray)super.copySubGraph(map);
        return cOSArray;
    }

    public boolean equals(Object object) {
        return this.equals(object, new HashSet());
    }

    @Override
    protected boolean equals(Object object, Set set) {
        if (this.isIndirect()) {
            if (set.contains(this.getIndirectObject())) {
                return true;
            }
            set.add(this.getIndirectObject());
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof COSArray)) {
            return false;
        }
        COSArray cOSArray = (COSArray)object;
        if (this.size() != cOSArray.size()) {
            return false;
        }
        Iterator iterator = this.basicIterator();
        Iterator iterator2 = cOSArray.basicIterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)iterator.next();
            COSObject cOSObject = cOSDocumentElement.dereference();
            COSDocumentElement cOSDocumentElement2 = (COSDocumentElement)iterator2.next();
            COSObject cOSObject2 = cOSDocumentElement2.dereference();
            if (cOSObject == null && cOSObject2 != null) {
                return false;
            }
            if (cOSObject.equals(cOSObject2, set)) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public COSObject get(int n) {
        try {
            return ((COSDocumentElement)this.objects.get(n)).dereference();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return COSNull.NULL;
        }
    }

    public List getObjects() {
        int n = this.size();
        ArrayList<COSObject> arrayList = new ArrayList<COSObject>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.get(n2));
            ++n2;
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 17;
        Iterator iterator = this.basicIterator();
        while (iterator.hasNext()) {
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)iterator.next();
            n = cOSDocumentElement.isReference() ? (n + cOSDocumentElement.hashCode()) * 34 : (((COSObject)cOSDocumentElement).isPrimitive() ? (n + cOSDocumentElement.hashCode()) * 34 : (n + 17) * 34);
        }
        return n;
    }

    public int indexOf(COSObject cOSObject) {
        return this.basicIndexOf(cOSObject);
    }

    public boolean isEmpty() {
        return this.objects.size() == 0;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int index = 0;
            private int size;
            {
                this.size = COSArray.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            public Object next() {
                return COSArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject cOSObject) {
        COSIndirectObject cOSIndirectObject = super.referenceIndirect(cOSObject);
        int n = this.getObjects().indexOf(cOSObject);
        if (n >= 0) {
            this.objects.set(n, cOSIndirectObject);
        }
        return cOSIndirectObject;
    }

    public boolean remove(COSObject cOSObject) {
        this.willChange(this);
        boolean bl = this.basicRemovePropagate(cOSObject);
        if (this.objectListeners != null && bl) {
            this.triggerChanged(-1, cOSObject, COSNull.NULL);
        }
        return bl;
    }

    public COSObject remove(int n) {
        this.willChange(this);
        COSDocumentElement cOSDocumentElement = this.basicRemovePropagate(n);
        COSObject cOSObject = cOSDocumentElement.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(n, cOSObject, COSNull.NULL);
        }
        return cOSObject;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        this.objects.clear();
        this.objects.addAll(((COSArray)object).objects);
        if (this.objectListeners != null) {
            this.triggerChanged(-1, null, null);
        }
    }

    public Object saveState() {
        COSArray cOSArray = new COSArray(new ArrayList(this.objects));
        cOSArray.container = this.container.saveStateContainer();
        return cOSArray;
    }

    public COSObject set(int n, COSObject cOSObject) {
        this.willChange(this);
        COSDocumentElement cOSDocumentElement = this.basicSetPropagate(n, cOSObject);
        COSObject cOSObject2 = cOSDocumentElement.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(n, cOSObject2, cOSObject);
        }
        return cOSObject2;
    }

    public int size() {
        return this.objects.size();
    }

    public COSDocumentElement[] toArray() {
        return this.objects.toArray(new COSDocumentElement[this.objects.size()]);
    }

    protected void triggerChanged(int n, COSObject cOSObject, COSObject cOSObject2) {
        if (this.objectListeners == null) {
            return;
        }
        Integer n2 = new Integer(n);
        for (ICOSObjectListener iCOSObjectListener : this.objectListeners) {
            iCOSObjectListener.changed(this, n2, cOSObject, cOSObject2);
        }
    }
}

