/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.AbstractCryptHandler;
import de.intarsys.pdf.crypt.COSSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;

public abstract class StandardCryptHandler
extends AbstractCryptHandler {
    protected Cipher cipher;
    protected MessageDigest md;
    private byte[] generationBytes = new byte[2];
    private byte[] objectBytes = new byte[3];
    private byte[] cryptKey;
    protected int length;

    protected abstract byte[] basicDecrypt(byte[] var1, byte[] var2, int var3, int var4) throws COSSecurityException;

    protected abstract byte[] basicEncrypt(byte[] var1, byte[] var2, int var3, int var4) throws COSSecurityException;

    protected void updateHash(byte[] byArray, int n, int n2) {
        this.md.reset();
        this.md.update(byArray);
        this.objectBytes[0] = (byte)(n & 0xFF);
        this.objectBytes[1] = (byte)((n >>= 8) & 0xFF);
        this.objectBytes[2] = (byte)((n >>= 8) & 0xFF);
        this.md.update(this.objectBytes);
        this.generationBytes[0] = (byte)(n2 & 0xFF);
        this.generationBytes[1] = (byte)((n2 >>= 8) & 0xFF);
        this.md.update(this.generationBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        if (byArray == null) {
            return null;
        }
        if (cOSObjectKey == null) {
            return byArray;
        }
        StandardCryptHandler standardCryptHandler = this;
        synchronized (standardCryptHandler) {
            return this.basicDecrypt(byArray, this.getCryptKey(), cOSObjectKey.getObjectNumber(), cOSObjectKey.getGenerationNumber());
        }
    }

    public void initialize(byte[] byArray) throws COSSecurityException {
        this.cryptKey = byArray;
        this.length = this.cryptKey.length + 5;
        if (this.length > 16) {
            this.length = 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        if (byArray == null) {
            return null;
        }
        if (cOSObjectKey == null) {
            return byArray;
        }
        StandardCryptHandler standardCryptHandler = this;
        synchronized (standardCryptHandler) {
            return this.basicEncrypt(byArray, this.getCryptKey(), cOSObjectKey.getObjectNumber(), cOSObjectKey.getGenerationNumber());
        }
    }

    protected byte[] getCryptKey() {
        return this.cryptKey;
    }
}

