/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.GlyphNameMap;
import java.util.HashMap;
import java.util.Map;

public class MappedEncoding
extends Encoding {
    private static final int ARRAY_MAPPING_SIZE = 256;
    private Map indexedEncoding = new HashMap();
    private Map namedEncoding = new HashMap();
    private int[] fastEncoding = new int[256];
    private int[] indexDecoding = new int[256];
    private String[] nameDecoding = new String[256];

    public MappedEncoding() {
        int n = 0;
        while (n < 256) {
            this.fastEncoding[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.indexDecoding.length) {
            this.indexDecoding[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.nameDecoding.length) {
            this.nameDecoding[n] = ".notdef";
            ++n;
        }
    }

    public void addEncoding(int n, String string) {
        int n2 = GlyphNameMap.Standard.getUnicode(string);
        this.defineEntry(n, n2, string);
    }

    public void addEncoding(int n, String string, int n2) {
        this.defineEntry(n, n2, string);
    }

    @Override
    public COSObject cosGetObject() {
        return null;
    }

    protected void defineEntry(int n, int n2, String string) {
        this.nameDecoding[n] = string;
        Integer n3 = new Integer(n);
        this.namedEncoding.put(string, n3);
        this.indexDecoding[n] = n2;
        this.indexedEncoding.put(new Integer(n2), n3);
        if (n2 >= 0 && n2 < 256) {
            this.fastEncoding[n2] = n;
        }
    }

    @Override
    public int getDecoded(int n) {
        return this.indexDecoding[n];
    }

    @Override
    public int getEncoded(int n) {
        if (n >= 0 && n < 256) {
            return this.fastEncoding[n];
        }
        Integer n2 = (Integer)this.indexedEncoding.get(new Integer(n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    @Override
    public int getEncoded(String string) {
        Integer n = (Integer)this.namedEncoding.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public String getGlyphName(int n) {
        if (n < 0 || n > 255) {
            return ".notdef";
        }
        return this.nameDecoding[n];
    }

    protected int[] getIndexDecoding() {
        return this.indexDecoding;
    }

    protected Map getIndexedEncoding() {
        return this.indexedEncoding;
    }

    @Override
    public String getName() {
        return "MappedEncoding";
    }

    protected String[] getNameDecoding() {
        return this.nameDecoding;
    }

    protected Map getNamedEncoding() {
        return this.namedEncoding;
    }
}

