/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.CIDWidthMapEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CIDWidthMap
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private List entries;

    protected CIDWidthMap(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addWidth(int n, int n2) {
        this.entries.add(new CIDWidthMapEntry(n, n, n2));
        this.cosGetArray().add(COSInteger.create(n));
        this.cosGetArray().add(COSInteger.create(n));
        this.cosGetArray().add(COSInteger.create(n2));
    }

    protected void createMap(COSArray cOSArray) {
        this.entries = new ArrayList();
        if (cOSArray != null) {
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSObject cOSObject;
                int n;
                COSNumber cOSNumber = ((COSObject)iterator.next()).asNumber();
                if (cOSNumber == null || !iterator.hasNext()) break;
                COSObject cOSObject2 = (COSObject)iterator.next();
                int n2 = n = cOSNumber.intValue();
                if (cOSObject2 instanceof COSNumber) {
                    n2 = ((COSNumber)cOSObject2).intValue();
                    if (!iterator.hasNext()) break;
                    cOSObject = (COSObject)iterator.next();
                    int n3 = ((COSNumber)cOSObject).intValue();
                    this.entries.add(new CIDWidthMapEntry(n, n2, n3));
                    continue;
                }
                if (!(cOSObject2 instanceof COSArray)) continue;
                cOSObject = (COSArray)cOSObject2;
                Iterator iterator2 = cOSObject.iterator();
                while (iterator2.hasNext()) {
                    COSNumber cOSNumber2 = ((COSObject)iterator2.next()).asNumber();
                    int n4 = 0;
                    if (cOSNumber2 != null) {
                        n4 = cOSNumber2.intValue();
                    }
                    this.entries.add(new CIDWidthMapEntry(n, n2, n4));
                    ++n;
                    ++n2;
                }
            }
        }
    }

    public int getWidth(int n) {
        for (CIDWidthMapEntry cIDWidthMapEntry : this.entries) {
            if (cIDWidthMapEntry.getStart() > n || cIDWidthMapEntry.getStop() < n) continue;
            return cIDWidthMapEntry.getWidth();
        }
        return -1;
    }

    @Override
    protected void initializeFromCos() {
        super.initializeFromCos();
        this.createMap(this.cosGetArray());
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.entries = new ArrayList();
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new CIDWidthMap(cOSObject);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSArray.create();
        }
    }
}

