/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PDAFButtonField
extends PDAcroFormField {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Opt = COSName.constant("Opt");

    protected PDAFButtonField(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    public COSName cosGetExpectedFieldType() {
        return CN_FT_Btn;
    }

    public COSArray cosGetOptions() {
        return this.cosGetField(DK_Opt).asArray();
    }

    @Override
    public COSObject cosSetValue(COSObject cOSObject) {
        if (this.isCheckbox() || this.isRadio()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            COSArray cOSArray = this.cosGetOptions();
            if (cOSArray != null && cOSObject != null) {
                int n = 0;
                while (n < cOSArray.size()) {
                    COSString cOSString = cOSArray.get(n).asString();
                    if (cOSString != null && cOSString.stringValue().equals(cOSObject.stringValue())) {
                        Object object = COSName.create(String.valueOf(n));
                        arrayList.add(object);
                    }
                    ++n;
                }
            }
            if (arrayList.isEmpty()) {
                if (cOSObject instanceof COSName) {
                    arrayList.add((COSName)cOSObject);
                } else if (cOSObject == null) {
                    arrayList.add(PDWidgetAnnotation.CN_State_Off);
                } else {
                    arrayList.add(COSName.create(cOSObject.stringValue()));
                }
            }
            COSName cOSName = PDWidgetAnnotation.CN_State_Off;
            for (Object object : this.getAnnotations()) {
                COSObject cOSObject2 = null;
                Set set = ((PDAnnotation)object).getAppearanceStates();
                for (COSName cOSName2 : arrayList) {
                    if (!set.contains(cOSName2)) continue;
                    cOSObject2 = cOSName2;
                    break;
                }
                if (cOSObject2 == null) {
                    ((PDAnnotation)object).setAppearanceState(PDWidgetAnnotation.CN_State_Off);
                    continue;
                }
                ((PDAnnotation)object).setAppearanceState((COSName)cOSObject2.copyOptional());
                cOSName = (COSName)cOSObject2.copyOptional();
            }
            return super.cosSetValue(cOSName);
        }
        return COSNull.NULL;
    }

    public Set getAvailableButtonAppearanceStates() {
        HashSet hashSet = new HashSet();
        for (PDAnnotation pDAnnotation : this.getAnnotations()) {
            hashSet.addAll(pDAnnotation.getAppearanceStates());
        }
        return hashSet;
    }

    public Set getAvailableButtonAppearanceStatesNoOff() {
        Set set = this.getAvailableButtonAppearanceStates();
        COSName cOSName = COSName.create("Off");
        set.remove(cOSName);
        return set;
    }

    public boolean isCheckbox() {
        return !this.isPushbutton() && !this.isRadio();
    }

    public boolean isChecked() {
        if (this.isCheckbox()) {
            return !PDWidgetAnnotation.CN_State_Off.equals(this.getAnyAnnotation().getAppearanceState());
        }
        return false;
    }

    public boolean isPushbutton() {
        return this.getFieldFlags().isPushbutton();
    }

    public boolean isRadio() {
        return this.getFieldFlags().isRadio();
    }

    @Override
    public boolean isTypeBtn() {
        return true;
    }

    @Override
    public void reset() {
        COSObject cOSObject = this.cosGetDefaultValue();
        cOSObject = cOSObject.isNull() ? COSString.create("") : cOSObject.copyOptional();
        this.cosSetValue(cOSObject);
    }

    protected COSName setButtonAppearanceState(PDAnnotation pDAnnotation, String string) {
        COSName cOSName = COSName.create(string);
        Set set = pDAnnotation.getAppearanceStates();
        if (!set.contains(cOSName)) {
            COSName cOSName2;
            cOSName = cOSName2 = COSName.create("Off");
            if ((string = string.toLowerCase().trim()).equals("1") || string.startsWith("t") || string.startsWith("y") || string.startsWith("w") || string.startsWith("j") || string.startsWith("x")) {
                for (COSName cOSName3 : set) {
                    if (cOSName3.equals(cOSName2)) continue;
                    cOSName = (COSName)cOSName3.copyOptional();
                    break;
                }
            }
        }
        pDAnnotation.setAppearanceState(cOSName);
        return cOSName;
    }

    public void setPushbutton(boolean bl) {
        this.getFieldFlags().setPushbutton(bl);
    }

    @Override
    public void setValueString(String string) {
        if (string == null) {
            super.setValueString(string);
        }
        if (this.isCheckbox() || this.isRadio()) {
            if (string == null) {
                this.cosSetValue(null);
            } else {
                COSName cOSName = COSName.create(string);
                this.cosSetValue(cOSName);
            }
        }
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDAFButtonField(cOSObject);
        }
    }
}

