/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.BooleanParam;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class ConcatCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Merge together pdf documents.";
    private final List concatOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "pdf output file: if it doesn't exist it's created, if it exists it must be writeable", 65535, false, false), new PdfFileParam("f", "pdf files to concat: a list of existing pdf files (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf:password)", 65519, true, true), new StringParam("u", "page selection script. You can set a subset of pages to merge. Accepted values: \"all\" or \"num1-num2\" or \"num-\" or \"num1,num2-num3..\" (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf -u all:all:), (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf -f /tmp/file3.pdf -u all:12-14:32,12-14,34-:) to merge file1.pdf and pages 12,13,14 of file2.pdf. If -u is not set default behaviour is to merge document completely", true), new StringParam("r", "pages rotation. You can set pages rotation. Accepted string is a sequence of \"pagenumber:rotationdegrees,\" where pagenumber can be a number or one among \"all\", \"odd\", \"even\" and where rotationdegrees can be \"90\", \"180\" or \"270\". Pages will be rotate clockwise", true), new FileParam("l", "xml or csv file containing pdf files list to concat. If csv file in comma separated value format; if xml file <filelist><file value=\"filepath\" /></filelist>", 65515, true, false), new FileParam("d", "directory containing pdf files to concat. Files will be merged in alphabetical order.", 65511, true, false), new BooleanParam("copyfields", "input pdf documents contain forms (high memory usage)")));
    private final List concatArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[concat]}", new String[]{"concat"}, false)));
    private static final String CONCAT_HELP_TEXT = "Concatenate pdf files. \nyou must specify the '-o /home/user/outfile.pdf' option to set the output file and the source file list:\n'-f /tmp/file1.pdf /tmp/file2.pdf:password -f /tmp/file3.pdf [...]' to specify a file list or at least one file to concat (use filename:password if the file is password protected).\n'-l /tmp/list.csv' a csv file containing the list of files to concat, separated by a comma.\n'-l /tmp/list.xml' a xml file containing the list of files to concat, <filelist><file value=\"filepath\" /></filelist>\n'-d /tmp' a directory containing the pdf files to concat in alphabetical order.\nNote: You can use only one of these options per command line (-f, -l, -d)\n'-r 2:90,3:270' is optional to set pages rotation. (EX. -r 2:90,3:270 will rotate page number 2 of 90 degrees clockwise and page number 3 of 270 degrees clockwise)\n'-u All:All:3-15:16,19-24' is optional to set pages selection. You can set a subset of pages to merge. Accepted values: \"all\"or a comma separated list of \"num\", \"num-\", \"num1-num2\" (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf -u all:all:), (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf -u all:12-14:) to merge file1.pdf and pages 12,13,14 of file2.pdf. If -u is not set default behaviour is to merge document completely\n'-copyfields' input pdf documents contain forms (high memory usage).\n";
    private static final String CONCAT_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -o /tmp/outfile.pdf -f /tmp/1.pdf:password -f /tmp/2.pdf concat\nExample: java -jar pdfsam-console-2.4.3e.jar -l c:\\docs\\list.csv concat";

    public Collection getArguments() {
        return this.concatArguments;
    }

    public String getHelpExamples() {
        return CONCAT_EXAMPLE;
    }

    public String getHelpMessage() {
        return CONCAT_HELP_TEXT;
    }

    public Collection getOptions() {
        return this.concatOptions;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }
}

