/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.MixParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.MixException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;

public class AlternateMixCmdExecutor
extends AbstractCmdExecutor {
    private PdfReader pdfReader1 = null;
    private PdfReader pdfReader2 = null;
    private PdfCopy pdfWriter = null;
    private static final Logger LOG = Logger.getLogger(AlternateMixCmdExecutor.class.getPackage().getName());

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof MixParsedCommand) {
            MixParsedCommand inputCommand = (MixParsedCommand)parsedCommand;
            this.setWorkIndeterminate();
            Document pdfDocument = null;
            int[] limits1 = new int[]{1, 1};
            int[] limits2 = new int[]{1, 1};
            try {
                int current2;
                File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                this.pdfReader1 = PdfUtility.readerFor(inputCommand.getFirstInputFile());
                this.pdfReader1.removeUnusedObjects();
                this.pdfReader1.consolidateNamedDestinations();
                limits1[1] = this.pdfReader1.getNumberOfPages();
                this.pdfReader2 = PdfUtility.readerFor(inputCommand.getSecondInputFile());
                this.pdfReader2.removeUnusedObjects();
                this.pdfReader2.consolidateNamedDestinations();
                limits2[1] = this.pdfReader2.getNumberOfPages();
                pdfDocument = new Document(this.pdfReader1.getPageSizeWithRotation(1));
                LOG.debug("Creating a new document.");
                this.pdfWriter = new PdfCopy(pdfDocument, (OutputStream)new FileOutputStream(tmpFile));
                this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                pdfDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                pdfDocument.open();
                boolean finished1 = false;
                boolean finished2 = false;
                int current1 = inputCommand.isReverseFirst() ? limits1[1] : limits1[0];
                int n = current2 = inputCommand.isReverseSecond() ? limits2[1] : limits2[0];
                while (!finished1 || !finished2) {
                    PdfImportedPage page;
                    int i;
                    if (!finished1) {
                        for (i = 0; i < inputCommand.getStep() && !finished1; ++i) {
                            if (current1 >= limits1[0] && current1 <= limits1[1]) {
                                page = this.pdfWriter.getImportedPage(this.pdfReader1, current1);
                                this.pdfWriter.addPage(page);
                                current1 = inputCommand.isReverseFirst() ? current1 - 1 : current1 + 1;
                                continue;
                            }
                            LOG.info("First file processed.");
                            this.pdfReader1.close();
                            finished1 = true;
                        }
                    }
                    if (finished2) continue;
                    for (i = 0; i < inputCommand.getSecondStep() && !finished2; ++i) {
                        if (current2 >= limits2[0] && current2 <= limits2[1] && !finished2) {
                            page = this.pdfWriter.getImportedPage(this.pdfReader2, current2);
                            this.pdfWriter.addPage(page);
                            current2 = inputCommand.isReverseSecond() ? current2 - 1 : current2 + 1;
                            continue;
                        }
                        LOG.info("Second file processed.");
                        this.pdfReader2.close();
                        finished2 = true;
                    }
                }
                this.pdfWriter.freeReader(this.pdfReader1);
                this.pdfWriter.freeReader(this.pdfReader2);
                pdfDocument.close();
                FileUtility.renameTemporaryFile(tmpFile, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                LOG.debug("File " + inputCommand.getOutputFile().getCanonicalPath() + " created.");
                LOG.info("Alternate mix with step first document " + inputCommand.getStep() + " and step second document " + inputCommand.getSecondStep() + " completed.");
            }
            catch (Exception e) {
                throw new MixException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader1);
        this.closePdfReader(this.pdfReader2);
        this.closePdfWriter((PdfWriter)this.pdfWriter);
    }
}

